/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.StdConfig;

public class DisposeInvToBusApOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(DisposeInvToBusApOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List props = e.getFieldKeys();
        props.add("modifytime");
        props.add("createtime");
        props.add("entry.amount");
        props.add("entry.e_amountbase");
        props.add("sourcebilltype");
        props.add("e_sourcebillentryid");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] finApBills = e.getDataEntities();
        ArrayList<Long> disPoseFinIds = new ArrayList<Long>(2);
        String upgradeDateStr = StdConfig.get("businvupgradeDate");
        if (upgradeDateStr == null) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date upgradeDate = sdf.parse(upgradeDateStr);
            if (upgradeDate == null) {
                return;
            }
            Date beginDate = DateUtils.getNextDay(upgradeDate, -180);
            for (DynamicObject finBill : finApBills) {
                Date modifydate = finBill.getDate("modifytime");
                String sourceBillType = finBill.getString("sourcebilltype");
                if (!modifydate.after(beginDate) || !modifydate.before(upgradeDate) || !"ap_busbill".equals(sourceBillType) && !"ap_invoice".equals(sourceBillType)) continue;
                disPoseFinIds.add(finBill.getLong("id"));
            }
        }
        catch (ParseException p) {
            logger.info("message", (Object)p.getMessage());
        }
        this.disPoseSrcBus(disPoseFinIds);
    }

    private void disPoseSrcBus(List<Long> finBillIds) {
        DynamicObject[] busBills;
        if (finBillIds.size() == 0) {
            return;
        }
        DynamicObjectCollection finBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"detailentry.e_sourcebillentryid,detailentry.e_amount,detailentry.e_amountbase", (QFilter[])new QFilter[]{new QFilter("id", "in", finBillIds)});
        ArrayList<Long> busEntryIds = new ArrayList<Long>(2);
        HashMap<Long, Tuple> disPoseMap = new HashMap<Long, Tuple>(2);
        for (DynamicObject finBill : finBills) {
            String srcEntryIdStr = finBill.getString("detailentry.e_sourcebillentryid");
            if (srcEntryIdStr == null || "".equals(srcEntryIdStr)) continue;
            Long srcEntryId = Long.valueOf(srcEntryIdStr);
            BigDecimal amount = finBill.getBigDecimal("detailentry.e_amount");
            BigDecimal locamount = finBill.getBigDecimal("detailentry.e_amountbase");
            busEntryIds.add(srcEntryId);
            Tuple tuple = (Tuple)disPoseMap.get(srcEntryId);
            if (tuple == null) {
                tuple = Tuple.create((Object)amount, (Object)locamount);
                disPoseMap.put(srcEntryId, tuple);
                continue;
            }
            disPoseMap.put(srcEntryId, Tuple.create((Object)((BigDecimal)tuple.item1).add(amount), (Object)((BigDecimal)tuple.item2).add(locamount)));
        }
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((String)"ap_busbill", (String)"entry.id,entry.e_invoicednotaxamt,entry.e_invnotaxlocalamt,entry.e_uninvnotaxamt,entry.e_uninvnotaxlocalamt", (QFilter[])new QFilter[]{new QFilter("entry.id", "in", busEntryIds)})) {
            DynamicObjectCollection entrys = busBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                Long entryId = entry.getLong("id");
                Tuple tuple = (Tuple)disPoseMap.get(entryId);
                if (tuple == null) continue;
                BigDecimal disAmt = (BigDecimal)tuple.item1;
                BigDecimal disLocAmt = (BigDecimal)tuple.item2;
                entry.set("e_invoicednotaxamt", (Object)entry.getBigDecimal("e_invoicednotaxamt").subtract(disAmt));
                entry.set("e_invnotaxlocalamt", (Object)entry.getBigDecimal("e_invnotaxlocalamt").subtract(disLocAmt));
                entry.set("e_uninvnotaxamt", (Object)entry.getBigDecimal("e_uninvnotaxamt").add(disAmt));
                entry.set("e_uninvnotaxlocalamt", (Object)entry.getBigDecimal("e_uninvnotaxlocalamt").add(disLocAmt));
            }
        }
        SaveServiceHelper.save((DynamicObject[])busBills);
    }
}

