/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;

public class DisposeUnWoffAmtOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(DisposeUnWoffAmtOp.class);
    private String upgradeDateStr;
    private boolean isAr = false;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List props = e.getFieldKeys();
        props.add("entry.e_amount");
        props.add("entry.e_localamt");
        props.add("entry.e_tax");
        props.add("entry.e_taxlocalamt");
        props.add("entry.e_unwoffnotaxamt");
        props.add("entry.e_unwoffnotaxlocamt");
        props.add("entry.e_unwofftax");
        props.add("entry.e_unwofftaxlocal");
        props.add("e_srcbillid");
        props.add("e_srcentryid");
        props.add("sourcebilltype");
        props.add("isadjust");
        props.add("createtime");
        props.add("modifytime");
        props.add("srcfinbillid");
        String name = this.billEntityType.getName();
        this.isAr = "ar_busbill".equals(name);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] busBills = e.getDataEntities();
        Map optionVariables = this.operateOption.getVariables();
        String isWriteBack = null;
        if (!ObjectUtils.isEmpty((Object)optionVariables)) {
            isWriteBack = (String)optionVariables.get("history_writeback");
        }
        if ("false".equals(isWriteBack)) {
            return;
        }
        this.disPoseSrcBus(busBills);
    }

    private void disPoseSrcBus(DynamicObject[] busBills) {
        DynamicObject[] srcBusBills;
        HashMap<Long, DisPoseParam> disPoseMap = new HashMap<Long, DisPoseParam>(2);
        HashSet<Long> srcBusIds = new HashSet<Long>(2);
        HashSet<Long> busEntryIds = new HashSet<Long>(2);
        for (DynamicObject busBill : busBills) {
            String busEntityKey = busBill.getString("sourcebilltype");
            boolean isadjust = busBill.getBoolean("isadjust");
            if (!busEntityKey.contains("busbill") || !isadjust || !this.judge(busBill)) continue;
            DynamicObjectCollection entrys = busBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                DisPoseParam disPoseParam;
                srcBusIds.add(entry.getLong("e_srcbillid"));
                Long srcEntryId = entry.getLong("e_srcentryid");
                busEntryIds.add(srcEntryId);
                if (disPoseMap.get(srcEntryId) == null) {
                    disPoseParam = new DisPoseParam();
                    disPoseParam.e_amount = entry.getBigDecimal("e_amount");
                    disPoseParam.e_localamt = entry.getBigDecimal("e_localamt");
                    disPoseParam.e_tax = entry.getBigDecimal("e_tax");
                    disPoseParam.e_taxlocamt = entry.getBigDecimal("e_taxlocalamt");
                    disPoseMap.put(srcEntryId, disPoseParam);
                    continue;
                }
                disPoseParam = (DisPoseParam)disPoseMap.get(srcEntryId);
                disPoseParam.e_amount = disPoseParam.e_amount.add(entry.getBigDecimal("e_amount"));
                disPoseParam.e_localamt = disPoseParam.e_localamt.add(entry.getBigDecimal("e_localamt"));
                disPoseParam.e_tax = disPoseParam.e_tax.add(entry.getBigDecimal("e_tax"));
                disPoseParam.e_taxlocamt = disPoseParam.e_taxlocamt.add(entry.getBigDecimal("e_taxlocalamt"));
            }
        }
        for (DynamicObject srcBusBill : srcBusBills = BusinessDataServiceHelper.load((String)this.billEntityType.getName(), (String)"entry.id,entry.e_unwoffnotaxamt,entry.e_unwoffnotaxlocamt,entry.e_unwofftax,entry.e_unwofftaxlocal", (QFilter[])new QFilter[]{new QFilter("entry.id", "in", busEntryIds)})) {
            DynamicObjectCollection entrys = srcBusBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                Long entryId = entry.getLong("id");
                DisPoseParam disPoseParam = (DisPoseParam)disPoseMap.get(entryId);
                if (disPoseParam == null) continue;
                entry.set("e_unwoffnotaxamt", (Object)entry.getBigDecimal("e_unwoffnotaxamt").subtract(disPoseParam.e_amount));
                entry.set("e_unwoffnotaxlocamt", (Object)entry.getBigDecimal("e_unwoffnotaxlocamt").subtract(disPoseParam.e_localamt));
                entry.set("e_unwofftax", (Object)entry.getBigDecimal("e_unwofftax").subtract(disPoseParam.e_tax));
                entry.set("e_unwofftaxlocal", (Object)entry.getBigDecimal("e_unwofftaxlocal").subtract(disPoseParam.e_taxlocamt));
            }
        }
        SaveServiceHelper.save((DynamicObject[])srcBusBills);
        if (srcBusIds.size() > 0) {
            String updatesql = this.isAr ? "update t_ar_busbill a set funwoffnotaxamt=(select sum(funwoffnotaxamt) from t_ar_busbillentry b where a.fid=b.fid),funwoffnotaxlocamt=(select sum(funwoffnotaxlocamt) from t_ar_busbillentry c where a.fid =c.fid),funwofftax=(select sum(funwofftax) from t_ar_busbillentry d where a.fid =d.fid),funwofftaxlocal=(select sum(funwofftaxlocal) from t_ar_busbillentry e where a.fid =e.fid) where fid in (" + StringUtils.join((Object[])srcBusIds.toArray(), (String)",") + ");" : "update t_ap_busbill a set funwoffnotaxamt=(select sum(funwoffnotaxamt) from t_ap_busbillentry b where a.fid=b.fid),funwoffnotaxlocamt=(select sum(funwoffnotaxlocamt) from t_ap_busbillentry c where a.fid =c.fid),funwofftax=(select sum(funwofftax) from t_ap_busbillentry d where a.fid =d.fid),funwofftaxlocal=(select sum(funwofftaxlocal) from t_ap_busbillentry e where a.fid =e.fid) where fid in (" + StringUtils.join((Object[])srcBusIds.toArray(), (String)",") + ");";
            DB.execute((DBRoute)new DBRoute("fi"), (String)updatesql);
            logger.info("----DisposeUnWoffAmtOp-----success:srcBusIds.size:" + srcBusIds.size());
        }
    }

    private boolean judge(DynamicObject dataEntity) {
        boolean flag = false;
        Date modifytime = dataEntity.getDate("modifytime");
        if (this.upgradeDateStr == null) {
            this.upgradeDateStr = StdConfig.get("businvupgradeDate");
            logger.info("DisposeUnWoffAmtOp.judge.upgradeDateStr:" + this.upgradeDateStr);
        }
        if (EmptyUtils.isEmpty(this.upgradeDateStr)) {
            this.upgradeDateStr = "";
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date upgradeDate = null;
        try {
            upgradeDate = sdf.parse(this.upgradeDateStr);
        }
        catch (ParseException parseException) {
            logger.error("context", (Object)parseException.getMessage());
        }
        if (upgradeDate == null) {
            return false;
        }
        Date beginDate = DateUtils.getNextDay(upgradeDate, -180);
        if (modifytime != null && upgradeDate != null && modifytime.before(upgradeDate) && modifytime.after(beginDate)) {
            flag = true;
        }
        return flag;
    }

    static class DisPoseParam {
        BigDecimal e_amount;
        BigDecimal e_localamt;
        BigDecimal e_tax;
        BigDecimal e_taxlocamt;

        DisPoseParam() {
        }
    }
}

