/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.util.Arrays;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.helper.TaxHelper;
import kd.fi.arapcommon.tax.FinTaxCodeServiceImpl;

public class FinBatchCalculateTaxOp
extends AbstractOperationServicePlugIn {
    private String entityName;

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] datas = e.getDataEntities();
        int size = datas.length;
        if (size <= 0) {
            return;
        }
        boolean ar = datas[0].getDataEntityType().getName().contains("ar");
        boolean needTax = TaxHelper.isNeedTax(datas[0].getLong("org.id"), ar);
        if (!needTax) {
            return;
        }
        Object[] billIds = (Long[])Arrays.stream(datas).map(entity -> entity.getLong("id")).toArray(Long[]::new);
        this.entityName = datas[0].getDataEntityType().getName();
        DynamicObject billObj = BusinessDataServiceHelper.newDynamicObject((String)this.entityName);
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])billIds, (DynamicObjectType)billObj.getDynamicObjectType());
        FinTaxCodeServiceImpl service = new FinTaxCodeServiceImpl();
        service.setTax(bills);
        OperationServiceHelper.executeOperate((String)"save", (String)this.entityName, (DynamicObject[])bills, (OperateOption)OperateOption.create());
    }
}

