/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.opplugin.AsyncSupportiveOp;
import kd.fi.arapcommon.util.EmptyUtils;

@Deprecated
public class FinBillAudit4SettleOp
extends AsyncSupportiveOp {
    private static final Log logger = LogFactory.getLog(FinBillAudit4SettleOp.class);

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
    }

    @Override
    protected void asyncExecute(DynamicObject finbill, String customParams) {
        Long sourcebillid = finbill.getLong("sourcebillid");
        List results = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"ism", (String)"SettleBillService", (String)"getAllSettleBillBySingle", (Object[])new Object[]{sourcebillid});
        if (!ObjectUtils.isEmpty((Object)results)) {
            for (Map result : results) {
                OperationResult opresult;
                List<DynamicObject> vEntries;
                String srcEntity = (String)result.get("settlebilltype");
                Long vbillPk = (Long)result.get("settlebillid");
                String trgEntity = this.getTrgEntity(srcEntity);
                List<DynamicObject> trgBills = this.buildTargetBill(srcEntity, trgEntity, vbillPk, vEntries = this.getVBillEntriesByFin(srcEntity, vbillPk, finbill));
                if (trgBills == null || trgBills.isEmpty() || (opresult = OperationServiceHelper.executeOperate((String)"save", (String)trgEntity, (DynamicObject[])trgBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create())).isSuccess()) continue;
                StringBuilder sb = new StringBuilder();
                List validateErrors = opresult.getValidateResult().getValidateErrors();
                for (ValidateResult vr : validateErrors) {
                    List allErrorInfo = vr.getAllErrorInfo();
                    for (OperateErrorInfo errInfo : allErrorInfo) {
                        sb.append(errInfo.getPkValue());
                        sb.append(" -- ");
                        sb.append(errInfo.getMessage());
                        sb.append(',');
                    }
                }
            }
        } else {
            logger.info("------SettleBillService.getAllSettleBillBySingle------resultMap = null!");
        }
    }

    private List<DynamicObject> getVBillEntriesByFin(String srcEntity, Long vbillPk, DynamicObject finbill) {
        ArrayList<DynamicObject> vEntries = new ArrayList<DynamicObject>();
        DynamicObject vbill = BusinessDataServiceHelper.loadSingle((Object)vbillPk, (String)srcEntity);
        DynamicObjectCollection vEntryColl = vbill.getDynamicObjectCollection("billentry");
        String finEntityKey = finbill.getDataEntityType().getName();
        if ("ar_finarbill".equals(finEntityKey)) {
            DynamicObjectCollection finEntries = finbill.getDynamicObjectCollection("entry");
            for (DynamicObject finEntry : finEntries) {
                Long srcbillentryid = finEntry.getLong("e_srcentryid");
                for (DynamicObject vEntry : vEntryColl) {
                    if (!srcbillentryid.equals(vEntry.getLong("srcbillentryid"))) continue;
                    vEntry.set("qty", (Object)finEntry.getBigDecimal("e_quantity"));
                    vEntries.add(vEntry);
                }
            }
        } else {
            DynamicObjectCollection finEntries = finbill.getDynamicObjectCollection("detailentry");
            for (DynamicObject finEntry : finEntries) {
                Long srcbillentryid = finEntry.getLong("e_sourcebillentryid");
                for (DynamicObject vEntry : vEntryColl) {
                    if (!srcbillentryid.equals(vEntry.getLong("srcbillentryid"))) continue;
                    vEntry.set("qty", (Object)finEntry.getBigDecimal("quantity"));
                    vEntries.add(vEntry);
                }
            }
        }
        return vEntries;
    }

    private List<DynamicObject> buildTargetBill(String srcEntity, String trgEntity, Long vbillPk, List<DynamicObject> vEntries) {
        ArrayList<Long> srcPks = new ArrayList<Long>();
        srcPks.add(vbillPk);
        List<DynamicObject> trgBills = BOTPHelper.push(srcEntity, trgEntity, srcPks);
        for (DynamicObject trgBill : trgBills) {
            BigDecimal pricetaxtotal;
            if (EmptyUtils.isEmpty(trgBill.getString("billno"))) {
                String billno = CodeRuleServiceHelper.getNumber((String)trgEntity, (DynamicObject)trgBill, (String)trgBill.getDynamicObject("org").getPkValue().toString());
                trgBill.set("billno", (Object)billno);
            }
            boolean isAr = "ar_finarbill".equals(trgEntity);
            BigDecimal rate = trgBill.getBigDecimal("exchangerate");
            ArrayList<DynamicObject> entryList = new ArrayList<DynamicObject>();
            DynamicObjectCollection entries = trgBill.getDynamicObjectCollection(isAr ? "entry" : "detailentry");
            for (DynamicObject entry : entries) {
                for (DynamicObject vEntry : vEntries) {
                    if (!vEntry.getPkValue().equals(entry.getLong(isAr ? "e_srcentryid" : "e_sourcebillentryid"))) continue;
                    this.setQtyAmtField(isAr, entry, vEntry, rate);
                    entryList.add(entry);
                }
            }
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal tax = BigDecimal.ZERO;
            if (!ObjectUtils.isEmpty((Object)entries)) {
                entries.clear();
                for (DynamicObject entry : entryList) {
                    amount = amount.add(entry.getBigDecimal("e_amount"));
                    tax = tax.add(entry.getBigDecimal("e_tax"));
                    entries.add((Object)entry);
                }
            }
            if ((pricetaxtotal = amount.add(tax)).compareTo(trgBill.getBigDecimal(isAr ? "recamount" : "pricetaxtotal")) == 0) continue;
            BigDecimal pricetaxtotallocal = pricetaxtotal.multiply(rate);
            trgBill.set("amount", (Object)amount);
            trgBill.set("tax", (Object)tax);
            trgBill.set(isAr ? "localamt" : "amountbase", (Object)amount.multiply(rate));
            trgBill.set(isAr ? "recamount" : "pricetaxtotal", (Object)pricetaxtotal);
            trgBill.set(isAr ? "reclocalamt" : "pricetaxtotalbase", (Object)pricetaxtotallocal);
            trgBill.set("unverifyamount", (Object)amount);
            trgBill.set("unsettleamount", (Object)pricetaxtotal);
            trgBill.set(isAr ? "unsettlelocalamt" : "unsettleamountbase", (Object)pricetaxtotallocal);
            DynamicObjectCollection planEntrys = trgBill.getDynamicObjectCollection("planentity");
            for (int i = 0; i < planEntrys.size(); ++i) {
                DynamicObject planentry = (DynamicObject)planEntrys.get(i);
                if (i == 0) {
                    planentry.set("planpricetax", (Object)pricetaxtotal);
                    planentry.set("planpricetaxloc", (Object)pricetaxtotallocal);
                    planentry.set("unplanlockamt", (Object)pricetaxtotal);
                    planentry.set("unplansettleamt", (Object)pricetaxtotal);
                    planentry.set("unplansettlelocamt", (Object)pricetaxtotallocal);
                    continue;
                }
                planEntrys.remove(i);
            }
        }
        return trgBills;
    }

    private void setQtyAmtField(boolean isAr, DynamicObject trgEntry, DynamicObject vEntry, BigDecimal rate) {
        BigDecimal quantity = vEntry.getBigDecimal("qty");
        if (trgEntry.getBigDecimal(isAr ? "e_quantity" : "quantity").compareTo(quantity) != 0) {
            BigDecimal price = trgEntry.getBigDecimal(isAr ? "e_actunitprice" : "actprice");
            BigDecimal amount = quantity.multiply(price);
            trgEntry.set("e_amount", (Object)amount);
            trgEntry.set(isAr ? "e_localamt" : "e_amountbase", (Object)amount.multiply(rate));
            BigDecimal tax = quantity.multiply(price).multiply(trgEntry.getBigDecimal(isAr ? "e_taxrate" : "taxrate")).divide(new BigDecimal("100"));
            trgEntry.set("e_tax", (Object)tax);
            String discountMode = trgEntry.getString(isAr ? "e_discountmode" : "discountmode");
            BigDecimal discountRate = trgEntry.getBigDecimal(isAr ? "e_discountrate" : "discountrate");
            BigDecimal absQty = quantity.abs();
            if ("PERCENT".equals(discountMode)) {
                trgEntry.set(isAr ? "e_discountamount" : "discountamount", (Object)absQty.multiply(trgEntry.getBigDecimal(isAr ? "e_taxunitprice" : "pricetax")).multiply(discountRate).divide(new BigDecimal("100")));
            } else if ("PERUNIT".equals(discountMode)) {
                trgEntry.set(isAr ? "e_discountamount" : "discountamount", (Object)absQty.multiply(discountRate).multiply(BigDecimal.ONE.add(trgEntry.getBigDecimal(isAr ? "e_taxrate" : "taxrate").divide(new BigDecimal("100")))));
            }
            trgEntry.set(isAr ? "e_discountamount" : "discountlocalamt", (Object)trgEntry.getBigDecimal(isAr ? "e_discountamount" : "discountamount").multiply(rate));
            BigDecimal recamount = amount.add(tax);
            trgEntry.set(isAr ? "e_recamount" : "e_pricetaxtotal", (Object)recamount);
            BigDecimal reclocalamt = recamount.multiply(rate);
            trgEntry.set(isAr ? "e_reclocalamt" : "e_pricetaxtotalbase", (Object)reclocalamt);
            trgEntry.set(isAr ? "e_unverifyqty" : "unverifyquantity", (Object)quantity);
            trgEntry.set(isAr ? "e_unverifyamt" : "e_unverifyamount", (Object)amount);
            trgEntry.set(isAr ? "e_unlockamt" : "unlockamt", (Object)recamount);
            trgEntry.set(isAr ? "e_unsettleamt" : "unsettleamt", (Object)recamount);
            trgEntry.set(isAr ? "e_unsettlelocalamt" : "unsettleamtbase", (Object)reclocalamt);
            if (isAr) {
                trgEntry.set("e_unconfirmamt", (Object)amount);
            }
        }
    }

    private String getTrgEntity(String srcEntity) {
        String trgEntity = null;
        List rules = ConvertMetaServiceHelper.loadRules((String)srcEntity, (String)"ar_finarbill");
        if (ObjectUtils.isEmpty((Object)rules)) {
            rules = ConvertMetaServiceHelper.loadRules((String)srcEntity, (String)"ap_finapbill");
        }
        if (!ObjectUtils.isEmpty((Object)rules)) {
            for (ConvertRuleElement element : rules) {
                if (!element.isEnabled()) continue;
                trgEntity = element.getTargetEntityNumber();
                break;
            }
        } else {
            ErrorCode ec = new ErrorCode("ruleNotExist", String.format(ResManager.loadKDString((String)"\u6e90\u5355%s\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"FinBillAudit4SettleOp_0", (String)"fi-arapcommon", (Object[])new Object[0]), srcEntity));
            throw new KDBizException(ec, new Object[0]);
        }
        return trgEntity;
    }
}

