/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.init.GlImportLogService;
import kd.fi.arapcommon.init.GlImportService;
import kd.fi.arapcommon.validator.GlImportValidator;
import org.apache.commons.lang.StringUtils;

public class GlImportSchemeExecuteOp
extends AbstractOperationServicePlugIn {
    private final long userId = RequestContext.get().getCurrUserId();
    private final Date currentDate = new Date();
    private int totalCount = 0;
    private int successCount = 0;

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new GlImportValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.operationResult.getSuccessPkIds().clear();
        this.operationResult.setShowMessage(false);
        for (DynamicObject scheme : e.getDataEntities()) {
            this.executeImpt(scheme);
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List list = e.getFieldKeys();
        list.add("appid");
        list.add("org");
        list.add("useorg");
        list.add("e_account");
        list.add("e_balancetype");
        list.add("e_asstactitem");
        list.add("e_entityobject");
        list.add("e_balancedc");
        list.add("e_billtype");
        list.add("e_biztype");
        list.add("e_asstacttype");
        list.add("e_paymenttype");
        list.add("e_rectype");
        list.add("e_arpayproperty");
        list.add("e_appayproperty");
        list.add("e_linetype");
        list.add("e_material");
        list.add("e_expenseitem");
        list.add("e_balancemappingfield");
        list.add("entry.seq");
        for (int i = 1; i <= 6; ++i) {
            list.add("e_asstactitem" + i);
            list.add("e_mappingfield" + i);
            list.add("e_mappingfieldname" + i);
        }
    }

    private void executeImpt(DynamicObject scheme) {
        String appId = scheme.getString("appid");
        DynamicObject org = scheme.getDynamicObject("useorg");
        GlImportService imptService = new GlImportService(StringUtils.contains((String)appId, (String)"ar"), (Long)org.getPkValue());
        DynamicObject importLog = GlImportLogService.newImportLog(scheme, this.userId);
        try {
            DynamicObjectCollection entries = scheme.getDynamicObjectCollection("entry");
            Set<Long> accountPks = entries.stream().map(i -> i.getLong("e_account.id")).collect(Collectors.toSet());
            Map<Long, List<String>> errAcctMap = imptService.deleteInitBill(accountPks);
            this.buildErrorInfo(errAcctMap, entries);
            Set imptEntries = entries.stream().filter(e -> !errAcctMap.containsKey(e.getLong("e_account.id"))).collect(Collectors.toSet());
            ArrayList<DynamicObject> glImports = new ArrayList<DynamicObject>(0);
            for (Object entry : imptEntries) {
                Map<String, Object> map = imptService.execute((DynamicObject)entry);
                this.buildResultInfo(map, (DynamicObject)entry);
                List successPks = (List)map.get("successPks");
                if (successPks.isEmpty()) continue;
                String entityKey = entry.getString("e_entityobject");
                glImports.addAll(this.buildGlImportBill(appId, org, entry.getDynamicObject("e_account"), entityKey, successPks, scheme.getPkValue()));
            }
            if (!glImports.isEmpty()) {
                Map<String, Long> entityMap = glImports.stream().collect(Collectors.groupingBy(e -> e.getString("entitykey"), Collectors.counting()));
                for (Map.Entry entry : entityMap.entrySet()) {
                    GlImportLogService.updateSuccDataCount(importLog, (String)entry.getKey(), ((Long)entry.getValue()).intValue());
                }
                SaveServiceHelper.save((DynamicObject[])glImports.toArray(new DynamicObject[0]));
            }
            this.buildOperationResultInfo();
            StringBuilder errorMessage = new StringBuilder();
            List errorInfos = this.operationResult.getAllErrorInfo();
            errorInfos.forEach(e -> errorMessage.append(e.getMessage()));
            GlImportLogService.updateErrorInfo(importLog, errorMessage.toString());
        }
        catch (Exception e2) {
            String message = ArApHelper.getStackTraceMessage(e2);
            GlImportLogService.updateErrorInfo(importLog, message);
            throw e2;
        }
        finally {
            GlImportLogService.updateProgressComplete(importLog);
        }
    }

    private void buildOperationResultInfo() {
        this.operationResult.setMessage(String.format(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u5171%1$s\u5f20\uff0c\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"GlImportSchemeExecuteOp_1", (String)"fi-arapcommon", (Object[])new Object[0]), this.totalCount, this.successCount, this.totalCount - this.successCount));
        if (this.totalCount == 0 && this.operationResult.getAllErrorInfo().size() == 0) {
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            String message = ResManager.loadKDString((String)"\u65b9\u6848\u6240\u9009\u7684\u79d1\u76ee\u4f59\u989d\u4e0d\u6ee1\u8db3\u65b9\u6848\u6761\u4ef6\u3002", (String)"GlImportSchemeExecuteOp_2", (String)"fi-arapcommon", (Object[])new Object[0]);
            errorInfo.setMessage(message);
            errorInfo.setLevel(ErrorLevel.Error);
            this.operationResult.addErrorInfo(errorInfo);
        }
        if (this.totalCount != this.successCount) {
            this.operationResult.setSuccess(false);
        }
    }

    private void buildErrorInfo(Map<Long, List<String>> errAcctMap, DynamicObjectCollection enties) {
        Set accounts = enties.stream().map(e -> e.getDynamicObject("e_account")).collect(Collectors.toSet());
        for (DynamicObject account : accounts) {
            Long accountPk = (Long)account.getPkValue();
            List<String> msgList = errAcctMap.get(accountPk);
            if (msgList == null) continue;
            for (String msg : msgList) {
                String message = String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801%1$s\uff1a%2$s", (String)"GlImportSchemeExecuteOp_0", (String)"fi-arapcommon", (Object[])new Object[0]), account.getString("number"), msg);
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setPkValue((Object)accountPk);
                errorInfo.setMessage(message);
                errorInfo.setLevel(ErrorLevel.Error);
                this.operationResult.addErrorInfo(errorInfo);
            }
            this.totalCount += msgList.size();
        }
    }

    private void buildResultInfo(Map<String, Object> resultMap, DynamicObject entry) {
        int subtotal = (Integer)resultMap.get("subtotal");
        List successPks = (List)resultMap.get("successPks");
        String message = (String)resultMap.get("message");
        boolean isSuccess = (Boolean)resultMap.get("success");
        this.totalCount += subtotal;
        this.successCount += successPks.size();
        if (!isSuccess) {
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setPkValue(entry.getPkValue());
            errorInfo.setMessage(message);
            errorInfo.setLevel(ErrorLevel.Error);
            this.operationResult.addErrorInfo(errorInfo);
        }
    }

    private List<DynamicObject> buildGlImportBill(String appId, DynamicObject org, DynamicObject account, String entityKey, List<Long> billPks, Object schemeid) {
        ArrayList<DynamicObject> glImports = new ArrayList<DynamicObject>(billPks.size());
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"ar_glimportbill");
        for (Long billPk : billPks) {
            DynamicObject glImport = new DynamicObject((DynamicObjectType)dt);
            glImport.set("appid", (Object)appId);
            glImport.set("org", (Object)org);
            glImport.set("schemeid", schemeid);
            glImport.set("account", (Object)account);
            glImport.set("entitykey", (Object)entityKey);
            glImport.set("billid", (Object)billPk);
            glImport.set("creator", (Object)this.userId);
            glImport.set("createtime", (Object)this.currentDate);
            glImports.add(glImport);
        }
        return glImports;
    }
}

