/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.fi.arapcommon.util.StringUtils;

public class MserviceLogReInvokeOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MserviceLogReInvokeOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("issuccess");
        e.getFieldKeys().add("successtime");
        e.getFieldKeys().add("description");
        e.getFieldKeys().add("count");
        e.getFieldKeys().add("exceptioninfo");
        e.getFieldKeys().add("cloudid");
        e.getFieldKeys().add("traceid");
        e.getFieldKeys().add("appid");
        e.getFieldKeys().add("servicename");
        e.getFieldKeys().add("methodname");
        e.getFieldKeys().add("param");
        e.getFieldKeys().add("param_tag");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities;
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject data : dataEntities = e.getDataEntities()) {
            if (data.getBoolean("issuccess")) continue;
            this.reInvokeMservice(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reInvokeMservice(DynamicObject data) {
        String cloudId = data.getString("cloudid");
        String appId = data.getString("appid");
        String serviceName = data.getString("servicename");
        String methodName = data.getString("methodname");
        if (StringUtils.isNotEmpty(cloudId) && StringUtils.isNotEmpty(appId) && StringUtils.isNotEmpty(serviceName) && StringUtils.isNotEmpty(methodName)) {
            try (TXHandle tx = TX.requiresNew((String)"reInvokeMservice");){
                List<Object> paramList = this.getParamList(data);
                DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])paramList.toArray());
                data.set("issuccess", (Object)Boolean.TRUE);
                data.set("successtime", (Object)new Date());
                data.set("exceptioninfo", null);
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message.length() > 2000) {
                    message = message.substring(0, 1999);
                }
                data.set("exceptioninfo", (Object)e.getMessage());
            }
            finally {
                data.set("traceid", (Object)RequestContext.get().getTraceId());
                data.set("count", (Object)(data.getInt("count") + 1));
                SaveServiceHelper.update((DynamicObject)data);
            }
        }
    }

    private List<Object> getParamList(DynamicObject data) {
        String description = data.getString("description");
        String param = data.getString("param_tag");
        List<Object> paramList = SerializationUtils.fromJsonStringToList((String)param, Object.class);
        if ("apverify-cal".equals(description)) {
            paramList = this.handleParam4VerifyCal(paramList, "ap_verifyrecord");
        } else if ("arverify-cal".equals(description)) {
            paramList = this.handleParam4VerifyCal(paramList, "ar_verifyrecord");
        } else if ("costrecord-cal".equals(description)) {
            paramList = this.handleParam4Costrecord(paramList);
        }
        return paramList;
    }

    private List<Object> handleParam4VerifyCal(List<Object> paramList, String entity) {
        LinkedList<Object> newParamList = new LinkedList<Object>();
        newParamList.add(paramList.get(0));
        newParamList.add(paramList.get(1));
        Object param2 = paramList.get(2);
        DynamicObject verifyRecord = BusinessDataServiceHelper.newDynamicObject((String)entity);
        Object[] deserializeArr = DynamicObjectSerializeUtil.deserialize((String)param2.toString(), (DynamicObjectType)verifyRecord.getDynamicObjectType());
        ArrayList<DynamicObject> paramDynObjList = new ArrayList<DynamicObject>(deserializeArr.length);
        for (Object deserializeObj : deserializeArr) {
            if (!(deserializeObj instanceof DynamicObject)) continue;
            paramDynObjList.add((DynamicObject)deserializeObj);
        }
        newParamList.add(paramDynObjList.toArray(new DynamicObject[0]));
        return newParamList;
    }

    private List<Object> handleParam4Costrecord(List<Object> paramList) {
        LinkedList<Object> newparamList = new LinkedList<Object>();
        newparamList.add((String)paramList.get(0));
        newparamList.add(new HashSet((ArrayList)paramList.get(1)));
        newparamList.add(Long.valueOf(String.valueOf(paramList.get(2))));
        newparamList.add((String)paramList.get(3));
        return newparamList;
    }
}

