/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.validator.DecimalScopeValidator;

public class SettleRecordBaseSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(SettleRecordBaseSaveOp.class);
    private List<String> extPropertyList;

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new DecimalScopeValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] srDatas = e.getDataEntities();
        String mainBillEntity = this.getMainBillEntity(srDatas);
        this.extPropertyList = this.getExtProperty(mainBillEntity);
        if (this.extPropertyList.size() > 0) {
            ArrayList<Object> mainBillIds = new ArrayList<Object>(64);
            ArrayList<Object> asstBillIds = new ArrayList<Object>(64);
            for (DynamicObject srData : srDatas) {
                mainBillIds.add(srData.get("mainbillid"));
                DynamicObjectCollection entrys = srData.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entrys) {
                    asstBillIds.add(entry.get("billid"));
                }
            }
            this.processMainExtProp(mainBillIds, srDatas);
            this.processAsstExtProp(asstBillIds, srDatas);
        }
        String settleDate = null;
        Map optionVariables = this.operateOption.getVariables();
        if (!ObjectUtils.isEmpty((Object)optionVariables)) {
            settleDate = (String)optionVariables.get("settleDate");
        }
        if (EmptyUtils.isNotEmpty(settleDate)) {
            for (DynamicObject settleData : srDatas) {
                settleData.set("settledate", (Object)DateUtils.parseDate(settleDate, "yyyy-MM-dd HH:mm:ss"));
            }
        } else {
            BookDateHelper.setSettleDate(srDatas);
        }
    }

    private void processSettleDate(DynamicObject[] srDatas) {
        block9: {
            String relation = srDatas[0].getString("settlerelation");
            String settleType = srDatas[0].getString("settletype");
            boolean isWrittenOff = srDatas[0].getBoolean("iswrittenoff");
            if (isWrittenOff || !SettleTypeEnum.AUTO.getValue().equals(settleType) || !SettleRelationEnum.APPAYSETTLE.getValue().equals(relation) && !SettleRelationEnum.RECSETTLE.getValue().equals(relation)) break block9;
            String mainEntity = srDatas[0].getString("billentity");
            long orgPk = srDatas[0].getLong("org.id");
            String casParam = (String)SystemParameterHelper.getCasParam(orgPk, "cs104");
            logger.info("---cas param cs104:" + casParam + "---");
            String initEntity = "ap_finapbill".equals(mainEntity) ? "ap_init" : "ar_init";
            InitHelper init = new InitHelper(orgPk, initEntity);
            Date currentDate = init.getCurrentDate();
            if ("2".equals(casParam)) {
                Map<Long, Date> casDateMap = this.getCasDateMap(srDatas);
                for (DynamicObject srData : srDatas) {
                    Date finBizDate = srData.getDate("mainbizdate");
                    Date casDate = this.getEntryMaxPayDate(srData, casDateMap);
                    if (ObjectUtils.isEmpty((Object)casDate)) {
                        casDate = new Date();
                    }
                    Date tempDate = finBizDate;
                    if (!ObjectUtils.isEmpty((Object)currentDate) && currentDate.after(tempDate)) {
                        tempDate = currentDate;
                    }
                    if (!ObjectUtils.isEmpty((Object)casDate) && casDate.after(tempDate)) {
                        tempDate = casDate;
                    }
                    tempDate = this.handleSettleDateHMS(tempDate);
                    srData.set("settledate", (Object)tempDate);
                }
            } else {
                for (DynamicObject srData : srDatas) {
                    Date finBizDate = srData.getDate("mainbizdate");
                    Date casBizDate = this.getEntryMaxBizDate(srData);
                    Date tempDate = finBizDate;
                    if (!ObjectUtils.isEmpty((Object)currentDate) && currentDate.after(tempDate)) {
                        tempDate = currentDate;
                    }
                    if (!ObjectUtils.isEmpty((Object)casBizDate) && casBizDate.after(tempDate)) {
                        tempDate = casBizDate;
                    }
                    tempDate = this.handleSettleDateHMS(tempDate);
                    srData.set("settledate", (Object)tempDate);
                }
            }
        }
    }

    private Map<Long, Date> getCasDateMap(DynamicObject[] srDatas) {
        HashMap<Long, Date> casBillMap = new HashMap<Long, Date>();
        ArrayList<Long> billIds = new ArrayList<Long>();
        String mainEntity = srDatas[0].getString("billentity");
        String asstEntity = "ap_finapbill".equals(mainEntity) ? "cas_paybill" : "cas_recbill";
        String dateSelector = "cas_paybill".equals(asstEntity) ? "paydate casdate" : "payeedate casdate";
        for (DynamicObject srData : srDatas) {
            DynamicObjectCollection entryColl = srData.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                billIds.add(entry.getLong("billid"));
            }
        }
        DynamicObjectCollection results = QueryServiceHelper.query((String)asstEntity, (String)("id," + dateSelector), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        for (DynamicObject result : results) {
            casBillMap.put(result.getLong("id"), result.getDate("casdate"));
        }
        return casBillMap;
    }

    private Date getEntryMaxBizDate(DynamicObject srData) {
        DynamicObjectCollection entryColl = srData.getDynamicObjectCollection("entry");
        Date maxBizDate = null;
        for (DynamicObject entry : entryColl) {
            Date billDate = entry.getDate("billdate");
            if (maxBizDate != null && !maxBizDate.before(billDate)) continue;
            maxBizDate = billDate;
        }
        return maxBizDate;
    }

    private Date getEntryMaxPayDate(DynamicObject srData, Map<Long, Date> casDateMap) {
        DynamicObjectCollection entryColl = srData.getDynamicObjectCollection("entry");
        Date maxPayDate = null;
        for (DynamicObject entry : entryColl) {
            Date payDate = casDateMap.get(entry.getLong("billid"));
            if (maxPayDate != null && (maxPayDate == null || payDate == null || !maxPayDate.before(payDate))) continue;
            maxPayDate = payDate;
        }
        return maxPayDate;
    }

    protected void processMainExtProp(List<Object> mainBillIds, DynamicObject[] srDatas) {
        DynamicObject[] mainBills;
        String mainBillEntity = srDatas[0].getString("billentity");
        for (DynamicObject mainBill : mainBills = BusinessDataServiceHelper.load((String)mainBillEntity, (String)String.join((CharSequence)",", this.extPropertyList), (QFilter[])new QFilter[]{new QFilter("id", "in", mainBillIds)})) {
            long mainPk = mainBill.getLong("id");
            DataEntityPropertyCollection properties = mainBill.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                if (property instanceof EntryProp) {
                    this.processEntryExtProp(mainBill, property.getName(), srDatas);
                    continue;
                }
                if (!this.extPropertyList.contains(property.getName())) continue;
                Object propValue = mainBill.get(property.getName());
                for (DynamicObject srData : srDatas) {
                    long mainBillId = srData.getLong("mainbillid");
                    if (mainPk != mainBillId || !EntityMetadataUtils.isExistProperty(srData, property.getName())) continue;
                    srData.set(property.getName(), propValue);
                }
            }
        }
    }

    protected void processAsstExtProp(List<Object> mainBillIds, DynamicObject[] srDatas) {
        DynamicObjectCollection entrys = srDatas[0].getDynamicObjectCollection("entry");
        String asstBillEntity = ((DynamicObject)entrys.get(0)).getString("e_billentity");
        Object[] asstBills = BusinessDataServiceHelper.load((String)asstBillEntity, (String)String.join((CharSequence)",", this.extPropertyList), (QFilter[])new QFilter[]{new QFilter("id", "in", mainBillIds)});
        Object[] otherDatas = this.getOtherDatas(asstBillEntity, mainBillIds);
        if (!ObjectUtils.isEmpty((Object[])otherDatas)) {
            asstBills = (DynamicObject[])ArrayUtils.addAll((Object[])asstBills, (Object[])otherDatas);
        }
        for (Object asstBill : asstBills) {
            long asstPk = asstBill.getLong("id");
            DataEntityPropertyCollection properties = asstBill.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                if (property instanceof EntryProp) {
                    this.processEntryExtProp((DynamicObject)asstBill, property.getName(), srDatas);
                    continue;
                }
                if (!this.extPropertyList.contains(property.getName())) continue;
                Object propValue = asstBill.get(property.getName());
                for (DynamicObject srData : srDatas) {
                    DynamicObjectCollection srEntrys = srData.getDynamicObjectCollection("entry");
                    for (DynamicObject srEntry : srEntrys) {
                        long asstBillId = srEntry.getLong("billid");
                        if (asstPk != asstBillId || !EntityMetadataUtils.isExistProperty(srEntry, "e_" + property.getName())) continue;
                        srEntry.set("e_" + property.getName(), propValue);
                    }
                }
            }
        }
    }

    private DynamicObject[] getOtherDatas(String asstBillEntity, List<Object> mainBillIds) {
        DynamicObject[] asstDatas = null;
        if ("cas_paybill".equals(asstBillEntity)) {
            asstDatas = BusinessDataServiceHelper.load((String)"ap_paidbill", (String)String.join((CharSequence)",", this.extPropertyList), (QFilter[])new QFilter[]{new QFilter("id", "in", mainBillIds)});
        } else if ("ap_paidbill".equals(asstBillEntity)) {
            asstDatas = BusinessDataServiceHelper.load((String)"cas_paybill", (String)String.join((CharSequence)",", this.extPropertyList), (QFilter[])new QFilter[]{new QFilter("id", "in", mainBillIds)});
        } else if ("cas_recbill".equals(asstBillEntity)) {
            asstDatas = BusinessDataServiceHelper.load((String)"ar_receivedbill", (String)String.join((CharSequence)",", this.extPropertyList), (QFilter[])new QFilter[]{new QFilter("id", "in", mainBillIds)});
        } else if ("ar_receivedbill".equals(asstBillEntity)) {
            asstDatas = BusinessDataServiceHelper.load((String)"cas_recbill", (String)String.join((CharSequence)",", this.extPropertyList), (QFilter[])new QFilter[]{new QFilter("id", "in", mainBillIds)});
        }
        return asstDatas;
    }

    protected void processEntryExtProp(DynamicObject bill, String billEntryKey, DynamicObject[] srDatas) {
        long billPk = bill.getLong("id");
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(billEntryKey);
        for (DynamicObject entry : entrys) {
            long billEntryPk = entry.getLong("id");
            DataEntityPropertyCollection entryProperties = entry.getDataEntityType().getProperties();
            for (IDataEntityProperty entryProperty : entryProperties) {
                if (!this.extPropertyList.contains(entryProperty.getName())) continue;
                Object entryPropValue = entry.get(entryProperty.getName());
                for (DynamicObject srData : srDatas) {
                    long mainBillId = srData.getLong("mainbillid");
                    long mainBillEntryId = srData.getLong("mainbillentryid");
                    if (billPk == mainBillId && billEntryPk == mainBillEntryId && EntityMetadataUtils.isExistProperty(srData, entryProperty.getName())) {
                        srData.set(entryProperty.getName(), entryPropValue);
                    }
                    DynamicObjectCollection srEntrys = srData.getDynamicObjectCollection("entry");
                    for (DynamicObject srEntry : srEntrys) {
                        long asstBillId = srEntry.getLong("billid");
                        long asstEntryId = srEntry.getLong("billentryid");
                        if (billPk != asstBillId || billEntryPk != asstEntryId || !EntityMetadataUtils.isExistProperty(srEntry, "e_" + entryProperty.getName())) continue;
                        srEntry.set("e_" + entryProperty.getName(), entryPropValue);
                    }
                }
            }
        }
    }

    private Date handleSettleDateHMS(Date settleDate) {
        if (!"00:00:00".equals(DateUtils.formatString(settleDate, "HH:mm:ss"))) {
            return settleDate;
        }
        try {
            String ymd = DateUtils.formatString(settleDate, "yyyy-MM-dd");
            String hms = DateUtils.formatString(new Date(), "HH:mm:ss");
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ymd + " " + hms);
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    protected List<String> getExtProperty(String billEntity) {
        return BaseDataHelper.getExtProperty(billEntity);
    }

    protected String getMainBillEntity(DynamicObject[] srDatas) {
        return null;
    }

    protected String getAsstBillEntity(DynamicObject[] srDatas) {
        return null;
    }
}

