/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;

public class StdConfigUpdateOp
extends AbstractOperationServicePlugIn {
    private static final String REGION = "ap_stdconfig";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("key");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    String key = dataEntity.getDataEntity().getString("key");
                    if (!"isNewCustomerUseNewSettle".equals(key)) continue;
                    this.addErrorMessage(dataEntity, "isNewCustomerUseNewSettle param not allow delete");
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        this.removeCache(dataEntities);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        this.removeCache(dataEntities);
    }

    private void removeCache(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            String key = (String)StringUtils.defaultIfBlank((CharSequence)dataEntity.getString("key"), (CharSequence)"");
            ConfigCache.remove(REGION, key);
        }
    }
}

