/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.util.QueryUtil;
import kd.fi.arapcommon.validator.DecimalScopeValidator;
import kd.fi.arapcommon.vo.FarmCostVo;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.VerifyRecordVO;

public class VerifyRecordBaseSaveOp
extends AbstractOperationServicePlugIn {
    private List<String> extPropertyList;
    private final QueryUtil queryUtil = new QueryUtil();

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new DecimalScopeValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] datas = e.getDataEntities();
        String recordEntity = datas[0].getDataEntityType().getName();
        this.extPropertyList = BaseDataHelper.getVerifyExtProperty(recordEntity);
        if (this.extPropertyList.size() > 0) {
            ArrayList<Object> mainBillIds = new ArrayList<Object>(64);
            ArrayList<Object> asstBillIds = new ArrayList<Object>(64);
            for (DynamicObject data : datas) {
                mainBillIds.add(data.get("billid"));
                DynamicObjectCollection entrys = data.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entrys) {
                    asstBillIds.add(entry.get("e_billid"));
                }
            }
            this.processMainExtProp(mainBillIds, datas);
            this.processAsstExtProp(asstBillIds, datas);
        }
        this.farmCost(datas);
        BookDateHelper.setVerifyDate(datas);
    }

    private void farmCost(DynamicObject[] datas) {
        DynamicObject record;
        String verifyRelation;
        List<String> farmRelation = this.getFarmRelationList();
        if (farmRelation.contains(verifyRelation = (record = datas[0]).getString("verifyrelation"))) {
            String mainBillType = record.getString("billtype");
            String asstBillType = ((DynamicObject)record.getDynamicObjectCollection("entry").get(0)).getString("e_billtype");
            HashSet<Long> mainIds = new HashSet<Long>(datas.length);
            HashSet<Long> mainEntryIds = new HashSet<Long>(datas.length);
            HashSet<Long> asstIds = new HashSet<Long>(datas.length);
            HashSet<Long> asstEntryIds = new HashSet<Long>(datas.length);
            HashSet<Long> mainReIds = new HashSet<Long>(datas.length);
            HashSet<Long> mainReEntryIds = new HashSet<Long>(datas.length);
            HashSet<Long> asstReIds = new HashSet<Long>(datas.length);
            HashSet<Long> asstReEntryIds = new HashSet<Long>(datas.length);
            Map<Object, Object> mainFarmVos = new HashMap(datas.length);
            Map<Object, Object> asstFarmVos = new HashMap(datas.length);
            for (DynamicObject data : datas) {
                Long mainId = data.getLong("billid");
                Long mainEntryId = data.getLong("billentryid");
                mainIds.add(mainId);
                mainEntryIds.add(mainEntryId);
                BigDecimal mainQty = data.getBigDecimal("qty");
                BigDecimal mainVerifyQty = data.getBigDecimal("verifyqty");
                if (mainQty.compareTo(mainVerifyQty) != 0) {
                    mainReIds.add(mainId);
                    mainReEntryIds.add(mainEntryId);
                }
                DynamicObjectCollection entry = data.getDynamicObjectCollection("entry");
                for (DynamicObject asstBill : entry) {
                    BigDecimal asstVerifyQty;
                    Long asstId = asstBill.getLong("e_billid");
                    Long asstEntryId = asstBill.getLong("e_billentryid");
                    asstIds.add(asstId);
                    asstEntryIds.add(asstEntryId);
                    BigDecimal asstQty = asstBill.getBigDecimal("e_qty");
                    if (asstQty.compareTo(asstVerifyQty = asstBill.getBigDecimal("e_verifyqty")) == 0) continue;
                    asstReIds.add(asstId);
                    asstReEntryIds.add(asstEntryId);
                }
            }
            if ("im_purinbill".equals(mainBillType) || "ap_finapbill".equals(mainBillType)) {
                Map<Long, Tuple<BigDecimal, BigDecimal>> mainVerifyRecord = VerifyRecordBaseSaveOp.getBillVerifyRecord(mainReIds, mainReEntryIds, mainBillType);
                mainFarmVos = this.getFarmCostVo(mainIds, mainEntryIds, mainBillType, mainVerifyRecord);
            }
            if ("im_purinbill".equals(asstBillType) || "ap_finapbill".equals(asstBillType)) {
                Map<Long, Tuple<BigDecimal, BigDecimal>> asstVerifyRecord = VerifyRecordBaseSaveOp.getBillVerifyRecord(asstReIds, asstReEntryIds, asstBillType);
                asstFarmVos = this.getFarmCostVo(asstIds, asstEntryIds, asstBillType, asstVerifyRecord);
            }
            for (DynamicObject data : datas) {
                if ("im_purinbill".equals(mainBillType) || "ap_finapbill".equals(mainBillType)) {
                    int basePrecision = 2;
                    long currencyId = data.getLong("basecurrency.id");
                    DynamicObject baseCurrency = this.queryUtil.getBaseDataByPk(currencyId, "bd_currency");
                    if (baseCurrency != null) {
                        basePrecision = baseCurrency.getInt("amtprecision");
                    }
                    Long mainEntryId = data.getLong("billentryid");
                    BigDecimal verifybaseqty = data.getBigDecimal("verifybaseqty");
                    FarmCostVo mainVo = (FarmCostVo)mainFarmVos.get(mainEntryId);
                    if (mainVo != null) {
                        BigDecimal currInterCostAmt;
                        BigDecimal interCostAmt = mainVo.getIntercostamt();
                        BigDecimal sumBaseQty = mainVo.getSumBaseQty();
                        BigDecimal sumInterCostAmt = mainVo.getSumIntercostamt();
                        BigDecimal baseQty = mainVo.getBaseQty();
                        if (baseQty.compareTo(verifybaseqty) == 0) {
                            data.set("verifyintercostamt", (Object)interCostAmt);
                        } else if (verifybaseqty.add(sumBaseQty).compareTo(baseQty) == 0) {
                            currInterCostAmt = interCostAmt.subtract(sumInterCostAmt);
                            data.set("verifyintercostamt", (Object)currInterCostAmt);
                        } else {
                            currInterCostAmt = verifybaseqty.divide(baseQty, 10, RoundingMode.HALF_UP).multiply(interCostAmt).setScale(basePrecision, RoundingMode.HALF_UP);
                            data.set("verifyintercostamt", (Object)currInterCostAmt);
                            mainVo.setSumBaseQty(sumBaseQty.add(verifybaseqty));
                            mainVo.setSumIntercostamt(sumInterCostAmt.add(currInterCostAmt));
                        }
                    }
                }
                if (!"im_purinbill".equals(asstBillType) && !"ap_finapbill".equals(asstBillType)) continue;
                DynamicObjectCollection entry = data.getDynamicObjectCollection("entry");
                for (DynamicObject asst : entry) {
                    BigDecimal currInterCostAmt;
                    long currencyId = asst.getLong("e_basecurrency.id");
                    int basePrecision = 2;
                    DynamicObject baseCurrency = this.queryUtil.getBaseDataByPk(currencyId, "bd_currency");
                    if (baseCurrency != null) {
                        basePrecision = baseCurrency.getInt("amtprecision");
                    }
                    Long asstEntryId = asst.getLong("e_billentryid");
                    BigDecimal verifybaseqty = asst.getBigDecimal("e_verifybaseqty");
                    FarmCostVo asstVo = (FarmCostVo)asstFarmVos.get(asstEntryId);
                    if (asstVo == null) continue;
                    BigDecimal interCostAmt = asstVo.getIntercostamt();
                    BigDecimal sumBaseQty = asstVo.getSumBaseQty();
                    BigDecimal sumInterCostAmt = asstVo.getSumIntercostamt();
                    BigDecimal baseQty = asstVo.getBaseQty();
                    if (baseQty.compareTo(verifybaseqty) == 0) {
                        asst.set("e_verifyintercostamt", (Object)interCostAmt);
                        continue;
                    }
                    if (verifybaseqty.add(sumBaseQty).compareTo(baseQty) == 0) {
                        currInterCostAmt = interCostAmt.subtract(sumInterCostAmt);
                        asst.set("e_verifyintercostamt", (Object)currInterCostAmt);
                        continue;
                    }
                    currInterCostAmt = verifybaseqty.divide(baseQty, 10, RoundingMode.HALF_UP).multiply(interCostAmt).setScale(basePrecision, RoundingMode.HALF_UP);
                    asst.set("e_verifyintercostamt", (Object)currInterCostAmt);
                    asstVo.setSumBaseQty(sumBaseQty.add(verifybaseqty));
                    asstVo.setSumIntercostamt(sumInterCostAmt.add(currInterCostAmt));
                }
            }
        }
    }

    private Map<Long, FarmCostVo> getFarmCostVo(Set<Long> ids, Set<Long> entryIds, String billType, Map<Long, Tuple<BigDecimal, BigDecimal>> billVerifyRecord) {
        HashMap<Long, FarmCostVo> farmCostVos = new HashMap<Long, FarmCostVo>(ids.size());
        if (ids.size() == 0 || entryIds.size() == 0) {
            return farmCostVos;
        }
        String entryType = "ap_finapbill".equals(billType) ? "detailentry" : "billentry";
        String selector = "ap_finapbill".equals(billType) ? "id,detailentry.id,detailentry.e_baseunitqty,detailentry.intercostamt" : "id,billentry.id,billentry.baseqty,billentry.intercostamt";
        QFilter entryIdFilter = "ap_finapbill".equals(billType) ? new QFilter("detailentry.id", "in", entryIds) : new QFilter("billentry.id", "in", entryIds);
        DynamicObjectCollection billInfos = QueryServiceHelper.query((String)billType, (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", ids), entryIdFilter});
        for (DynamicObject bill : billInfos) {
            Long entryId;
            FarmCostVo farmCostVo = new FarmCostVo();
            if ("ap_finapbill".equals(billType)) {
                entryId = bill.getLong("detailentry.id");
                farmCostVo.setEntryId(entryId);
                farmCostVo.setBaseQty(bill.getBigDecimal("detailentry.e_baseunitqty"));
                farmCostVo.setIntercostamt(bill.getBigDecimal("detailentry.intercostamt"));
            } else {
                entryId = bill.getLong("billentry.id");
                farmCostVo.setEntryId(entryId);
                farmCostVo.setBaseQty(bill.getBigDecimal("billentry.baseqty"));
                farmCostVo.setIntercostamt(bill.getBigDecimal("billentry.intercostamt"));
            }
            Tuple<BigDecimal, BigDecimal> tuple = billVerifyRecord.get(entryId);
            if (tuple != null) {
                farmCostVo.setSumBaseQty((BigDecimal)tuple.item1);
                farmCostVo.setSumIntercostamt((BigDecimal)tuple.item2);
            }
            farmCostVos.put(entryId, farmCostVo);
        }
        return farmCostVos;
    }

    public static Map<Long, Tuple<BigDecimal, BigDecimal>> getBillVerifyRecord(Set<Long> billIds, Set<Long> billEntryIds, String entityName) {
        HashMap<Long, Tuple<BigDecimal, BigDecimal>> farmCost = new HashMap<Long, Tuple<BigDecimal, BigDecimal>>(billIds.size());
        if (billIds.size() == 0 || billEntryIds.size() == 0) {
            return farmCost;
        }
        ArrayList<VerifyRecordVO> records = new ArrayList<VerifyRecordVO>(2);
        QFilter mainFilter = new QFilter("billid", "in", billIds).and(new QFilter("billentryid", "in", billEntryIds));
        QFilter asstFilter = new QFilter("entry.e_billid", "in", billIds).and(new QFilter("entry.e_billentryid", "in", billEntryIds));
        QFilter commonFilter = ArApXDBHelper.getVerifyRecordXDBFilter(entityName, billIds.toArray(), false);
        asstFilter.and(commonFilter);
        DataSet vr4Mains = QueryServiceHelper.queryDataSet((String)"queryVR4Main", (String)"ap_verifyrecord", (String)"billentryid,verifyqty,verifyintercostamt", (QFilter[])new QFilter[]{mainFilter}, null);
        for (Object vr4Main : vr4Mains) {
            VerifyRecordVO vo = new VerifyRecordVO();
            vo.setMainBillEntryId(vr4Main.getLong("billentryid"));
            vo.setVerifyQty(vr4Main.getBigDecimal("verifyqty"));
            vo.setMainIntercostAmt(vr4Main.getBigDecimal("verifyintercostamt"));
            records.add(vo);
        }
        DataSet vr4Assts = QueryServiceHelper.queryDataSet((String)"queryVR4Asst", (String)"ap_verifyrecord", (String)"entry.e_billentryid,entry.e_verifyqty,entry.e_verifyintercostamt", (QFilter[])new QFilter[]{asstFilter}, null);
        for (Row vr4Asst : vr4Assts) {
            VerifyRecordVO vo = new VerifyRecordVO();
            vo.setMainBillEntryId(vr4Asst.getLong("entry.e_billentryid"));
            vo.setVerifyQty(vr4Asst.getBigDecimal("entry.e_verifyqty"));
            vo.setMainIntercostAmt(vr4Asst.getBigDecimal("entry.e_verifyintercostamt"));
            records.add(vo);
        }
        if (records.size() > 0) {
            Map<Long, List<VerifyRecordVO>> collect = records.stream().collect(Collectors.groupingBy(SettleRecordVO::getMainBillEntryId));
            for (Map.Entry<Long, List<VerifyRecordVO>> entrySet : collect.entrySet()) {
                List<VerifyRecordVO> recordVOs = entrySet.getValue();
                Long entryId = entrySet.getKey();
                BigDecimal sumVerifyQty = BigDecimal.ZERO;
                BigDecimal sumIntercostAmt = BigDecimal.ZERO;
                for (VerifyRecordVO record : recordVOs) {
                    sumVerifyQty = sumVerifyQty.add(record.getVerifyQty());
                    sumIntercostAmt = sumIntercostAmt.add(record.getMainIntercostAmt());
                }
                Tuple tuple = Tuple.create((Object)sumVerifyQty, (Object)sumIntercostAmt);
                farmCost.put(entryId, (Tuple<BigDecimal, BigDecimal>)tuple);
            }
        }
        return farmCost;
    }

    private List<String> getFarmRelationList() {
        ArrayList<String> farmRelation = new ArrayList<String>(8);
        farmRelation.add("appurin");
        farmRelation.add("appurreturn");
        farmRelation.add("purself");
        farmRelation.add("apfinself");
        farmRelation.add("appurreced");
        farmRelation.add("apomin");
        farmRelation.add("apominreturn");
        farmRelation.add("finapwrittenoff");
        farmRelation.add("purwrittenoff");
        farmRelation.add("purreturnwrittenoff");
        return farmRelation;
    }

    protected void processMainExtProp(List<Object> mainBillIds, DynamicObject[] datas) {
        DynamicObject[] mainBills;
        String mainBillEntity = datas[0].getString("billtype");
        for (DynamicObject mainBill : mainBills = BusinessDataServiceHelper.load((String)mainBillEntity, (String)String.join((CharSequence)",", this.extPropertyList), (QFilter[])new QFilter[]{new QFilter("id", "in", mainBillIds)})) {
            long mainPk = mainBill.getLong("id");
            DataEntityPropertyCollection properties = mainBill.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                if (property instanceof EntryProp) {
                    this.processEntryExtProp(mainBill, property.getName(), datas);
                    continue;
                }
                if (!this.extPropertyList.contains(property.getName())) continue;
                Object propValue = mainBill.get(property.getName());
                for (DynamicObject data : datas) {
                    long mainBillId = data.getLong("billid");
                    if (mainPk != mainBillId || !EntityMetadataUtils.isExistProperty(data, property.getName())) continue;
                    data.set(property.getName(), propValue);
                }
            }
        }
    }

    protected void processAsstExtProp(List<Object> mainBillIds, DynamicObject[] srDatas) {
        DynamicObject[] asstBills;
        DynamicObjectCollection entrys = srDatas[0].getDynamicObjectCollection("entry");
        String asstBillEntity = ((DynamicObject)entrys.get(0)).getString("e_billtype");
        for (DynamicObject asstBill : asstBills = BusinessDataServiceHelper.load((String)asstBillEntity, (String)String.join((CharSequence)",", this.extPropertyList), (QFilter[])new QFilter[]{new QFilter("id", "in", mainBillIds)})) {
            long asstPk = asstBill.getLong("id");
            DataEntityPropertyCollection properties = asstBill.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                if (property instanceof EntryProp) {
                    this.processEntryExtProp(asstBill, property.getName(), srDatas);
                    continue;
                }
                if (!this.extPropertyList.contains(property.getName())) continue;
                Object propValue = asstBill.get(property.getName());
                for (DynamicObject srData : srDatas) {
                    DynamicObjectCollection srEntrys = srData.getDynamicObjectCollection("entry");
                    for (DynamicObject srEntry : srEntrys) {
                        long asstBillId = srEntry.getLong("e_billid");
                        if (asstPk != asstBillId || !EntityMetadataUtils.isExistProperty(srEntry, "e_" + property.getName())) continue;
                        srEntry.set("e_" + property.getName(), propValue);
                    }
                }
            }
        }
    }

    protected void processEntryExtProp(DynamicObject bill, String billEntryKey, DynamicObject[] datas) {
        long billPk = bill.getLong("id");
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(billEntryKey);
        for (DynamicObject entry : entrys) {
            long billEntryPk = entry.getLong("id");
            DataEntityPropertyCollection entryProperties = entry.getDataEntityType().getProperties();
            for (IDataEntityProperty entryProperty : entryProperties) {
                if (!this.extPropertyList.contains(entryProperty.getName())) continue;
                Object entryPropValue = entry.get(entryProperty.getName());
                for (DynamicObject data : datas) {
                    long mainBillId = data.getLong("billid");
                    long mainBillEntryId = data.getLong("billentryid");
                    if (billPk == mainBillId && billEntryPk == mainBillEntryId && EntityMetadataUtils.isExistProperty(data, entryProperty.getName())) {
                        data.set(entryProperty.getName(), entryPropValue);
                    }
                    DynamicObjectCollection srEntrys = data.getDynamicObjectCollection("entry");
                    for (DynamicObject srEntry : srEntrys) {
                        long asstBillId = srEntry.getLong("e_billid");
                        long asstEntryId = srEntry.getLong("e_billentryid");
                        if (billPk != asstBillId || billEntryPk != asstEntryId || !EntityMetadataUtils.isExistProperty(srEntry, "e_" + entryProperty.getName())) continue;
                        srEntry.set("e_" + entryProperty.getName(), entryPropValue);
                    }
                }
            }
        }
    }
}

