/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;

public class WoffBillWriteBackOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(WoffBillWriteBackOp.class);
    private String upgradeDateStr;
    private boolean isAr = false;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        String name = this.billEntityType.getName();
        this.isAr = "ar_busbill".equals(name);
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("e_srcentryid");
        fieldKeys.add("payproperty.isbasedonamt");
        fieldKeys.add("createtime");
        fieldKeys.add("billno");
        fieldKeys.add("isadjust");
        fieldKeys.add("unwoffamt");
        fieldKeys.add("unwofflocamt");
        fieldKeys.add("e_unwoffamt");
        fieldKeys.add("e_unwofflocamt");
        fieldKeys.add("e_unwoffqty");
        fieldKeys.add("e_quantity");
        if (this.isAr) {
            fieldKeys.add("e_recamount");
            fieldKeys.add("e_reclocalamt");
        } else {
            fieldKeys.add("e_pricetaxtotal");
            fieldKeys.add("e_pricetaxtotalbase");
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> srcbillList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            String busEntityKey = dataEntity.getString("sourcebilltype");
            boolean isadjust = dataEntity.getBoolean("isadjust");
            if (!busEntityKey.contains("busbill") || !isadjust || !this.judge(dataEntity)) continue;
            boolean isbasedonamt = dataEntity.getBoolean("payproperty.isbasedonamt");
            DynamicObjectCollection woffEntries = dataEntity.getDynamicObjectCollection("entry");
            Long srcPk = dataEntity.getLong("sourcebillid");
            DynamicObject srcBusBill = BusinessDataServiceHelper.loadSingle((String)busEntityKey, (String)"unwoffamt,unwofflocamt,e_unwoffqty,e_unwoffamt,e_unwofflocamt", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)srcPk)});
            DynamicObjectCollection entries = srcBusBill.getDynamicObjectCollection("entry");
            BigDecimal unwoffamt = BigDecimal.ZERO;
            BigDecimal unwofflocamt = BigDecimal.ZERO;
            for (DynamicObject woffEntry : woffEntries) {
                for (DynamicObject entry : entries) {
                    if (woffEntry.getLong("e_srcentryid") != entry.getLong("id")) continue;
                    if (isbasedonamt) {
                        entry.set("e_unwoffqty", (Object)BigDecimal.ONE);
                    } else {
                        entry.set("e_unwoffqty", (Object)entry.getBigDecimal("e_unwoffqty").subtract(woffEntry.getBigDecimal("e_quantity")));
                    }
                    entry.set("e_unwoffamt", (Object)entry.getBigDecimal("e_unwoffamt").subtract(woffEntry.getBigDecimal(this.isAr ? "e_recamount" : "e_pricetaxtotal")));
                    entry.set("e_unwofflocamt", (Object)entry.getBigDecimal("e_unwofflocamt").subtract(woffEntry.getBigDecimal(this.isAr ? "e_reclocalamt" : "e_pricetaxtotalbase")));
                    unwoffamt = unwoffamt.add(entry.getBigDecimal("e_unwoffamt"));
                    unwofflocamt = unwofflocamt.add(entry.getBigDecimal("e_unwofflocamt"));
                }
            }
            srcBusBill.set("unwoffamt", (Object)unwoffamt);
            srcBusBill.set("unwofflocamt", (Object)unwofflocamt);
            srcbillList.add(srcBusBill);
        }
        if (!srcbillList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])srcbillList.toArray(new DynamicObject[0]));
            logger.info("----WoffBillWriteBackOp-----success:srcbillList.size:" + srcbillList.size());
        }
    }

    private boolean judge(DynamicObject dataEntity) {
        boolean flag = false;
        Date createtime = dataEntity.getDate("createtime");
        if (this.upgradeDateStr == null) {
            this.upgradeDateStr = StdConfig.get("upgradeDate");
            logger.info("WoffBillWriteBackOp.judge.upgradeDateStr:" + this.upgradeDateStr);
        }
        if (EmptyUtils.isEmpty(this.upgradeDateStr)) {
            this.upgradeDateStr = "";
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date upgradeDate = null;
        try {
            upgradeDate = sdf.parse(this.upgradeDateStr);
        }
        catch (ParseException parseException) {
            logger.error("context", (Object)parseException.getMessage());
        }
        if (createtime != null && upgradeDate != null && createtime.before(upgradeDate)) {
            flag = true;
        }
        return flag;
    }
}

