/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.report.BcmFormula;
import kd.fi.arapcommon.report.BcmFormulaExecutor;
import kd.fi.arapcommon.util.StringUtils;
import org.apache.commons.io.IOUtils;

public abstract class BcmRptFormulaMServiceTemplate {
    private Log logger = LogFactory.getLog(BcmRptFormulaMServiceTemplate.class);

    public String executeFormula(String formulaName, String paramJson) {
        this.logger.info("formulaName" + formulaName + ",paramJson=" + paramJson);
        try {
            BcmFormula bcmFormula = new BcmFormula(formulaName, paramJson, this.getFormulaJsonFileName());
            BcmFormulaExecutor formulaExecutor = this.getFormulaExecutor(formulaName);
            formulaExecutor.execute(bcmFormula);
            String result = SerializationUtils.toJsonString(bcmFormula.getResults());
            this.logger.info(result);
            return result;
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            throw e;
        }
    }

    protected abstract BcmFormulaExecutor getFormulaExecutor(String var1);

    protected abstract String getFormulaJsonFileName();

    protected abstract String getFormulaCatalogJsonFileName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormulaDef() throws IOException {
        try {
            String formula_catalog;
            String formula_def;
            InputStream formula_def_list = null;
            InputStream formula_catalog_list = null;
            String formulaJsonFileName = this.getFormulaJsonFileName();
            String formulaCatalogJsonFileName = this.getFormulaCatalogJsonFileName();
            Class<?> clazz = this.getClass();
            try {
                Charset charset = Charset.defaultCharset();
                String prefixPath = "apreportformula/";
                if (formulaJsonFileName.startsWith("ar_")) {
                    prefixPath = "arreportformula/";
                }
                formula_def_list = clazz.getResourceAsStream("/resources/" + prefixPath + formulaJsonFileName);
                formula_def = IOUtils.toString((InputStream)formula_def_list, (Charset)charset);
                formula_catalog_list = clazz.getResourceAsStream("/resources/" + prefixPath + formulaCatalogJsonFileName);
                formula_catalog = IOUtils.toString((InputStream)formula_catalog_list, (Charset)charset);
            }
            finally {
                if (formula_def_list != null) {
                    try {
                        formula_def_list.close();
                    }
                    catch (Exception charset) {}
                }
                if (formula_catalog_list != null) {
                    try {
                        formula_catalog_list.close();
                    }
                    catch (Exception charset) {}
                }
            }
            HashMap<String, String> configMap = new HashMap<String, String>();
            if (!StringUtils.isNotEmpty(formula_def) || !StringUtils.isNotEmpty(formula_catalog)) {
                throw new RuntimeException("formula config is empty");
            }
            configMap.put("formula_catalog_list", formula_catalog);
            configMap.put("formula_def_list", formula_def);
            return SerializationUtils.toJsonString(configMap);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            throw e;
        }
    }
}

