/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.fi.arapcommon.helper.BaseDataHelper;

public class RptFilterMultiBaseFormPlugin
extends AbstractReportFormPlugin {
    public void registerListener(EventObject e) {
        String[] basedataTypes;
        super.registerListener(e);
        for (String basedataType : basedataTypes = this.getMultiBaseStr()) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(basedataType);
            if (basedataEdit == null) continue;
            basedataEdit.addBeforeF7SelectListener(event -> {
                ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
                DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
                if (orgs.isEmpty()) {
                    return;
                }
                ArrayList<Long> orgIds = new ArrayList<Long>();
                for (DynamicObject org : orgs) {
                    orgIds.add(org.getDynamicObject("fbasedataid").getLong("id"));
                }
                QFilter basedataFilter = BaseDataHelper.getBasedataFilter(basedataType, orgIds);
                List qFilters = listShowParameter.getListFilterParameter().getQFilters();
                qFilters.add(basedataFilter);
            });
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setMultiBaseStatus();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("reset".equals(e.getOperateKey())) {
            this.setMultiBaseStatus();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (this.getAsstactTypeKey().equals(key) || "orgs".equals(key)) {
            this.setMultiBaseStatus();
        }
    }

    protected void setMultiBaseStatus() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if (!"arap_asstact_summarize".equals(formId)) {
            this.getView().setVisible(Boolean.FALSE, this.getMultiBaseStr());
            String asstactType = (String)this.getModel().getValue(this.getAsstactTypeKey());
            if (asstactType != null && !"".equals(asstactType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{asstactType});
            }
        }
    }

    protected String[] getMultiBaseStr() {
        return new String[]{"bd_supplier", "bd_customer", "bos_user"};
    }

    private String getAsstactTypeKey() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("ar_acctagerpt".equals(formId) || "ap_acctagerpt".equals(formId) || "ar_acctagerpt_n".equals(formId) || "ap_acctagerpt_n".equals(formId) || "ap_sumrpt_new".equals(formId) || "ap_detailrpt_new".equals(formId) || "ap_sumrpt_n".equals(formId) || "ap_detailrpt_n".equals(formId) || "ar_sumrpt_new".equals(formId) || "ar_detailrpt_new".equals(formId) || "ar_sumrpt_n".equals(formId) || "ar_detailrpt_n".equals(formId) || "ap_accountcheck".equals(formId) || "ar_accountcheck".equals(formId) || "ap_invoicerpt".equals(formId) || "ar_baddebtpreparerpt".equals(formId) || "ap_mlreport_n".equals(formId) || "ap_invoicerpt_n".equals(formId)) {
            return "q_asstacttype";
        }
        return "asstacttype";
    }
}

