/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.account;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.report.SingleValAggFunction;
import kd.fi.arapcommon.report.SumParam;
import kd.fi.arapcommon.report.account.AccountRptParam;
import kd.fi.arapcommon.util.DataSetUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public abstract class AbstractAccountQuery {
    protected AccountRptParam param;

    protected AbstractAccountQuery(AccountRptParam param) {
        this.param = param;
    }

    public DataSet queryData() {
        DataSet billData = this.getBillDataSet();
        DataSet billAndDapTrackData = this.unionDapTrack(billData);
        DataSet voucherDataSet = this.getVoucherData();
        DataSet mergeData = billAndDapTrackData.leftJoin(voucherDataSet).on("trackVoucherId", "voucherid").select(billAndDapTrackData.getRowMeta().getFieldNames(), voucherDataSet.getRowMeta().getFieldNames()).finish();
        return this.sum(mergeData);
    }

    protected DataSet unionDapTrack(DataSet dataSet) {
        DataSet dapTrackers = QueryServiceHelper.queryDataSet((String)"AbstractAccountQuery_getBillDataSet", (String)"ai_daptracker", (String)"sourcebillid,voucherid trackVoucherId", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", this.param.getBillIds())}, (String)"sourcebillid");
        DataSet copyDapTrackers = dapTrackers.copy();
        HashSet<Long> allVoucherId = new HashSet<Long>(64);
        for (Row row : copyDapTrackers) {
            allVoucherId.add(row.getLong("trackVoucherId"));
        }
        copyDapTrackers.close();
        this.param.setVoucherIds(allVoucherId);
        return dataSet.leftJoin(dapTrackers).on("billid", "sourcebillid").select(dataSet.getRowMeta().getFieldNames(), new String[]{"trackVoucherId"}).finish();
    }

    protected DataSet sum(DataSet dataSet) {
        SumParam sumParam = new SumParam(SumParam.SumType.TOTAL);
        ArrayList<String> sumArgs = new ArrayList<String>(8);
        if (Boolean.TRUE.equals(this.param.getLocalAmt())) {
            sumArgs.add("localamt");
            sumArgs.add("localtax");
            sumArgs.add("pricetaxtotalbase");
            sumArgs.add("debitlocamount");
            sumArgs.add("creditlocamount");
        }
        sumArgs.add("amount");
        sumArgs.add("tax");
        sumArgs.add("pricetaxtotal");
        sumArgs.add("debitori");
        sumArgs.add("creditori");
        sumParam.setSummaryFields(sumArgs);
        DataSet groupByUnionData = DataSetUtils.sum(dataSet, sumParam);
        return dataSet.addNullField("sumlevel").union(groupByUnionData);
    }

    protected DataSet getBillDataSet() {
        DataSet billData = QueryServiceHelper.queryDataSet((String)"AbstractAccountQuery_getBillDataSet", (String)this.getBillEntity(), (String)String.join((CharSequence)",", this.getFinSelector()), (QFilter[])this.getBillQFilter().toArray(new QFilter[0]), (String)"id");
        HashSet<Long> billIds = new HashSet<Long>(32);
        DataSet copyDataSet = billData.copy();
        Iterator iterator = billData.copy().iterator();
        while (iterator.hasNext()) {
            billIds.add(((Row)iterator.next()).getLong("billid"));
        }
        copyDataSet.close();
        this.param.setBillIds(billIds);
        return billData;
    }

    public DataSet getVoucherData() {
        List<QFilter> qFilter = this.getVoucherQFilter();
        DataSet voucherData = null;
        voucherData = this.param.getEntryShow() != false ? QueryServiceHelper.queryDataSet((String)"AbstractAccountQuery", (String)"gl_voucher", (String)String.join((CharSequence)",", this.getVoucherSelector()), (QFilter[])qFilter.toArray(new QFilter[0]), (String)"billno") : this.processVoucherData();
        return voucherData;
    }

    private DataSet processVoucherData() {
        DataSet voucherData = QueryServiceHelper.queryDataSet((String)"AbstractAccountQuery", (String)"gl_voucher", (String)String.join((CharSequence)",", this.getVoucherSelector()), (QFilter[])this.getVoucherQFilter().toArray(new QFilter[0]), (String)"billno");
        HashMap<Long, StringBuilder> accountMap = new HashMap<Long, StringBuilder>(32);
        HashMap<Long, StringBuilder> descriptionMap = new HashMap<Long, StringBuilder>(32);
        this.startSplicing(voucherData.copy(), accountMap, descriptionMap);
        DataSet tempData = this.buildTempDataSet(accountMap, descriptionMap);
        String[] fieldNames = voucherData.getRowMeta().getFieldNames();
        GroupbyDataSet sumDataSet = voucherData.groupBy(new String[]{"voucherid"}).sum("debitori").sum("creditori");
        List<String> filterList = Arrays.asList("voucherid", "debitori", "creditori");
        if (Boolean.TRUE.equals(this.param.getLocalAmt())) {
            sumDataSet.sum("debitlocamount").sum("creditlocamount");
            filterList = Arrays.asList("voucherid", "debitori", "creditori", "creditlocamount", "debitlocamount");
        }
        for (String field2 : fieldNames) {
            if (filterList.contains(field2)) continue;
            sumDataSet.agg(new SingleValAggFunction((DataType)DataType.AnyType), field2, field2);
        }
        voucherData = sumDataSet.finish();
        List<String> tempField = Arrays.asList("tempedesc", "tempaccountname", "tempaccountnumber");
        List<String> neededField = Arrays.stream(fieldNames).filter(field -> !tempField.contains(field)).collect(Collectors.toList());
        return voucherData.leftJoin(tempData).on("voucherid", "tempvoucherid").select(neededField.toArray(new String[0]), new String[]{"edescription", "splitaccount"}).finish();
    }

    private void startSplicing(DataSet voucherData, Map<Long, StringBuilder> accountMap, Map<Long, StringBuilder> descriptionMap) {
        for (Row row : voucherData) {
            String description;
            Long voucherId = row.getLong("voucherid");
            StringBuilder accountBuilder = accountMap.get(voucherId);
            StringBuilder descriptionBuilder = descriptionMap.get(voucherId);
            if (accountBuilder == null || accountBuilder.length() == 0) {
                accountBuilder = new StringBuilder(row.getString("tempaccountnumber"));
                accountBuilder.append(':');
                accountBuilder.append(row.getString("tempaccountname"));
                accountMap.put(voucherId, accountBuilder);
            } else {
                accountBuilder.append('/');
                accountBuilder.append(row.getString("tempaccountnumber"));
                accountBuilder.append(':');
                accountBuilder.append(row.getString("tempaccountname"));
            }
            if (!EmptyUtils.isNotEmpty(description = row.getString("tempedesc")) || descriptionBuilder != null && description.equals(descriptionBuilder.toString())) continue;
            if (descriptionBuilder == null || descriptionBuilder.length() == 0) {
                descriptionBuilder = new StringBuilder();
                descriptionBuilder.append(description);
                descriptionMap.put(voucherId, descriptionBuilder);
                continue;
            }
            descriptionBuilder.append('/');
            descriptionBuilder.append(description);
        }
        voucherData.close();
    }

    private DataSet buildTempDataSet(Map<Long, StringBuilder> accountMap, Map<Long, StringBuilder> descriptionMap) {
        Field[] fields = new Field[]{new Field("tempvoucherid", (DataType)DataType.LongType, true), new Field("splitaccount", (DataType)DataType.StringType, true), new Field("edescription", (DataType)DataType.StringType, true)};
        DataSetBuilder builder = Algo.create((String)"kd.fi.arapcommon.report.account.AbstractAccountQuery").createDataSetBuilder(new RowMeta(fields));
        for (Long voucherId : this.param.getVoucherIds()) {
            StringBuilder edescription;
            Object[] rowData = new Object[3];
            rowData[0] = voucherId;
            StringBuilder splitAccount = accountMap.get(voucherId);
            if (splitAccount != null) {
                rowData[1] = splitAccount.toString();
            }
            if ((edescription = descriptionMap.get(voucherId)) != null) {
                rowData[2] = edescription.toString();
            }
            builder.append(rowData);
        }
        return builder.build();
    }

    protected List<String> getVoucherSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        if (Boolean.TRUE.equals(this.param.getEntryShow())) {
            selector.add("entries.edescription edescription");
            selector.add("entries.currency vouchercurrency");
        } else {
            selector.add("entries.edescription tempedesc");
            selector.add("entries.account.name tempaccountname");
            selector.add("entries.account.number tempaccountnumber");
        }
        if (Boolean.TRUE.equals(this.param.getLocalAmt())) {
            selector.add("localcur");
            selector.add("entries.debitlocal debitlocamount");
            selector.add("entries.creditlocal creditlocamount");
        }
        selector.add("billno voucherbillno");
        selector.add("entries.account account");
        selector.add("entries.creditori creditori");
        selector.add("entries.debitori debitori");
        selector.add("creator createvoucher");
        selector.add("id voucherid");
        Map<String, List<String>> extendField = this.param.getExtendField();
        if (EmptyUtils.isNotEmpty(extendField) && EmptyUtils.isNotEmpty(extendField.get("gl_voucher"))) {
            selector.addAll((Collection<String>)extendField.get("gl_voucher"));
        }
        return selector;
    }

    private List<QFilter> getVoucherQFilter() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("id", "in", this.param.getVoucherIds()));
        String accrualDirection = this.param.getAccrualDirection();
        if (!"all".equalsIgnoreCase(accrualDirection)) {
            qFilters.add(new QFilter("entries.entrydc", "=", (Object)accrualDirection));
        }
        return qFilters;
    }

    protected List<QFilter> getBillQFilter() {
        Date beginBizDate;
        List<Object> currencyIds;
        List<Object> asstactIds;
        String asstactType;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        Map<String, String> searchDataField = this.getSearchDataField();
        List<Object> orgIds = this.param.getOrgIds();
        if (EmptyUtils.isNotEmpty(orgIds)) {
            qFilters.add(new QFilter("org", "in", orgIds));
        }
        if (EmptyUtils.isNotEmpty(asstactType = this.param.getAsstactType())) {
            qFilters.add(new QFilter(searchDataField.get("asstacttype"), "=", (Object)asstactType));
        }
        if (EmptyUtils.isNotEmpty(asstactIds = this.param.getAsstactIds())) {
            qFilters.add(new QFilter(searchDataField.get("asstact"), "in", this.param.getAsstactIds()));
        }
        if (EmptyUtils.isNotEmpty(currencyIds = this.param.getCurrencyIds())) {
            qFilters.add(new QFilter(searchDataField.get("currency"), "in", this.param.getCurrencyIds()));
        }
        if (EmptyUtils.isNotEmpty(beginBizDate = this.param.getBeginBizDate())) {
            qFilters.add(new QFilter(searchDataField.get("bizdate"), ">=", (Object)beginBizDate));
            qFilters.add(new QFilter(searchDataField.get("bizdate"), "<=", (Object)this.param.getEndBizDate()));
        }
        Date beginBookDate = this.param.getBeginBookDate();
        String bookDate = searchDataField.get("bookdate");
        if (EmptyUtils.isNotEmpty(beginBookDate) && EmptyUtils.isNotEmpty(bookDate)) {
            qFilters.add(new QFilter(bookDate, ">=", (Object)beginBookDate));
            qFilters.add(new QFilter(bookDate, "<=", (Object)this.param.getEndBookDate()));
        }
        if (Boolean.TRUE.equals(this.param.getVoucher())) {
            qFilters.add(new QFilter("isvoucher", "=", (Object)Boolean.TRUE));
        }
        String billEntity = this.getBillEntity();
        ArrayList<String> settleRelations = new ArrayList<String>(16);
        if ("ar_settlerecord".equals(billEntity)) {
            settleRelations.add(SettleRelationEnum.ARSELF.getValue());
            settleRelations.add(SettleRelationEnum.RECSELF.getValue());
            settleRelations.add(SettleRelationEnum.ARTRANSFER.getValue());
            settleRelations.add(SettleRelationEnum.ARAPSETTLE.getValue());
            settleRelations.add(SettleRelationEnum.ARWRITEOFF.getValue());
            settleRelations.add(SettleRelationEnum.BADDEBTLOSS.getValue());
            settleRelations.add(SettleRelationEnum.BADDEBTRECOVERY.getValue());
            settleRelations.add(SettleRelationEnum.RECPAYSETTLE.getValue());
            settleRelations.add(SettleRelationEnum.ARLIQUIDATIONSETTLE.getValue());
            settleRelations.add(SettleRelationEnum.ARPAYSETTLE.getValue());
            qFilters.add(new QFilter("settlerelation", "in", settleRelations));
        }
        if ("ap_settlerecord".equals(billEntity)) {
            settleRelations.add(SettleRelationEnum.APPAYSETTLE.getValue());
            settleRelations.add(SettleRelationEnum.APSELF.getValue());
            settleRelations.add(SettleRelationEnum.PAYSELF.getValue());
            settleRelations.add(SettleRelationEnum.APLIQUIDATIONSETTLE.getValue());
            settleRelations.add(SettleRelationEnum.APARSETTLE.getValue());
            settleRelations.add(SettleRelationEnum.PAYTRANS.getValue());
            settleRelations.add(SettleRelationEnum.APWRITEOFF.getValue());
            settleRelations.add(SettleRelationEnum.PAYRECSETTLE.getValue());
            settleRelations.add(SettleRelationEnum.APRECSETTLE.getValue());
            settleRelations.add(SettleRelationEnum.PREMSETTLE.getValue());
            qFilters.add(new QFilter("settlerelation", "in", settleRelations));
        }
        qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        if (EmptyUtils.isNotEmpty(this.param.getBillIds())) {
            qFilters.add(new QFilter("id", "in", this.param.getBillIds()));
        }
        return qFilters;
    }

    private Map<String, String> getSearchDataField() {
        HashMap<String, String> result = new HashMap<String, String>(8);
        result.put("bizdate", "bizdate");
        result.put("asstacttype", "asstacttype");
        result.put("asstact", "asstact");
        result.put("currency", "currency");
        result.put("bookdate", "bookdate");
        String billEntity = this.getBillEntity();
        if ("ap_liquidation".equals(billEntity) || "ar_liquidation".equals(billEntity)) {
            result.put("bizdate", "liquidationdate");
            result.put("bookdate", null);
        }
        if ("ar_settlerecord".equals(billEntity) || "ap_settlerecord".equals(billEntity)) {
            result.put("bizdate", "settledate");
            result.put("asstacttype", "mainasstacttype");
            result.put("asstact", "mainasstactid");
            result.put("currency", "maincurrency");
            result.put("bookdate", null);
        }
        if ("ar_baddebtlossbill".equals(billEntity)) {
            result.put("bookdate", "bizdate");
        }
        if ("ar_baddebtreserve".equals(billEntity)) {
            result.put("bizdate", "accrualdate");
            result.put("bookdate", "accrualdate");
        }
        return result;
    }

    protected List<String> getFinSelector() {
        ArrayList<String> selector = new ArrayList<String>(32);
        Map<String, List<String>> extendField = this.param.getExtendField();
        String billEntity = this.getBillEntity();
        if (EmptyUtils.isNotEmpty(extendField) && EmptyUtils.isNotEmpty(extendField.get(billEntity))) {
            selector.addAll((Collection<String>)extendField.get(billEntity));
        }
        return selector;
    }

    protected abstract String getBillEntity();
}

