/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.account;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.util.DateUtils;

public class AccountFormRpt
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private Object billId = null;

    public void registerListener(EventObject e) {
        Toolbar toolBar = (Toolbar)this.getControl("toolbarap");
        toolBar.addItemClickListener((ItemClickListener)this);
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        Date newDate;
        if (OrgHelper.checkloginOrg(this.isAr())) {
            this.getModel().setValue("orgs", (Object)new Object[]{RequestContext.get().getOrgId()});
        } else {
            List<DynamicObject> authorizedInitializedOrgs = OrgHelper.getAuthorizedInitializedOrgs(this.getFormKey(), "47150e89000000ac", this.isAr());
            if (!authorizedInitializedOrgs.isEmpty()) {
                this.getModel().setValue("orgs", (Object)new Object[]{authorizedInitializedOrgs.get(0).getPkValue()});
            }
        }
        if (ObjectUtils.isEmpty((Object)this.getModel().getValue("beginbizdate"))) {
            newDate = new Date();
            this.getModel().setValue("beginbizdate", (Object)DateUtils.getMinMonthDate(newDate));
            this.getModel().setValue("endbizdate", (Object)newDate);
        }
        if (ObjectUtils.isEmpty((Object)this.getModel().getValue("beginbookdate"))) {
            newDate = new Date();
            this.getModel().setValue("beginbookdate", (Object)DateUtils.getMinMonthDate(newDate));
            this.getModel().setValue("endbookdate", (Object)newDate);
        }
        Long orgId = RequestContext.get().getOrgId();
        String entity = this.isAr() ? "ar_init" : "ap_init";
        DynamicObject initOrgData = QueryServiceHelper.queryOne((String)entity, (String)"id,standardcurrency", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        if (initOrgData != null) {
            this.getModel().setValue("q_currency", (Object)new Object[]{initOrgData.getLong("standardcurrency")});
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter == null) {
            return;
        }
        Map customParams = formShowParameter.getCustomParams();
        if (customParams == null) {
            return;
        }
        Boolean isOpenByHyperlink = (Boolean)customParams.get("isopenbyhyperlink");
        if (isOpenByHyperlink != null && isOpenByHyperlink.booleanValue()) {
            this.billId = customParams.get("billid");
            this.setQueryConditionDesign(customParams);
        } else {
            this.billId = null;
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if ("sourceentity".equals(key)) {
            if ("ap_settlerecord".equals(newValue) || "ap_liquidation".equals(newValue)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bookdaterange"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bookdaterange"});
            }
        }
    }

    private void setQueryConditionDesign(Map<String, Object> customParams) {
        IDataModel parentModel = this.getView().getParentView().getModel();
        List<Control> controlList = this.getFilterFieldKeys();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.getView().getEntityId());
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        Map rowData = (Map)customParams.get("rowData");
        for (Control control : controlList) {
            IDataEntityProperty prop;
            String originalFieldKey = control.getKey();
            if ("bizdaterange".equals(originalFieldKey)) {
                this.getModel().setValue("beginbizdate", rowData.get("billdate"));
                this.getModel().setValue("endbizdate", rowData.get("billdate"));
                continue;
            }
            if ("bookdaterange".equals(originalFieldKey)) {
                this.getModel().setValue("beginbookdate", rowData.get("bookdate"));
                this.getModel().setValue("endbookdate", rowData.get("bookdate"));
                continue;
            }
            Object value = null;
            if (rowData.get(originalFieldKey) != null) {
                value = rowData.get(originalFieldKey);
            }
            if (ObjectUtils.isEmpty(value)) {
                value = parentModel.getValue(originalFieldKey);
            }
            if ((prop = (IDataEntityProperty)properties.get((Object)originalFieldKey)) instanceof MulBasedataProp) {
                value = this.getMutlBasedataPks(value);
            }
            this.getModel().setValue(originalFieldKey, value);
        }
        ReportFilter control = (ReportFilter)this.getControl("reportfilterap");
        control.search();
    }

    private Object getMutlBasedataPks(Object value) {
        if (value instanceof DynamicObjectCollection) {
            DynamicObjectCollection temCollectionValue = (DynamicObjectCollection)value;
            ArrayList<Object> pks = new ArrayList<Object>(((DynamicObjectCollection)value).size());
            for (DynamicObject eachValue : temCollectionValue) {
                pks.add(eachValue.getDynamicObject("fbasedataid").getPkValue());
            }
            value = pks.toArray(new Object[0]);
        } else if (value instanceof DynamicObject) {
            value = new Object[]{((DynamicObject)value).getPkValue()};
        } else if (value instanceof Map) {
            Object id = ((Map)value).get("id");
            value = new Object[]{Long.valueOf(id.toString())};
        }
        return value;
    }

    private List<Control> getFilterFieldKeys() {
        Container commFilterContainer = (Container)this.getView().getControl("reportcommfilterpanelap");
        Container moreFilterContainer = (Container)this.getView().getControl("reportmorefilterpanelap");
        ArrayList<Control> filterItems = new ArrayList<Control>();
        filterItems.addAll(commFilterContainer.getItems());
        filterItems.addAll(moreFilterContainer.getItems());
        return filterItems;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        Map<String, IDataEntityProperty> propMap = this.getModel().getDataEntity().getDataEntityType().getProperties().stream().collect(Collectors.toMap(IMetadata::getName, p -> p));
        FilterInfo filter = queryParam.getFilter();
        List filterItems = filter.getFilterItems();
        for (FilterItemInfo filterItem : filterItems) {
            Object value;
            Boolean mustInput;
            String propName = filterItem.getPropName();
            IDataEntityProperty dataProp = propMap.get(propName);
            Method findMethod = ReflectionUtils.findMethod(dataProp.getClass(), (String)"isMustInput");
            if (!Objects.nonNull(findMethod) || !Boolean.TRUE.equals(mustInput = (Boolean)ReflectionUtils.invokeMethod((Method)findMethod, (Object)dataProp)) || !Objects.isNull(value = filter.getValue(propName))) continue;
            String propertyName = dataProp.getDisplayName().getLocaleValue();
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"AccountFormRpt_7", (String)"fi-arapcommon", (Object[])new Object[]{propertyName}), new Object[0]), Integer.valueOf(3000));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        DynamicObject rowData = packageDataEvent.getRowData();
        ReportColumn col = (ReportColumn)packageDataEvent.getSource();
        String fieldKey = col.getFieldKey();
        if (2 == rowData.getInt("sumlevel") && "asstacttype".equals(fieldKey)) {
            packageDataEvent.setFormatValue((Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AccountFormRpt_8", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if (("debitori".equals(fieldKey) || "creditori".equals(fieldKey) || "debitlocamount".equals(fieldKey) || "creditlocamount".equals(fieldKey)) && "0.000000".equals(rowData.get(fieldKey))) {
            packageDataEvent.setFormatValue(null);
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        this.extendedProcessing(queryParam);
        Map customParam = queryParam.getCustomParam();
        this.createColumns(queryParam);
        this.setColumnHide(queryParam);
        Object hyperLinkClickLineName = this.getView().getFormShowParameter().getCustomParams().get("hyperLinkClickLineName");
        if (hyperLinkClickLineName != null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"reportfilterap"});
            customParam.put("billid", this.billId);
        }
    }

    private void createColumns(ReportQueryParam queryParam) {
        Boolean isEntryShow = queryParam.getFilter().getBoolean("isentryshow");
        Boolean isLocalAmt = queryParam.getFilter().getBoolean("islocalamt");
        ReportList rptList = (ReportList)this.getControl("reportlistap");
        List columns = rptList.getColumns();
        if (isLocalAmt.booleanValue()) {
            columns.add(this.createReportColumn(ResManager.loadKDString((String)"\u51ed\u8bc1\u672c\u4f4d\u5e01", (String)"AccountFormRpt_0", (String)"fi-arapcommon", (Object[])new Object[0]), "localcur", "bd_currency", "number"));
        }
        String splitAccount = ResManager.loadKDString((String)"\u79d1\u76ee", (String)"AccountFormRpt_1", (String)"fi-arapcommon", (Object[])new Object[0]);
        String debitori = ResManager.loadKDString((String)"\u501f\u65b9\u91d1\u989d", (String)"AccountFormRpt_2", (String)"fi-arapcommon", (Object[])new Object[0]);
        String debitLocAmount = ResManager.loadKDString((String)"\u501f\u65b9\u91d1\u989d\u6298\u672c\u5e01", (String)"AccountFormRpt_3", (String)"fi-arapcommon", (Object[])new Object[0]);
        String creditori = ResManager.loadKDString((String)"\u8d37\u65b9\u91d1\u989d", (String)"AccountFormRpt_4", (String)"fi-arapcommon", (Object[])new Object[0]);
        String creditLocAmount = ResManager.loadKDString((String)"\u8d37\u65b9\u91d1\u989d\u6298\u672c\u5e01", (String)"AccountFormRpt_5", (String)"fi-arapcommon", (Object[])new Object[0]);
        if (!isEntryShow.booleanValue()) {
            columns.add(this.createReportColumn(splitAccount, "splitaccount", "text", null, Boolean.FALSE));
            columns.add(this.createReportColumn(debitori, "debitori", "text", null, Boolean.TRUE));
            if (isLocalAmt.booleanValue()) {
                columns.add(this.createReportColumn(debitLocAmount, "debitlocamount", "price", "localcur", Boolean.FALSE));
            }
            columns.add(this.createReportColumn(creditori, "creditori", "text", null, Boolean.TRUE));
            if (isLocalAmt.booleanValue()) {
                columns.add(this.createReportColumn(creditLocAmount, "creditlocamount", "price", "localcur", Boolean.FALSE));
            }
        } else {
            columns.add(this.createReportColumn(splitAccount, "account", "bd_accountview", "number,name"));
            columns.add(this.createReportColumn(ResManager.loadKDString((String)"\u51ed\u8bc1\u5e01\u79cd", (String)"AccountFormRpt_6", (String)"fi-arapcommon", (Object[])new Object[0]), "vouchercurrency", "bd_currency", "number"));
            columns.add(this.createReportColumn(debitori, "debitori", "price", "vouchercurrency", Boolean.FALSE));
            if (isLocalAmt.booleanValue()) {
                columns.add(this.createReportColumn(debitLocAmount, "debitlocamount", "price", "localcur", Boolean.FALSE));
            }
            columns.add(this.createReportColumn(creditori, "creditori", "price", "vouchercurrency", Boolean.FALSE));
            if (isLocalAmt.booleanValue()) {
                columns.add(this.createReportColumn(creditLocAmount, "creditlocamount", "price", "localcur", Boolean.FALSE));
            }
        }
    }

    private void setColumnHide(ReportQueryParam queryParam) {
        ReportList rptList = (ReportList)this.getControl("reportlistap");
        List columns = rptList.getColumns();
        String sourceEntity = queryParam.getFilter().getString("sourceentity");
        Boolean isLocalAmt = queryParam.getFilter().getBoolean("islocalamt");
        for (AbstractReportColumn reportColumn : columns) {
            boolean flag;
            ReportColumn column = (ReportColumn)reportColumn;
            String fieldKey = column.getFieldKey();
            if (Boolean.FALSE.equals(isLocalAmt) && ("pricetaxtotalbase".equals(fieldKey) || "localamt".equals(fieldKey) || "localtax".equals(fieldKey) || "localcur".equals(fieldKey) || "vouchercurrency".equals(fieldKey))) {
                column.setHide(true);
            }
            boolean bl = flag = "ap_settlerecord".equals(sourceEntity) || "ar_settlerecord".equals(sourceEntity);
            if (flag && "billtypeid".equals(fieldKey)) {
                column.setHide(true);
            }
            if (flag || !"settlerelation".equals(fieldKey)) continue;
            column.setHide(true);
        }
    }

    private ReportColumn createReportColumn(String caption, String key, String columnType, String currencyField, Boolean isHyper) {
        ReportColumn column = new ReportColumn();
        column.setCaption(new LocaleString(caption));
        column.setFieldKey(key);
        column.setFieldType(columnType);
        if ("price".equals(columnType)) {
            column.setCurrencyField(currencyField);
        }
        column.setHyperlink(isHyper.booleanValue());
        return column;
    }

    private ReportColumn createReportColumn(String caption, String key, String entityId, String displayProp) {
        ReportColumn column = new ReportColumn();
        column.setCaption(new LocaleString(caption));
        column.setFieldKey(key);
        column.setFieldType("basedata");
        column.setEntityId(entityId);
        column.setDisplayProp(displayProp);
        return column;
    }

    private void extendedProcessing(ReportQueryParam queryParam) {
        HashMap<String, List<String>> extendFieldMap = new HashMap<String, List<String>>(8);
        Map allFields = this.getModel().getDataEntityType().getAllFields();
        for (Map.Entry next : allFields.entrySet()) {
            String columnName = (String)next.getKey();
            String extendField = columnName.substring(0, columnName.length() - 2) + " " + columnName;
            if (columnName.endsWith("_a")) {
                this.setMapValue(extendFieldMap, "ar_finarbill", extendField);
            }
            if (columnName.endsWith("_t")) {
                this.setMapValue(extendFieldMap, "ap_finapbill", extendField);
            }
            if (!columnName.endsWith("_n")) continue;
            this.setMapValue(extendFieldMap, "gl_voucher", extendField);
        }
        queryParam.getCustomParam().put("extendField", extendFieldMap);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(evt.getRowIndex());
        Object sourceEntity = reportList.getModel().getValue("sourceentity");
        BillShowParameter parameter = new BillShowParameter();
        switch (fieldName) {
            case "creditori": 
            case "debitori": {
                ReportShowParameter reportShowParameter = new ReportShowParameter();
                reportShowParameter.setFormId(this.getView().getFormShowParameter().getFormId());
                reportShowParameter.getOpenStyle().setTargetKey(this.getView().getFormShowParameter().getOpenStyle().getTargetKey());
                reportShowParameter.getOpenStyle().setShowType(this.getView().getFormShowParameter().getFormConfig().getShowType());
                Map<String, Object> customParams = this.getCustomParams(rowData);
                customParams.put("hyperLinkClickLineName", fieldName);
                reportShowParameter.setCustomParams(customParams);
                this.getView().showForm((FormShowParameter)reportShowParameter);
                break;
            }
            case "billno": {
                if ("ap_settlerecord".equals(sourceEntity) || "ar_settlerecord".equals(sourceEntity)) {
                    ListShowParameter listShowParameter = new ListShowParameter();
                    listShowParameter.setBillFormId(sourceEntity.toString());
                    listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    listShowParameter.setLookUp(true);
                    ListFilterParameter filterParameter = new ListFilterParameter();
                    filterParameter.setFilter(new QFilter("id", "=", (Object)rowData.getLong("billid")));
                    listShowParameter.setListFilterParameter(filterParameter);
                    this.getView().showForm((FormShowParameter)listShowParameter);
                    break;
                }
                parameter.setFormId(rowData.getDynamicObject("billformid").getString("number"));
                parameter.setPkId((Object)rowData.getLong("billid"));
                parameter.setStatus(OperationStatus.VIEW);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setHasRight(true);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "voucherbillno": {
                parameter.setFormId("gl_voucher");
                parameter.setPkId((Object)rowData.getLong("voucherid"));
                parameter.setStatus(OperationStatus.VIEW);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setHasRight(true);
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }

    private boolean isAr() {
        String formId = this.getView().getFormShowParameter().getFormId();
        return "ar_accountcheck".equals(formId);
    }

    private String getFormKey() {
        return this.getView().getFormShowParameter().getFormId();
    }

    private Map<String, Object> getCustomParams(DynamicObject rowDate) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        HashMap<String, Object> rowData = new HashMap<String, Object>(8);
        customParams.put("isopenbyhyperlink", Boolean.TRUE);
        customParams.put("billid", rowDate.getLong("billid"));
        rowData.put("orgs", rowDate.get("org"));
        rowData.put("isentryshow", Boolean.TRUE);
        rowData.put("accrualdirection", "all");
        rowData.put("billdate", rowDate.getDate("billdate"));
        rowData.put("bookdate", rowDate.getDate("bookdate"));
        String asstacttype = rowDate.getString("asstacttype");
        rowData.put("q_asstacttype", asstacttype);
        if ("bd_customer".equals(asstacttype)) {
            rowData.put("bd_customer", rowDate.get("asstact"));
        }
        if ("bd_supplier".equals(asstacttype)) {
            rowData.put("bd_supplier", rowDate.get("asstact"));
        }
        if ("bos_user".equals(asstacttype)) {
            rowData.put("bos_user", rowDate.get("asstact"));
        }
        rowData.put("q_currency", rowDate.get("currency"));
        if (rowDate.get("billformid") != null) {
            rowData.put("sourceentity", rowDate.getDynamicObject("billformid").getString("number"));
        }
        rowData.put("isvoucher", Boolean.FALSE);
        Object localCur = rowDate.getDataEntityType().getProperties().get((Object)"localcur");
        rowData.put("islocalamt", localCur == null ? Boolean.FALSE : Boolean.TRUE);
        customParams.put("rowData", rowData);
        return customParams;
    }

    private void setMapValue(Map<String, List<String>> extendField, String key, String value) {
        List<String> filterName = extendField.get(key);
        if (filterName == null) {
            filterName = new ArrayList<String>(4);
            filterName.add(value);
            extendField.put(key, filterName);
        } else {
            filterName.add(value);
        }
    }
}

