/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctage;

import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.dataset.groupby.SmartGroupByDataSet;
import kd.fi.arapcommon.report.acctage.AcctageAmtReverser;
import kd.fi.arapcommon.report.acctage.AcctageHelper;
import kd.fi.arapcommon.report.acctage.AcctageRptParam;
import kd.fi.arapcommon.util.DataSetUtils;

public class AcctageBusAmtReverser
implements AcctageAmtReverser {
    private AcctageRptParam param;
    private DataSet adjustBusbills;

    public AcctageBusAmtReverser(AcctageRptParam param, DataSet adjustBusbills) {
        this.param = param;
        this.adjustBusbills = adjustBusbills;
    }

    @Override
    public DataSet reverse(DataSet ds) {
        JoinDataSet joinDataSet = null;
        List<String> selectedFields = DataSetUtils.getSelectedFields(ds, "balance", "localbalance", "unsettleamt", "localunsettleamt");
        if (this.adjustBusbills instanceof SmartGroupByDataSet) {
            joinDataSet = ds.join(this.adjustBusbills, JoinType.LEFT).on("id", "e_srcbillid");
            selectedFields.add("case when e_recamount=null then balance else balance + e_recamount*(-1) end as balance");
            if (this.param.getAnalysisAmtFields().length > 1) {
                selectedFields.add("case when e_reclocalamt=null then localbalance else localbalance + e_reclocalamt*(-1) end as localbalance");
            }
        } else {
            DataSet groupByAdjustBusBill = this.adjustBusbills.groupBy(new String[]{"e_srcbillid"}).sum("e_recamount").sum("e_reclocalamt").finish();
            joinDataSet = ds.join(groupByAdjustBusBill, JoinType.LEFT).on("id", "e_srcbillid");
            selectedFields.add("case when e_recamount=null then balance else balance + e_recamount end as balance");
            if (this.param.getAnalysisAmtFields().length > 1) {
                selectedFields.add("case when e_reclocalamt=null then localbalance else localbalance + e_reclocalamt end as localbalance");
            }
        }
        if (this.param.getAnalysisAmtFields().length > 1) {
            DataSet adjExchBills = AcctageHelper.getAdjExchBillForOldAcctage(this.param);
            DataSet finbills = joinDataSet.select(selectedFields.toArray(new String[0]), new String[0]).finish();
            JoinDataSet adjJoinDataSet = finbills.leftJoin(adjExchBills).on("id", "sourcebillid");
            List<String> selectedFields1 = DataSetUtils.getSelectedFields(finbills, "localbalance");
            selectedFields1.add("case when curgainloss=null then localbalance else localbalance+curgainloss end as localbalance");
            return adjJoinDataSet.select(selectedFields1.toArray(new String[0]), new String[0]).finish();
        }
        return joinDataSet.select(selectedFields.toArray(new String[0]), new String[0]).finish();
    }
}

