/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctage;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.report.acctage.AcctageAmtReverser;
import kd.fi.arapcommon.report.acctage.AcctageRptParam;
import kd.fi.arapcommon.util.DataSetUtils;

public class AcctageBusWoffAmtReverser
implements AcctageAmtReverser {
    private AcctageRptParam param;

    public AcctageBusWoffAmtReverser(AcctageRptParam param) {
        this.param = param;
    }

    @Override
    public DataSet reverse(DataSet ds) {
        List<QFilter> woffFilters = this.getWoffBusFilters(this.param);
        DataSet woffBusBills = "ar_busbill".equals(this.param.getEntity()) ? QueryServiceHelper.queryDataSet((String)"fi.arap.AcctageBusWoffAmtReverser.ar_busbill", (String)this.param.getEntity(), (String)"entry.e_recamount e_recamount,entry.e_reclocalamt e_reclocalamt,entry.e_srcbillid e_srcbillid", (QFilter[])woffFilters.toArray(new QFilter[0]), null) : QueryServiceHelper.queryDataSet((String)"fi.arap.AcctageBusWoffAmtReverser.ap_busbill", (String)this.param.getEntity(), (String)"entry.e_pricetaxtotal e_recamount,entry.e_pricetaxtotalbase e_reclocalamt,entry.e_srcbillid e_srcbillid", (QFilter[])woffFilters.toArray(new QFilter[0]), null);
        DataSet groupByAdjustBusBill = woffBusBills.groupBy(new String[]{"e_srcbillid"}).sum("e_recamount").sum("e_reclocalamt").finish();
        JoinDataSet joinDataSet = ds.join(groupByAdjustBusBill, JoinType.LEFT).on("id", "e_srcbillid");
        List<String> selectedFields = DataSetUtils.getSelectedFields(ds, "balance", "localbalance", "unsettleamt", "localunsettleamt");
        selectedFields.add("case when e_recamount=null then balance else balance+e_recamount end as balance");
        if (this.param.getAnalysisAmtFields().length > 1) {
            selectedFields.add("case when e_reclocalamt=null then localbalance else localbalance+e_reclocalamt end as localbalance");
        }
        DataSet finish = joinDataSet.select(selectedFields.toArray(new String[0]), new String[0]).finish();
        return finish;
    }

    private List<QFilter> getWoffBusFilters(AcctageRptParam param) {
        LinkedList<QFilter> woffFilters = new LinkedList<QFilter>();
        woffFilters.addAll(param.getFilters());
        Iterator iterator = woffFilters.iterator();
        while (iterator.hasNext()) {
            QFilter next = (QFilter)iterator.next();
            if (!"isadjust".equals(next.getProperty())) continue;
            iterator.remove();
        }
        woffFilters.add(new QFilter("isadjust", "=", (Object)Boolean.TRUE));
        return woffFilters;
    }
}

