/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctage;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.report.acctage.AcctageCustomizer;
import kd.fi.arapcommon.report.acctage.AcctageGroup;
import kd.fi.arapcommon.report.acctage.AcctageHelper;
import org.apache.commons.lang3.tuple.MutableTriple;

public class AcctageChartPlugin
extends AbstractReportFormPlugin {
    public void afterQuery(ReportQueryParam queryParam) {
        boolean showSum;
        DataSet dataSet = AcctageHelper.getFromThreadLocal();
        List groups = (List)queryParam.getFilter().getFilterItem("groups").getValue();
        AcctageCustomizer acctageCustomizer = new AcctageCustomizer(queryParam);
        boolean bl = showSum = acctageCustomizer.getSumDimensions() != null;
        if (showSum) {
            dataSet = dataSet.filter("sumlevel=0");
        }
        if (dataSet != null) {
            DataSet groupChartDataSet = dataSet.copy();
            this.drawAsstactChart(dataSet, groups);
            this.drawGroupChart(groupChartDataSet, groups);
        }
    }

    private void drawAsstactChart(DataSet dataSet, List<AcctageGroup> groups) {
        String noneDueAmtName = AcctageHelper.getAmountFieldName(groups.get(0), "balance");
        dataSet = dataSet.addField("balance-" + noneDueAmtName, "overdueamt");
        GroupbyDataSet groupBy = dataSet.groupBy(new String[]{"asstact", "asstacttype"});
        dataSet = groupBy.sum("overdueamt").finish();
        dataSet = dataSet.orderBy(new String[]{"overdueamt DESC"});
        int top = 5;
        int index = 0;
        BigDecimal totalAmt = BigDecimal.ZERO;
        ArrayList<MutableTriple> list = new ArrayList<MutableTriple>();
        for (Row row : dataSet) {
            Object overdueAmt = row.getBigDecimal("overdueamt");
            overdueAmt = overdueAmt == null ? BigDecimal.ZERO : overdueAmt;
            totalAmt = totalAmt.add((BigDecimal)overdueAmt);
            if (index < top) {
                String asstactType = row.getString("asstacttype");
                Long asstact = row.getLong("asstact");
                list.add(new MutableTriple((Object)asstactType, (Object)asstact, overdueAmt));
                ++index;
                continue;
            }
            if (index == top) {
                list.add(new MutableTriple((Object)"OTHER", (Object)0L, overdueAmt));
                ++index;
                continue;
            }
            MutableTriple triple = (MutableTriple)list.get(top);
            BigDecimal amt = (BigDecimal)triple.getRight();
            triple.setRight((Object)amt.add((BigDecimal)overdueAmt));
        }
        ArrayList<ItemValue> itemValues = new ArrayList<ItemValue>();
        if (BigDecimal.ZERO.compareTo(totalAmt) == 0) {
            itemValues.add(new ItemValue(ResManager.loadKDString((String)"\u65e0\u6570\u636e", (String)"AcctageChartPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]), (Number)1));
        } else {
            NumberFormat formatter = NumberFormat.getPercentInstance();
            formatter.setMinimumFractionDigits(2);
            for (MutableTriple action : list) {
                String pecent = formatter.format(((BigDecimal)action.getRight()).divide(totalAmt, 2));
                if ("OTHER".equals(action.getLeft())) {
                    itemValues.add(new ItemValue(String.format(ResManager.loadKDString((String)"\u5176\u4ed6(%s)", (String)"AcctageChartPlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]), pecent), (Number)action.getRight()));
                    continue;
                }
                DynamicObject asstact = QueryServiceHelper.queryOne((String)((String)action.getLeft()), (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", action.getMiddle())});
                itemValues.add(new ItemValue(asstact.getString("name") + "(" + pecent + ")", (Number)action.getRight()));
            }
        }
        PieChart pieChart = (PieChart)this.getControl("asstactchart");
        pieChart.clearData();
        PieSeries series = pieChart.createPieSeries(ResManager.loadKDString((String)"\u8d26\u9f84\u5206\u7ec4\u6570\u636e\u6c47\u603b", (String)"AcctageChartPlugin_2", (String)"fi-arapcommon", (Object[])new Object[0]));
        series.setData(itemValues.toArray(new ItemValue[0]));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("color", "#7F93BC");
        map.put("fontSize", 20);
        map.put("fontWeight", "lighter");
        pieChart.setTitlePropValue("textStyle", map);
        map = new HashMap();
        HashMap<String, Boolean> normalMap = new HashMap<String, Boolean>();
        map.put("normal", normalMap);
        normalMap.put("show", Boolean.FALSE);
        series.setPropValue("label", map);
        map = new HashMap();
        normalMap = new HashMap();
        map.put("normal", normalMap);
        normalMap.put("show", Boolean.FALSE);
        series.setPropValue("labelLine", map);
        pieChart.setLegendPropValue("right", (Object)10);
        pieChart.setLegendPropValue("top", (Object)"30");
        pieChart.setLegendPropValue("itemWidth", (Object)10);
        pieChart.setLegendPropValue("itemHeight", (Object)10);
        pieChart.refresh();
    }

    private void drawGroupChart(DataSet dataSet, List<AcctageGroup> groups) {
        dataSet = dataSet.addField("1", "a");
        GroupbyDataSet groupBy = dataSet.groupBy(new String[]{"a"});
        HashMap<AcctageGroup, BigDecimal> groupAmountSum = new HashMap<AcctageGroup, BigDecimal>();
        for (AcctageGroup group : groups) {
            groupBy.sum(AcctageHelper.getAmountFieldName(group, "balance"));
        }
        DataSet finish = groupBy.finish();
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (Row row : finish) {
            for (AcctageGroup acctageGroup : groups) {
                BigDecimal amount = row.getBigDecimal(AcctageHelper.getAmountFieldName(acctageGroup, "balance"));
                totalAmount = totalAmount.add(amount);
                groupAmountSum.put(acctageGroup, amount);
            }
        }
        ArrayList<ItemValue> itemValues = new ArrayList<ItemValue>();
        if (BigDecimal.ZERO.compareTo(totalAmount) == 0) {
            itemValues.add(new ItemValue(ResManager.loadKDString((String)"\u65e0\u6570\u636e", (String)"AcctageChartPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]), (Number)1));
        } else {
            NumberFormat nt = NumberFormat.getPercentInstance();
            nt.setMinimumFractionDigits(2);
            for (Map.Entry entry : groupAmountSum.entrySet()) {
                AcctageGroup group = (AcctageGroup)entry.getKey();
                BigDecimal amt = (BigDecimal)entry.getValue();
                String pecentStr = null;
                if (amt.compareTo(BigDecimal.ZERO) == 0) {
                    pecentStr = "0%";
                } else {
                    BigDecimal pecent = amt.divide(totalAmount, 2);
                    pecentStr = nt.format(pecent);
                }
                itemValues.add(new ItemValue(group.displayName + "(" + pecentStr + ")", (Number)amt));
            }
        }
        PieChart pieChart = (PieChart)this.getControl("groupchart");
        pieChart.clearData();
        PieSeries series = pieChart.createPieSeries(ResManager.loadKDString((String)"\u8d26\u9f84\u5206\u7ec4\u6570\u636e\u6c47\u603b", (String)"AcctageChartPlugin_2", (String)"fi-arapcommon", (Object[])new Object[0]));
        series.setData(itemValues.toArray(new ItemValue[0]));
        series.setRadius("40%", "80%");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("color", "#7F93BC");
        hashMap.put("fontSize", 20);
        hashMap.put("fontWeight", "lighter");
        pieChart.setTitlePropValue("textStyle", hashMap);
        HashMap hashMap2 = new HashMap();
        HashMap<String, Boolean> normalMap = new HashMap<String, Boolean>();
        hashMap2.put("normal", normalMap);
        normalMap.put("show", Boolean.FALSE);
        series.setPropValue("label", hashMap2);
        HashMap<String, HashMap<String, Boolean>> hashMap3 = new HashMap<String, HashMap<String, Boolean>>();
        normalMap = new HashMap();
        hashMap3.put("normal", normalMap);
        normalMap.put("show", Boolean.FALSE);
        series.setPropValue("labelLine", hashMap3);
        pieChart.setLegendPropValue("left", (Object)10);
        pieChart.setLegendPropValue("top", (Object)"30");
        pieChart.setLegendPropValue("itemWidth", (Object)10);
        pieChart.setLegendPropValue("itemHeight", (Object)10);
        pieChart.refresh();
    }
}

