/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.fi.arapcommon.report.DefaultCustomSettingParser;
import kd.fi.arapcommon.report.SumParam;
import kd.fi.arapcommon.report.acctage.AcctageHelper;
import kd.fi.arapcommon.report.acctage.AcctageRptParam;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

public class AcctageCustomizer
extends DefaultCustomSettingParser {
    public AcctageCustomizer(ReportQueryParam queryParam) {
        super(queryParam);
    }

    public void customize(AcctageRptParam param) {
        List<String> statisticalDimensions = this.getStatisticalDimensions();
        for (String dimension : statisticalDimensions) {
            if ("billtype".equals(dimension) && "ap_finapbill".equals(param.getEntity())) {
                param.addStatisticalDimention("billtypeid", dimension);
                continue;
            }
            param.addStatisticalDimentions(dimension);
        }
        ArrayList<String> summaryFields = new ArrayList<String>(param.getGroups().size() * 2);
        for (int i = 0; i < param.getGroups().size(); ++i) {
            summaryFields.add(AcctageHelper.getAmountFieldName(param.getGroups().get(i), "balance"));
            if (!this.showBaseCurrency()) continue;
            summaryFields.add(AcctageHelper.getAmountFieldName(param.getGroups().get(i), "localbalance"));
        }
        summaryFields.add("recamt");
        summaryFields.add("balance");
        if (this.showBaseCurrency()) {
            summaryFields.add("localrecamt");
            summaryFields.add("localbalance");
        }
        if (this.showSumRow()) {
            List<String> sumDimensions = this.getSumDimensions();
            SumParam sumParam = new SumParam(SumParam.SumType.SUM);
            sumParam.setGroupByFields(sumDimensions);
            sumParam.setSummaryFields(summaryFields);
            param.setSumParam(sumParam);
        }
        List<String> totalSumDimensions = this.getTotalSumDimensions();
        SumParam totalSumParam = new SumParam(SumParam.SumType.TOTAL);
        totalSumParam.setGroupByFields(totalSumDimensions);
        totalSumParam.setSummaryFields(summaryFields);
        param.setTotalSumParam(totalSumParam);
        param.getFilters().addAll(this.getCustomFilters());
    }

    @Override
    public List<String> getStatisticalDimensions() {
        FilterInfo filter = this.queryParam.getFilter();
        String statisticalDimensionSetting = filter.getString("statisticaldimension");
        String[] statisticalDimensions = statisticalDimensionSetting.split("[,]");
        HashSet<String> statisticalDimensionList = new HashSet<String>(Arrays.asList(statisticalDimensions));
        statisticalDimensionList.add("currency");
        if (this.showBaseCurrency()) {
            statisticalDimensionList.add("basecurrency");
        }
        if (this.showByBill()) {
            statisticalDimensionList.add("id");
            statisticalDimensionList.add("billno");
            statisticalDimensionList.add("bizdate");
            statisticalDimensionList.add("entitykey");
            statisticalDimensionList.add("billtype");
            String comapreDateFieldKey = StringUtils.removePrefix(filter.getString("standard"));
            if (!"bizdate".equals(StringUtils.removePrefix(comapreDateFieldKey))) {
                statisticalDimensionList.add(comapreDateFieldKey);
            }
        }
        return new ArrayList<String>(statisticalDimensionList);
    }

    @Override
    public boolean showBaseCurrency() {
        return this.queryParam.getFilter().getBoolean("showlocalamt");
    }

    @Override
    public boolean showSumRow() {
        String sumSetting;
        return this.showByBill() && !EmptyUtils.isEmpty(sumSetting = this.queryParam.getFilter().getString("sumsetting")) && !"NULL".equals(sumSetting);
    }

    @Override
    public List<String> getSumDimensions() {
        ArrayList<String> dimensions = new ArrayList<String>();
        String sumSetting = this.queryParam.getFilter().getString("sumsetting");
        if (!EmptyUtils.isEmpty(sumSetting) && !"NULL".equals(sumSetting)) {
            String[] split;
            for (String field : split = sumSetting.split("[,]")) {
                dimensions.add(field);
            }
            if (!dimensions.contains("currency")) {
                dimensions.add("currency");
            }
            if (this.showBaseCurrency()) {
                if (!dimensions.contains("basecurrency")) {
                    dimensions.add("basecurrency");
                }
            } else {
                dimensions.remove("basecurrency");
            }
        }
        return dimensions;
    }

    public boolean showByBill() {
        return this.queryParam.getFilter().getBoolean("showbybill");
    }
}

