/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctage;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.arapcommon.report.acctage.AcctageGroup;
import kd.fi.arapcommon.report.acctage.AcctageHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class AcctageRptSettingPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"confirm"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<AcctageGroup> groups = null;
        try {
            String groupKey = this.groupKey();
            groups = groupKey != null ? AcctageHelper.getGroups(this.isAr(), groupKey) : AcctageHelper.getGroups(this.isAr());
        }
        catch (KDBizException exc) {
            this.getView().showTipNotification(exc.getMessage());
            groups = AcctageHelper.getDefaultGroups(this.isAr());
        }
        for (AcctageGroup group : groups) {
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("groupname", (Object)group.displayName, index);
            this.getModel().setValue("day", (Object)(group.endDay == null || group.endDay < 0 ? group.beginDay : group.endDay), index);
            this.getModel().setValue("remark", (Object)group.remark, index);
        }
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        this.getView().setEnable(Boolean.FALSE, rowCount - 1, new String[]{"day"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("day".equalsIgnoreCase(key)) {
            this.refreshGrid();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        this.refreshGrid();
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        this.refreshGrid();
    }

    private void refreshGrid() {
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < rowCount; ++i) {
            if (i != 0 && i == rowCount - 1) {
                Integer previousRowDay = (Integer)this.getModel().getValue("day", i - 1);
                String groupName = (String)this.getModel().getValue("groupname", i);
                if (ObjectUtils.isEmpty((Object)groupName)) {
                    this.getModel().setValue("groupname", (Object)String.format(ResManager.loadKDString((String)"%s\u5929\u4ee5\u4e0a", (String)"AcctageRptSettingPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]), previousRowDay), i);
                }
                this.getModel().setValue("day", (Object)(previousRowDay + 1), i);
            }
            if (i == rowCount - 1) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"day"});
                continue;
            }
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"day"});
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("confirm".equalsIgnoreCase(key) && this.validate()) {
            this.confirm();
        }
    }

    private boolean validate() {
        int i;
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        if (rowCount < 2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u8bbe\u7f6e\u4e24\u4e2a\u8d26\u9f84\u5206\u7ec4\u3002", (String)"AcctageRptSettingPlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        for (i = 1; i < rowCount; ++i) {
            Integer previousRowDay = (Integer)this.getModel().getValue("day", i - 1);
            Integer currentRowDay = (Integer)this.getModel().getValue("day", i);
            if (currentRowDay > previousRowDay) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8d26\u9f84\u5206\u7ec4\u6570\u636e\u9519\u8bef\uff1a\u5929\u6570\u4e0d\u80fd\u5c0f\u4e8e\u4e0a\u4e00\u884c\u7684\u5929\u6570\u3002", (String)"AcctageRptSettingPlugin_2", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
            return false;
        }
        for (i = 0; i < rowCount; ++i) {
            if (!EmptyUtils.isEmpty(this.getModel().getValue("groupname", i))) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u8bf7\u8865\u5145\u8d26\u9f84\u5206\u7ec4\u540d\u79f0\u3002", (String)"AcctageRptSettingPlugin_3", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
            return false;
        }
        return true;
    }

    private void confirm() {
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        ArrayList<AcctageGroup> groups = new ArrayList<AcctageGroup>(64);
        for (int i = 0; i < rowCount; ++i) {
            Integer beginDay = null;
            Integer endDay = null;
            if (i == 0) {
                beginDay = 0;
                endDay = (Integer)this.getModel().getValue("day", i);
                if (endDay < 0) {
                    beginDay = endDay;
                    endDay = (Integer)this.getModel().getValue("day", i + 1) - 1;
                    if (endDay > 0) {
                        endDay = -1;
                    }
                }
            } else if (i == rowCount - 1) {
                beginDay = (Integer)this.getModel().getValue("day", i);
            } else {
                beginDay = (Integer)this.getModel().getValue("day", i - 1) + 1;
                endDay = (Integer)this.getModel().getValue("day", i);
                if (beginDay < 0 && endDay < 0) {
                    beginDay = endDay;
                    Integer afterEndDay = (Integer)this.getModel().getValue("day", i + 1);
                    endDay = afterEndDay > 0 ? Integer.valueOf(-1) : Integer.valueOf(afterEndDay - 1);
                }
                if (beginDay < 0 && endDay > 0) {
                    beginDay = 0;
                }
            }
            String name = (String)this.getModel().getValue("groupname", i);
            String remark = (String)this.getModel().getValue("remark", i);
            AcctageGroup group = new AcctageGroup(name, beginDay, endDay);
            group.remark = remark;
            groups.add(group);
        }
        boolean saveAsDefault = (Boolean)this.getModel().getValue("saveasdefault");
        boolean isAr = this.isAr();
        String groupKey = this.groupKey();
        if (saveAsDefault) {
            boolean result = false;
            result = groupKey != null ? AcctageHelper.saveGroupSetting(groups, isAr, groupKey) : AcctageHelper.saveGroupSetting(groups, isAr);
            if (result) {
                this.getView().returnDataToParent(groups);
                IFormView view = this.getView().getParentView();
                if (view == null) {
                    view = this.getView();
                }
                view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AcctageRptSettingPlugin_4", (String)"fi-arapcommon", (Object[])new Object[0]));
                this.getView().close();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u8bbe\u7f6e\u5931\u8d25\u3002", (String)"AcctageRptSettingPlugin_5", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        } else {
            this.getView().returnDataToParent(groups);
            this.getView().close();
        }
    }

    private boolean isAr() {
        Boolean isAr = (Boolean)this.getView().getFormShowParameter().getCustomParam("isAr");
        return isAr == null ? false : isAr;
    }

    private String groupKey() {
        String groupKey = (String)this.getView().getFormShowParameter().getCustomParam("groupKey");
        return groupKey == null ? null : groupKey;
    }
}

