/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctage;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.report.acctage.AcctageAmtReverser;
import kd.fi.arapcommon.report.acctage.AcctageRptParam;
import kd.fi.arapcommon.util.DataSetUtils;
import kd.fi.arapcommon.util.DateUtils;

public class ArapAcctageAmtReverser
implements AcctageAmtReverser {
    private AcctageRptParam param;
    private boolean isAr;

    public ArapAcctageAmtReverser(AcctageRptParam param, boolean isAr) {
        this.param = param;
        this.isAr = isAr;
    }

    @Override
    public DataSet reverse(DataSet ds) {
        return this.recoverDataFromSettleRecord(ds);
    }

    private DataSet recoverDataFromSettleRecord(DataSet detailDataSet) {
        List<Object> currencyIds;
        String asstactType;
        Date compareDate = DateUtils.getDataFormat(this.param.getQueryDate(), false);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("settledate", ">", (Object)compareDate));
        List<Object> orgIds = this.param.getOrgIds();
        if (!orgIds.isEmpty()) {
            filters.add(new QFilter("org", "in", orgIds));
        }
        if (!StringUtils.isBlank((CharSequence)(asstactType = this.param.getAsstactType()))) {
            filters.add(new QFilter("mainasstacttype", "=", (Object)asstactType));
        }
        if (!(currencyIds = this.param.getCurrencyIds()).isEmpty()) {
            filters.add(new QFilter("maincurrency", "in", currencyIds));
        }
        ArrayList<String> queryFields = new ArrayList<String>();
        queryFields.add("mainbillid");
        ArrayList<String> amtFields = new ArrayList<String>();
        amtFields.add("totalsettleamt");
        if (this.param.getAnalysisAmtFields().length > 1) {
            amtFields.add("localtotalsettleamt");
        }
        queryFields.addAll(amtFields);
        String settleRecordEntity = this.isAr ? "ar_settlerecord" : "ap_settlerecord";
        DataSet settleRecordDataSet = QueryServiceHelper.queryDataSet((String)"ArapAcctageAmtReverser.settlerecord", (String)settleRecordEntity, (String)String.join((CharSequence)",", queryFields), (QFilter[])filters.toArray(new QFilter[0]), null);
        GroupbyDataSet groupBy = settleRecordDataSet.groupBy(new String[]{"mainbillid"});
        for (String s : amtFields) {
            groupBy = groupBy.sum(s);
        }
        settleRecordDataSet = groupBy.finish();
        JoinDataSet joinDataSet = detailDataSet.join(settleRecordDataSet, JoinType.LEFT).on("id", "mainbillid");
        List<String> selectedFields = DataSetUtils.getSelectedFields(detailDataSet, "balance", "localbalance");
        selectedFields.add("case when totalsettleamt=null then balance else balance+totalsettleamt end as balance");
        if (this.param.getAnalysisAmtFields().length > 1) {
            selectedFields.add("case when localtotalsettleamt=null then localbalance else localbalance+localtotalsettleamt end as localbalance");
        }
        detailDataSet = joinDataSet.select(selectedFields.toArray(new String[0]), new String[0]).finish();
        return detailDataSet;
    }
}

