/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctage;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.journal.convert.BasedataBatchReader;
import kd.fi.arapcommon.report.SumParam;
import kd.fi.arapcommon.report.acctage.AcctageAmtReverser;
import kd.fi.arapcommon.report.acctage.AcctageGroup;
import kd.fi.arapcommon.report.acctage.AcctageHelper;
import kd.fi.arapcommon.report.acctage.AcctageRptParam;
import kd.fi.arapcommon.util.DataSetUtils;
import kd.fi.arapcommon.util.DateUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ArapAcctageDataProvider {
    private static final Log logger = LogFactory.getLog(ArapAcctageDataProvider.class);
    private AcctageAmtReverser acctageAmtReverser;
    private AcctageRptParam param;
    private List<AcctageGroup> groups;

    public ArapAcctageDataProvider(AcctageRptParam param, AcctageAmtReverser acctageAmtReverser) {
        this.acctageAmtReverser = acctageAmtReverser;
        this.param = param;
        this.groups = param.getGroups();
    }

    public DataSet query() {
        List<String> queryFields = this.getQueryFields();
        DataSet rawDataSet = null;
        if (this.param.isRecoverHistoryData()) {
            logger.info("ArapAcctageDataProvider_0 : search " + this.param.getEntity() + "  filters is" + this.param.getFilters());
            rawDataSet = ArApXDBHelper.queryDataSet(this.param.getEntity(), String.join((CharSequence)",", queryFields), this.param.getFilters(), null, "acctagequery");
            rawDataSet = this.recoverHistoryData(rawDataSet);
            rawDataSet = this.divideAmountIntoGroup(rawDataSet);
        } else {
            Pair<String, String>[] analysisAmtFields = this.param.getAnalysisAmtFields();
            for (AcctageGroup group : this.groups) {
                for (Pair<String, String> anlaysisField : analysisAmtFields) {
                    queryFields.add(this.getGroupCase(group, (String)anlaysisField.getKey(), AcctageHelper.getAmountFieldName(group, (String)anlaysisField.getValue())));
                }
            }
            rawDataSet = ArApXDBHelper.queryDataSet(this.param.getEntity(), String.join((CharSequence)",", queryFields), this.param.getFilters(), null, "acctagequery");
        }
        DataSet statisticalDataSet = rawDataSet = rawDataSet.filter("balance <> 0");
        if (this.param.getStatisticalSumParam() != null) {
            statisticalDataSet = DataSetUtils.sum(rawDataSet, this.param.getStatisticalSumParam());
        }
        DataSet finalResult = statisticalDataSet;
        if (this.param.isAutoSum()) {
            SumParam sumParam = this.param.getSumParam();
            SumParam totalSumParam = this.param.getTotalSumParam();
            finalResult = DataSetUtils.sum(statisticalDataSet, Arrays.asList(sumParam, totalSumParam));
        }
        return finalResult;
    }

    private String getGroupCase(AcctageGroup group, String anlaysisAmtField, String alias) {
        Date queryDate = this.param.getQueryDate();
        String compareDateFieldName = (String)this.param.getCompareDateField().getKey();
        SimpleDateFormat sdf = new SimpleDateFormat("yyy-MM-dd HH:mm:ss");
        if (group.beginDay == null && group.endDay != null) {
            Date beginDate = DateUtils.getDataFormat(DateUtils.getLastDay(queryDate, group.endDay), true);
            return String.format("case when %s>='%s' then %s else %s end as %s ", compareDateFieldName, sdf.format(beginDate), anlaysisAmtField, 0, alias);
        }
        if (group.beginDay != null && group.endDay == null) {
            Date endDate = DateUtils.getDataFormat(DateUtils.getLastDay(queryDate, group.beginDay), false);
            return String.format("case when %s<='%s' then %s else %s end as %s", compareDateFieldName, sdf.format(endDate), anlaysisAmtField, 0, alias);
        }
        if (group.beginDay != null && group.endDay != null) {
            Date beginDate = DateUtils.getDataFormat(DateUtils.getLastDay(queryDate, group.endDay), true);
            Date endDate = DateUtils.getDataFormat(DateUtils.getLastDay(queryDate, group.beginDay), false);
            return String.format("case when %s>='%s' and %s<='%s' then %s else %s end as %s", compareDateFieldName, sdf.format(beginDate), compareDateFieldName, sdf.format(endDate), anlaysisAmtField, 0, alias);
        }
        throw new RuntimeException("Acct Age Group Err!");
    }

    private DataSet recoverHistoryData(DataSet detailDataSet) {
        if (this.acctageAmtReverser != null) {
            return this.acctageAmtReverser.reverse(detailDataSet);
        }
        return detailDataSet;
    }

    private DataSet divideAmountIntoGroup(DataSet dataSet) {
        String compareDateField = (String)this.param.getCompareDateField().getValue();
        Field[] fields = dataSet.getRowMeta().getFields();
        int asstactTypeIndex = -1;
        int asstactIndex = -1;
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if ("asstacttype".equalsIgnoreCase(field.getName())) {
                asstactTypeIndex = i;
                continue;
            }
            if (!"asstact".equalsIgnoreCase(field.getName())) continue;
            asstactIndex = i;
        }
        int oldLength = fields.length;
        int newLength = oldLength + this.groups.size() * this.param.getAnalysisAmtFields().length;
        Field[] newFields = Arrays.copyOf(fields, newLength);
        for (int i = 0; i < this.param.getAnalysisAmtFields().length; ++i) {
            for (int j = 0; j < this.groups.size(); ++j) {
                int offset = i * this.groups.size() + j;
                newFields[oldLength + offset] = new Field(AcctageHelper.getAmountFieldName(this.groups.get(j), (String)this.param.getAnalysisAmtFields()[i].getValue()), (DataType)DataType.BigDecimalType);
            }
        }
        DataSetBuilder dataSetBuilder = Algo.create((String)"ap.acctagegroup.DivideGroup").createDataSetBuilder(new RowMeta(newFields));
        BasedataBatchReader basedataBatchReader = new BasedataBatchReader();
        for (Row row : dataSet) {
            int i;
            Object[] rowData = new Object[newLength];
            for (i = 0; i < oldLength; ++i) {
                rowData[i] = row.get(i);
            }
            if (asstactTypeIndex >= 0 && asstactIndex >= 0) {
                basedataBatchReader.addParam((String)rowData[asstactTypeIndex], rowData[asstactIndex]);
            }
            for (i = oldLength; i < newLength; ++i) {
                rowData[i] = BigDecimal.ZERO;
            }
            Date compareDate = row.getDate(compareDateField);
            block6: for (int i2 = 0; i2 < this.param.getAnalysisAmtFields().length; ++i2) {
                String anlaysisField = (String)this.param.getAnalysisAmtFields()[i2].getValue();
                for (int j = 0; j < this.groups.size(); ++j) {
                    AcctageGroup group = this.groups.get(j);
                    if (!AcctageHelper.match(group, this.param.getQueryDate(), compareDate)) continue;
                    Object amt = row.get(anlaysisField);
                    int offset = i2 * this.groups.size() + j;
                    rowData[oldLength + offset] = amt;
                    if (j != 0) continue block6;
                }
            }
            if (this.param.getIsHyperLinkClick()) {
                BigDecimal balanceAmount = new BigDecimal(rowData[oldLength].toString());
                if (balanceAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                dataSetBuilder.append(rowData);
                continue;
            }
            dataSetBuilder.append(rowData);
        }
        DataSet tempDataSet = dataSetBuilder.build();
        dataSetBuilder = Algo.create((String)"ap.acctagegroup.DivideGroup").createDataSetBuilder(new RowMeta(newFields));
        while (tempDataSet.hasNext()) {
            long masterId;
            DynamicObject basedata;
            Row row = tempDataSet.next();
            Object[] rowData = new Object[newLength];
            for (int i = 0; i < newLength; ++i) {
                rowData[i] = row.get(i);
            }
            if (asstactTypeIndex >= 0 && asstactIndex >= 0 && (basedata = basedataBatchReader.read((String)rowData[asstactTypeIndex], rowData[asstactIndex])) != null && (masterId = basedata.getLong("masterid")) != 0L) {
                rowData[asstactIndex] = masterId;
            }
            dataSetBuilder.append(rowData);
        }
        return dataSetBuilder.build();
    }

    private List<String> getQueryFields() {
        ArrayList<String> queryFields = new ArrayList<String>();
        boolean containsId = false;
        for (Pair<String, String> field : this.param.getSelectors()) {
            if ("id".equals(field.getKey())) {
                containsId = true;
            }
            if ("entitykey".equals(field.getKey())) {
                queryFields.add(String.format(" '%s' as entitykey", this.param.getEntity()));
                continue;
            }
            queryFields.add((String)field.getKey() + " as " + (String)field.getValue());
        }
        if (!containsId) {
            queryFields.add("id");
        }
        String compareDateField = (String)this.param.getCompareDateField().getKey() + " as " + (String)this.param.getCompareDateField().getValue();
        if (!queryFields.contains(this.param.getCompareDateField().getKey()) && !queryFields.contains(compareDateField)) {
            queryFields.add(compareDateField);
        }
        if (this.param.getEntryName() != null) {
            queryFields.add(this.param.getEntryName() + ".id as entryid");
        }
        return queryFields;
    }
}

