/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctage;

import java.util.ArrayList;
import java.util.List;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.report.SumParam;
import kd.fi.arapcommon.report.acctage.IPreAcctageRptProvider;
import kd.fi.arapcommon.report.acctage.PreAcctageRptParam;

public class PreAcctageRptCasPay
implements IPreAcctageRptProvider {
    @Override
    public String getOrgEntity() {
        return "entry.settleorg";
    }

    @Override
    public String getAsstactTypeEntity() {
        return "payeetype";
    }

    @Override
    public String getAsstactEntity() {
        return "payee";
    }

    @Override
    public String getCurrencyEntity() {
        return "currency";
    }

    @Override
    public String getDateEntity(String standard) {
        return standard;
    }

    @Override
    public String[] getBillStatus(boolean containson) {
        if (containson) {
            return new String[]{"A", "B", "C", "D", "E", "I", "F"};
        }
        return new String[]{"D", "I", "F"};
    }

    @Override
    public String getPaymentBillTypeEntity() {
        return "entry.e_paymenttype";
    }

    @Override
    public List<String> selectFields(PreAcctageRptParam param) {
        ArrayList<String> selectFields = new ArrayList<String>(16);
        List<String> statisticalDimensions = param.getStatisticalSumParam().getGroupByFields();
        selectFields.add("entry.id as id");
        if (statisticalDimensions.contains("org")) {
            selectFields.add("entry.settleorg as org");
        }
        if (statisticalDimensions.contains("payorg")) {
            selectFields.add("org as payorg");
        }
        selectFields.add("'cas_paybill' as entitykey");
        selectFields.add("payeetype as asstacttype");
        selectFields.add("payee as asstact");
        selectFields.add("basecurrency");
        selectFields.add("currency");
        if (param.isShowbybill()) {
            selectFields.add("entry.e_paymenttype as paymentbilltype");
            selectFields.add("billno");
        }
        selectFields.add("bizdate");
        selectFields.add("paydate");
        selectFields.add("entry.e_payableamt as recamt");
        selectFields.add("entry.e_unsettledamt as balance");
        if (param.isShowlocalamt()) {
            selectFields.add("ROUND(entry.e_payablelocamt,2) as localrecamt");
            selectFields.add("ROUND(entry.e_unsettledlocalamt,2) as localbalance");
        }
        return selectFields;
    }

    @Override
    public List<String> getHideFields(ReportQueryParam queryParam) {
        return null;
    }

    @Override
    public SumParam afterLoadBillSumField(PreAcctageRptParam param) {
        SumParam sumParam = new SumParam(SumParam.SumType.SUM);
        sumParam.addGroupByField("id");
        if (param.isShowlocalamt()) {
            sumParam.addSummaryField("balance", "recamt", "localbalance", "localrecamt");
            return sumParam;
        }
        sumParam.addSummaryField("balance", "recamt");
        return sumParam;
    }

    @Override
    public List<QFilter> queryBillFilter() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter(this.getPaymentBillTypeEntity() + ".biztype", "=", (Object)"202"));
        qFilters.add(new QFilter(this.getPaymentBillTypeEntity() + ".ispartpayment", "=", (Object)"1"));
        return qFilters;
    }
}

