/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.report.SumParam;
import kd.fi.arapcommon.report.acctage.IPreAcctageRptProvider;
import kd.fi.arapcommon.report.acctage.PreAcctageRptParam;

public class PreAcctageRptPaidBill
implements IPreAcctageRptProvider {
    @Override
    public String getOrgEntity() {
        return "org";
    }

    @Override
    public String getAsstactTypeEntity() {
        return "payeetype";
    }

    @Override
    public String getAsstactEntity() {
        return "payee";
    }

    @Override
    public String getCurrencyEntity() {
        return "currency";
    }

    @Override
    public String getDateEntity(String standard) {
        return "bizdate";
    }

    @Override
    public String[] getBillStatus(boolean containson) {
        if (containson) {
            return new String[]{"A", "B", "C"};
        }
        return new String[]{"C"};
    }

    @Override
    public String getPaymentBillTypeEntity() {
        return "paymenttype";
    }

    @Override
    public List<String> selectFields(PreAcctageRptParam param) {
        ArrayList<String> selectFields = new ArrayList<String>(16);
        List<String> statisticalDimensions = param.getStatisticalSumParam().getGroupByFields();
        selectFields.add("id");
        if (statisticalDimensions.contains("org")) {
            selectFields.add("org");
        }
        if (statisticalDimensions.contains("payorg")) {
            selectFields.add("payorg");
        }
        selectFields.add("'ap_paidbill' as entitykey");
        selectFields.add("payeetype as asstacttype");
        selectFields.add("payee as asstact");
        selectFields.add("basecurrency");
        selectFields.add("currency");
        if (param.isShowbybill()) {
            selectFields.add("paymenttype as paymentbilltype");
            selectFields.add("billno");
        }
        selectFields.add("bizdate");
        selectFields.add("bizdate as paydate");
        selectFields.add("actpayamt as recamt");
        selectFields.add("entry.e_unsettledamt as balance");
        if (param.isShowlocalamt()) {
            selectFields.add("ROUND(localamt,2) as localrecamt");
            selectFields.add("case when quotation ='1' then ROUND(entry.e_unsettledamt/exchangerate,2) else ROUND(entry.e_unsettledamt*exchangerate,2) end as localbalance");
        }
        return selectFields;
    }

    @Override
    public List<String> getHideFields(ReportQueryParam queryParam) {
        ArrayList<String> selectFields = new ArrayList<String>(16);
        FilterInfo filterInfo = queryParam.getFilter();
        boolean isShowbybill = filterInfo.getBoolean("showbybill");
        boolean isShowlocalamt = filterInfo.getBoolean("showlocalamt");
        String statisticaldimension = filterInfo.getString("statisticaldimension");
        String[] statisticaldimensions = statisticaldimension.split("[,]");
        List<String> statisticaldimensionsList = Arrays.asList(statisticaldimensions);
        selectFields.add("id");
        if (statisticaldimensionsList.contains("org")) {
            selectFields.add("org");
        }
        if (statisticaldimensionsList.contains("payorg")) {
            selectFields.add("payorg");
        }
        selectFields.add("asstacttype");
        selectFields.add("asstact");
        selectFields.add("currency");
        if (isShowbybill) {
            selectFields.add("paymentbilltype");
            selectFields.add("billno");
            selectFields.add("bizdate");
            if (!filterInfo.getString("standard").contains("bizdate")) {
                selectFields.add("paydate");
            }
        }
        selectFields.add("entitykey");
        selectFields.add("recamt");
        selectFields.add("balance");
        if (isShowlocalamt) {
            selectFields.add("basecurrency");
            selectFields.add("localrecamt");
            selectFields.add("localbalance");
        }
        return selectFields;
    }

    @Override
    public SumParam afterLoadBillSumField(PreAcctageRptParam param) {
        SumParam sumParam = new SumParam(SumParam.SumType.SUM);
        sumParam.addGroupByField("id");
        if (param.isShowlocalamt()) {
            sumParam.addSummaryField("balance", "localbalance");
            return sumParam;
        }
        sumParam.addSummaryField("balance");
        return sumParam;
    }

    @Override
    public List<QFilter> queryBillFilter() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter(this.getPaymentBillTypeEntity() + ".biztype", "=", (Object)"202"));
        qFilters.add(new QFilter(this.getPaymentBillTypeEntity() + ".ispartpayment", "=", (Object)"1"));
        return qFilters;
    }
}

