/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctage;

import java.util.ArrayList;
import java.util.List;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.report.SumParam;
import kd.fi.arapcommon.report.acctage.IPreAcctageRptProvider;
import kd.fi.arapcommon.report.acctage.PreAcctageRptParam;

public class PreAcctageRptReceivedBill
implements IPreAcctageRptProvider {
    @Override
    public String getOrgEntity() {
        return "org";
    }

    @Override
    public String getAsstactTypeEntity() {
        return "asstacttype";
    }

    @Override
    public String getAsstactEntity() {
        return "asstact";
    }

    @Override
    public String getCurrencyEntity() {
        return "currency";
    }

    @Override
    public String getDateEntity(String standard) {
        return "bizdate";
    }

    @Override
    public String[] getBillStatus(boolean containson) {
        if (containson) {
            return new String[]{"A", "B", "C"};
        }
        return new String[]{"C"};
    }

    @Override
    public String getPaymentBillTypeEntity() {
        return "rectype";
    }

    @Override
    public List<String> selectFields(PreAcctageRptParam param) {
        ArrayList<String> selectFields = new ArrayList<String>(18);
        List<String> statisticalDimensions = param.getStatisticalSumParam().getGroupByFields();
        selectFields.add("id");
        if (statisticalDimensions.contains("org")) {
            selectFields.add("org");
        }
        if (statisticalDimensions.contains("payorg")) {
            selectFields.add("recorg as payorg");
        }
        selectFields.add("'ar_receivedbill' as entitykey");
        selectFields.add("asstacttype");
        if ("other".equals(param.getAsstactType())) {
            selectFields.add("payername as asstact_name");
            selectFields.add("payername as asstact");
        } else {
            selectFields.add("asstact");
            selectFields.add("payername as asstact_name");
        }
        selectFields.add("basecurrency");
        selectFields.add("currency");
        if (param.isShowbybill()) {
            selectFields.add("rectype as paymentbilltype");
            selectFields.add("billno");
        }
        selectFields.add("bizdate");
        selectFields.add("bizdate as paydate");
        selectFields.add("recamount as recamt");
        selectFields.add("entry.e_unsettledamt as balance");
        if (param.isShowlocalamt()) {
            selectFields.add("ROUND(localamount,2) as localrecamt");
            selectFields.add("case when quotation ='1' then ROUND(entry.e_unsettledamt/exchangerate,2) else ROUND(entry.e_unsettledamt*exchangerate,2) end as localbalance");
        }
        return selectFields;
    }

    @Override
    public List<String> getHideFields(ReportQueryParam queryParam) {
        return null;
    }

    @Override
    public SumParam afterLoadBillSumField(PreAcctageRptParam param) {
        SumParam sumParam = new SumParam(SumParam.SumType.SUM);
        sumParam.addGroupByField("id");
        if (param.isShowlocalamt()) {
            sumParam.addSummaryField("balance", "localbalance");
            return sumParam;
        }
        sumParam.addSummaryField("balance");
        return sumParam;
    }

    @Override
    public List<QFilter> queryBillFilter() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter(this.getPaymentBillTypeEntity() + ".biztype", "=", (Object)"101"));
        qFilters.add(new QFilter(this.getPaymentBillTypeEntity() + ".ispartreceivable", "=", (Object)"1"));
        return qFilters;
    }
}

