/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctagev2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.entity.report.ReportColumnFactory;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.bplat.scmc.report.core.transform.plan.GroupPlan;
import kd.fi.arapcommon.report.acctage.AcctageGroup;
import kd.fi.arapcommon.report.acctage.AcctageHelper;
import kd.fi.arapcommon.report.acctagev2.AbstractAcctage;
import kd.fi.arapcommon.report.acctagev2.AcctageParam;
import kd.fi.arapcommon.report.acctagev2.impl.BusApBillAcctageImpl;
import kd.fi.arapcommon.report.acctagev2.impl.BusArBillAcctageImpl;
import kd.fi.arapcommon.report.acctagev2.impl.FinApBillAcctageImpl;
import kd.fi.arapcommon.report.acctagev2.impl.FinArBillAcctageImpl;
import kd.fi.arapcommon.report.acctagev2.impl.PaidBillAcctageImpl;
import kd.fi.arapcommon.report.acctagev2.impl.PayBillAcctageImpl;
import kd.fi.arapcommon.report.acctagev2.impl.RecBillAcctageImpl;
import kd.fi.arapcommon.report.acctagev2.impl.ReceivedBillAcctageImpl;
import kd.fi.arapcommon.report.acctagev2.transform.AsstactTransfer;
import kd.fi.arapcommon.report.acctagev2.transform.HandleGroupColumns;
import kd.fi.arapcommon.report.acctagev2.transform.SortResults;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AcctageRptHandle
implements IReportDataHandle {
    private AcctageParam reportParam;
    private boolean isAr;

    public void setupCtx(ReportDataCtx ctx) {
        this.reportParam = (AcctageParam)ctx.getParam(AcctageParam.class.getName());
        ctx.setShowBlockEntity(false);
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getFixedFilter());
        } else {
            fixedFs.addAll(this.getFixedFilter());
        }
        this.setCountQtyCols(ctx);
        ReportConf reportConf = ctx.getReportConf();
        this.isAr = StringUtils.contains((String)ctx.getReportEntity(), (String)"ar_");
        List blockConfs = reportConf.getSrcBlockConf();
        Set<String> entities = this.reportParam.getEntities();
        blockConfs.removeIf(bc -> !entities.contains(bc.getSrcEntity()));
    }

    private List<QFilter> getFixedFilter() {
        List<QFilter> fs = this.getBaseFilters(this.reportParam);
        this.reportParam.getFilters().addAll(fs);
        return fs;
    }

    private List<QFilter> getBaseFilters(AcctageParam param) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        List<Object> currencyIds = param.getCurrencyIds();
        if (currencyIds != null && !currencyIds.isEmpty()) {
            filters.add(new QFilter("currency", "in", currencyIds));
        }
        return filters;
    }

    private void setCountQtyCols(ReportDataCtx ctx) {
        Set qtyCols = ctx.getShowQtyCols();
        List<String> balanceCols = AcctageHelper.getBalanceGroupCols(qtyCols, this.reportParam.getGroups());
        HashSet<String> allQtyCols = new HashSet<String>(balanceCols);
        allQtyCols.addAll(qtyCols);
        ctx.setSumQtyCols4Count(allQtyCols);
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        for (SrcBlockConf blockConf : blockCollector) {
            String srcEntity = blockConf.getSrcEntity();
            AbstractAcctage iAcctage = null;
            if (this.isAr) {
                if ("ar_finarbill".equals(srcEntity)) {
                    iAcctage = new FinArBillAcctageImpl(ctx);
                } else if ("ar_busbill".equals(srcEntity)) {
                    iAcctage = new BusArBillAcctageImpl(ctx);
                } else if ("cas_recbill".equals(srcEntity)) {
                    iAcctage = new RecBillAcctageImpl(ctx);
                } else if ("ar_receivedbill".equals(srcEntity)) {
                    iAcctage = new ReceivedBillAcctageImpl(ctx);
                }
            } else if ("ap_finapbill".equals(srcEntity)) {
                iAcctage = new FinApBillAcctageImpl(ctx);
            } else if ("ap_busbill".equals(srcEntity)) {
                iAcctage = new BusApBillAcctageImpl(ctx);
            } else if ("cas_paybill".equals(srcEntity)) {
                iAcctage = new PayBillAcctageImpl(ctx);
            } else if ("ap_paidbill".equals(srcEntity)) {
                iAcctage = new PaidBillAcctageImpl(ctx);
            }
            if (iAcctage != null) {
                iAcctage.modifyBlock(blockConf);
                continue;
            }
            throw new KDBizException(new ErrorCode("", ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u5b9e\u73b0\u7c7b\u672a\u627e\u5230\u3002", (String)"GlImportFactory_0", (String)"fi-arapcommon", (Object[])new Object[]{srcEntity})), new Object[0]);
        }
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("id");
        repoColFilter.add("comparedate");
        repoColFilter.add("quotation");
        repoColFilter.add("exchangerate");
        repoColFilter.add("entryid");
        if (this.reportParam.isShowByBill()) {
            repoColFilter.add("entitykey");
            String standard = (String)this.reportParam.getCompareDateField().getKey();
            if (!"bizdate".equals(standard)) {
                repoColFilter.add("bizdate");
            }
            if ("planduedate".equals(standard)) {
                repoColFilter.add("planseq");
            }
            repoColFilter.add("billtype");
            repoColFilter.add("id");
            repoColFilter.add("billno");
        }
    }

    public void handleBlockDataSelectCols(Set<String> repoColFilter, SrcBlockConf blockConf, ReportDataCtx ctx) {
        String entryKey;
        String srcEntity;
        Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
        repoColFullSrcColMap.put("id", "id");
        String standard = (String)this.reportParam.getCompareDateField().getValue();
        boolean isPlan = "planduedate".equals(standard);
        repoColFullSrcColMap.put("comparedate", isPlan ? "planentity." + standard : standard);
        if (isPlan) {
            this.reportParam.setEntryName("planentity");
            repoColFullSrcColMap.put("balance", "planentity.unplansettleamt");
            repoColFullSrcColMap.put("balanceloc", "planentity.unplansettlelocamt");
            repoColFullSrcColMap.put("pricetaxtotal", "planentity.planpricetax");
            repoColFullSrcColMap.put("pricetaxtotalloc", "planentity.planpricetaxloc");
            repoColFullSrcColMap.put("planseq", "planentity.seq");
            repoColFullSrcColMap.put("entryid", "planentity.id");
        }
        if (("ap_busbill".equals(srcEntity = blockConf.getSrcEntity()) || "ar_busbill".equals(srcEntity)) && this.reportParam.isOnlyContainsAmount()) {
            repoColFullSrcColMap.put("balance", "entry.e_amount");
            repoColFullSrcColMap.put("balanceloc", "entry.e_localamt");
            repoColFullSrcColMap.put("pricetaxtotal", "entry.e_amount");
            repoColFullSrcColMap.put("pricetaxtotalloc", "entry.e_localamt");
        }
        if ("ap_paidbill".equals(srcEntity) && "paydate".equals(standard) || "ar_receivedbill".equals(srcEntity) && "payeedate".equals(standard)) {
            repoColFullSrcColMap.put("comparedate", "bizdate");
        }
        if ("cas_paybill".equals(srcEntity)) {
            repoColFullSrcColMap.put("asstact", "itempayee");
        }
        if ("cas_recbill".equals(srcEntity)) {
            repoColFullSrcColMap.put("asstact", "itempayer");
        }
        if ("ap_paidbill".equals(srcEntity) || "ar_receivedbill".equals(srcEntity) || "cas_paybill".equals(srcEntity) || "cas_recbill".equals(srcEntity) || "ap_busbill".equals(srcEntity) || "ar_busbill".equals(srcEntity)) {
            repoColFullSrcColMap.put("entryid", "entry.id");
        }
        if (!ObjectUtils.isEmpty((Object)(entryKey = this.reportParam.getEntryName())) && ("ap_finapbill".equals(srcEntity) || "ar_finarbill".equals(srcEntity))) {
            repoColFullSrcColMap.put("entryid", entryKey + ".id");
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new HandleGroupColumns(ctx));
        transCollector.add(new AsstactTransfer());
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        if (this.reportParam.isShowByBill()) {
            GroupPlan groupPlan = ctx.getGroupPlan();
            Collection keyCols = groupPlan.getKeyCols();
            keyCols.add("entitykey");
            if (!"bizdate".equals(this.reportParam.getCompareDateField().getKey())) {
                keyCols.add("bizdate");
            }
            keyCols.add("billtype");
            keyCols.add("id");
            keyCols.add("billno");
            keyCols.add("comparedate");
            if ("planduedate".equals(this.reportParam.getCompareDateField().getValue())) {
                keyCols.add("planseq");
            }
        }
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new SortResults(ctx));
    }

    public void beforeAddSumRow(ReportDataCtx ctx) {
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> columns, ReportDataCtx ctx) {
        Optional<AbstractReportColumn> any;
        ArrayList<AbstractReportColumn> showCols = new ArrayList<AbstractReportColumn>(8);
        Pair<String, String> compareDateField = this.reportParam.getCompareDateField();
        if (this.reportParam.isShowByBill() && (any = columns.stream().filter(col -> StringUtils.equals((String)((ReportColumn)col).getFieldKey(), (String)"comparedate")).findAny()).isPresent()) {
            ReportColumn compareDateCol = (ReportColumn)any.get();
            Set<String> entities = this.reportParam.getEntities();
            String entity = entities.contains("ar_finarbill") || entities.contains("ap_finapbill") ? (this.isAr ? "ar_finarbill" : "ap_finapbill") : (entities.contains("cas_recbill") || entities.contains("cas_paybill") ? (this.isAr ? "cas_recbill" : "cas_paybill") : (this.isAr ? "ar_busbill" : "ap_busbill"));
            DynamicProperty property = EntityMetadataUtils.getProperty(entity, (String)compareDateField.getValue());
            LocaleString displayName = property.getDisplayName();
            if ("planduedate".equals(this.reportParam.getCompareDateField().getKey())) {
                displayName = new LocaleString(ResManager.loadKDString((String)"\u8ba1\u5212\u884c%s", (String)"AcctageRptHandle_3", (String)"fi-arapcommon", (Object[])new Object[]{displayName}));
            }
            compareDateCol.setCaption(displayName);
            compareDateCol.setFieldType("date");
        }
        boolean isShowLocalAmt = this.reportParam.isShowLocalAmt();
        List<AcctageGroup> groups = this.reportParam.getGroups();
        if (isShowLocalAmt) {
            ArrayList<AbstractReportColumn> locColumns = new ArrayList<AbstractReportColumn>(2);
            ArrayList<AbstractReportColumn> orignColumns = new ArrayList<AbstractReportColumn>(2);
            for (AbstractReportColumn col2 : columns) {
                ReportColumn column = (ReportColumn)col2;
                if ("amount".equals(column.getFieldType())) {
                    if (StringUtils.endsWith((String)column.getFieldKey(), (String)"loc")) {
                        locColumns.add(col2);
                        continue;
                    }
                    orignColumns.add(col2);
                    continue;
                }
                showCols.add(col2);
            }
            ReportColumnGroup columnGroup = this.createColumnGroup("orignalamtgroup", orignColumns, groups);
            showCols.add((AbstractReportColumn)columnGroup);
            ReportColumnGroup locColumnGroup = this.createColumnGroup("localamtgroup", locColumns, groups);
            showCols.add((AbstractReportColumn)locColumnGroup);
        } else {
            columns.removeIf(col -> StringUtils.endsWith((String)((ReportColumn)col).getFieldKey(), (String)"loc"));
            showCols.addAll(columns);
            for (AcctageGroup group : groups) {
                String fieldKey = AcctageHelper.getAmountFieldName(group, "balance");
                ReportColumn column = null;
                column = "balanceD".equals(fieldKey) ? ReportColumnFactory.createAmountColumn((LocaleString)new LocaleString(String.format(ResManager.loadKDString((String)"%s\u91d1\u989d", (String)"AcctageRptHandle_0", (String)"fi-arapcommon", (Object[])new Object[0]), group.getDisplayName())), (String)fieldKey, (String)"currency") : ReportColumnFactory.createAmountColumn((LocaleString)new LocaleString(group.getDisplayName()), (String)fieldKey, (String)"currency");
                column.setHyperlink(!this.reportParam.isShowByBill());
                showCols.add((AbstractReportColumn)column);
            }
        }
        return showCols;
    }

    private ReportColumnGroup createColumnGroup(String groupKey, List<AbstractReportColumn> amtColumns, List<AcctageGroup> groups) {
        String caption = ResManager.loadKDString((String)"\u539f\u5e01", (String)"AcctageRptHandle_1", (String)"fi-arapcommon", (Object[])new Object[0]);
        String balancePrefix = "balance";
        String currencyField = "currency";
        if (!"orignalamtgroup".equals(groupKey)) {
            caption = ResManager.loadKDString((String)"\u672c\u4f4d\u5e01", (String)"AcctageRptHandle_2", (String)"fi-arapcommon", (Object[])new Object[0]);
            balancePrefix = "balanceloc";
            currencyField = "basecurrency";
        }
        ReportColumnGroup columnGroup = new ReportColumnGroup();
        columnGroup.setCaption(new LocaleString(caption));
        columnGroup.setFieldKey(groupKey);
        columnGroup.getChildren().addAll(amtColumns);
        for (AcctageGroup group : groups) {
            String fieldKey = AcctageHelper.getAmountFieldName(group, balancePrefix);
            ReportColumn column = null;
            column = (balancePrefix + "D").equals(fieldKey) ? ReportColumnFactory.createAmountColumn((LocaleString)new LocaleString(String.format(ResManager.loadKDString((String)"%s\u91d1\u989d", (String)"AcctageRptHandle_0", (String)"fi-arapcommon", (Object[])new Object[0]), group.getDisplayName())), (String)fieldKey, (String)currencyField) : ReportColumnFactory.createAmountColumn((LocaleString)new LocaleString(group.getDisplayName()), (String)fieldKey, (String)currencyField);
            if ("balance".equals(balancePrefix)) {
                column.setHyperlink(!this.reportParam.isShowByBill());
            }
            columnGroup.getChildren().add(column);
        }
        return columnGroup;
    }
}

