/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctagev2.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.fi.arapcommon.report.acctage.AcctageHelper;
import kd.fi.arapcommon.report.acctagev2.AbstractAcctage;
import kd.fi.arapcommon.util.DateUtils;
import org.apache.commons.lang.StringUtils;

public class PayBillAcctageImpl
extends AbstractAcctage {
    private Set<Long> payPks;

    public PayBillAcctageImpl(ReportDataCtx ctx) {
        super(ctx);
        if (this.entityKey == null) {
            this.entityKey = "cas_paybill";
        }
    }

    @Override
    protected QFilter getSrcBlockFilter(Set<Long> reversePks) {
        String asstactType;
        this.payPks.addAll(reversePks);
        QFilter filter = new QFilter("id", "in", this.payPks);
        List<Object> orgIds = this.reportParam.getOrgIds();
        if (!orgIds.isEmpty()) {
            filter.and(new QFilter("entry.settleorg", "in", orgIds));
        }
        filter.and("entry.e_paymenttype.biztype", "=", (Object)"202");
        filter.and("entry.e_paymenttype.ispartpayment", "=", (Object)Boolean.TRUE);
        if (this.reportParam.isContainsUnaudit()) {
            filter.and("billstatus", "in", (Object)new String[]{"A", "B", "C", "D", "E", "I", "F"});
        } else {
            filter.and("billstatus", "in", (Object)new String[]{"D", "I", "F"});
        }
        List<Object> paymentTypePks = this.reportParam.getPaymentTypePks();
        if (!ObjectUtils.isEmpty(paymentTypePks)) {
            filter.and("entry.e_paymenttype", "in", paymentTypePks);
        }
        if (!ObjectUtils.isEmpty((Object)(asstactType = this.reportParam.getAsstactType()))) {
            filter.and(new QFilter("itempayeetype", "=", (Object)asstactType));
            List<Object> asstactPks = this.reportParam.getAsstactPks();
            if (!ObjectUtils.isEmpty(asstactPks)) {
                filter.and(new QFilter("itempayee", "in", asstactPks));
            }
        } else {
            filter.and(new QFilter("itempayeetype", "in", Arrays.asList("bd_supplier", "bd_customer", "bos_user")));
        }
        return filter;
    }

    @Override
    protected DataSetX getReserveDataSetX() {
        this.payPks = this.getPayPks();
        DataSetX settleDataSetX = this.getSettleDataSetX();
        DataSetX adjExchDataSetX = this.getAdjExchDataSetX();
        DataSetX groupByDataSetX = null;
        if (adjExchDataSetX == null) {
            groupByDataSetX = settleDataSetX.groupBy(new String[]{"mainbillid", "mainbillentryid"}).sum("totalsettleamt").sum("localtotalsettleamt");
        } else {
            DataSetX settleRecords = settleDataSetX.union(adjExchDataSetX);
            groupByDataSetX = settleRecords.groupBy(new String[]{"mainbillid", "mainbillentryid"}).sum("totalsettleamt").sum("localtotalsettleamt");
        }
        return groupByDataSetX;
    }

    private Set<Long> getPayPks() {
        List<QFilter> filters = this.getPayFilters();
        DynamicObjectCollection payBills = QueryServiceHelper.query((String)this.entityKey, (String)"id", (QFilter[])filters.toArray(new QFilter[0]));
        return payBills.stream().map(bill -> bill.getLong("id")).collect(Collectors.toSet());
    }

    private List<QFilter> getPayFilters() {
        QFilter asstactTypeFilter;
        String asstactType;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        Date compareDate = DateUtils.getDataFormat(this.reportParam.getQueryDate(), false);
        QFilter bizDateFilter = new QFilter("bizdate", "<=", (Object)compareDate);
        filters.add(bizDateFilter);
        QFilter bizTypeFilter = new QFilter("entry.e_paymenttype.biztype", "=", (Object)"202");
        filters.add(bizTypeFilter);
        QFilter isPartPaymentFilter = new QFilter("entry.e_paymenttype.ispartpayment", "=", (Object)Boolean.TRUE);
        filters.add(isPartPaymentFilter);
        QFilter settleAmtFilter = new QFilter("entry.e_unsettledamt", "<>", (Object)0);
        filters.add(settleAmtFilter);
        List<Object> orgIds = this.reportParam.getOrgIds();
        if (!orgIds.isEmpty()) {
            QFilter orgFilter = new QFilter("entry.settleorg", "in", orgIds);
            filters.add(orgFilter);
        }
        if (!ObjectUtils.isEmpty((Object)(asstactType = this.reportParam.getAsstactType()))) {
            asstactTypeFilter = new QFilter("itempayeetype", "=", (Object)asstactType);
            List<Object> asstactPks = this.reportParam.getAsstactPks();
            if (!ObjectUtils.isEmpty(asstactPks)) {
                QFilter asstactFilter = new QFilter("itempayee", "in", asstactPks);
                filters.add(asstactFilter);
            }
        } else {
            asstactTypeFilter = new QFilter("itempayeetype", "in", Arrays.asList("bd_supplier", "bd_customer", "bos_user"));
        }
        filters.add(asstactTypeFilter);
        return filters;
    }

    private DataSetX getSettleDataSetX() {
        List<Object> asstacts;
        Date compareDate = DateUtils.getDataFormat(this.reportParam.getQueryDate(), false);
        List<QFilter> filters = this.getFilters(compareDate);
        ArrayList<QFilter> mainFilters = new ArrayList<QFilter>(filters);
        String asstactType = this.reportParam.getAsstactType();
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            mainFilters.add(new QFilter("mainasstacttype", "=", (Object)asstactType));
        }
        if (!ObjectUtils.isEmpty(asstacts = this.reportParam.getAsstactPks())) {
            mainFilters.add(new QFilter("mainasstactid", "in", asstacts));
        }
        mainFilters.add(new QFilter("mainbizdate", "<=", (Object)compareDate));
        mainFilters.add(new QFilter("billentity", "=", (Object)"cas_paybill"));
        List<Object> paymentTypePks = this.reportParam.getPaymentTypePks();
        if (!paymentTypePks.isEmpty()) {
            mainFilters.add(new QFilter("paypropertytype", "=", (Object)this.reportParam.getPaymentType()));
            mainFilters.add(new QFilter("paypropertyfield", "in", paymentTypePks));
        }
        JobSession session = this.ctx.getCurrentJob();
        OrmInput mainInput = new OrmInput("mainSettle", "ap_settlerecord", "mainbillid,mainbillentryid,totalsettleamt,localtotalsettleamt", mainFilters.toArray(new QFilter[0]));
        DataSetX mainSettle = session.fromInput((Input)mainInput);
        ArrayList<QFilter> asstFilters = new ArrayList<QFilter>(filters);
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            asstFilters.add(new QFilter("entry.asstacttype", "=", (Object)asstactType));
        }
        if (!ObjectUtils.isEmpty(asstacts)) {
            asstFilters.add(new QFilter("entry.asstactid", "in", asstacts));
        }
        asstFilters.add(new QFilter("entry.billdate", "<=", (Object)compareDate));
        asstFilters.add(new QFilter("entry.e_billentity", "=", (Object)"cas_paybill"));
        if (!paymentTypePks.isEmpty()) {
            asstFilters.add(new QFilter("entry.e_paypropertytype", "=", (Object)this.reportParam.getPaymentType()));
            asstFilters.add(new QFilter("entry.e_paypropertyfield", "in", paymentTypePks));
        }
        OrmInput asstInput = new OrmInput("asstSettle", "ar_settlerecord", "entry.billid as mainbillid,entry.billentryid as mainbillentryid,entry.settleamt as totalsettleamt,entry.localsettleamt as localtotalsettleamt", asstFilters.toArray(new QFilter[0]));
        DataSetX asstSettle = session.fromInput((Input)asstInput);
        return mainSettle.union(asstSettle);
    }

    private List<QFilter> getFilters(Date compareDate) {
        List<Object> currencyIds;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        filters.add(new QFilter("settledate", ">", (Object)compareDate));
        List<Object> orgIds = this.reportParam.getOrgIds();
        if (!orgIds.isEmpty()) {
            filters.add(new QFilter("org", "in", orgIds));
        }
        if (!ObjectUtils.isEmpty(currencyIds = this.reportParam.getCurrencyIds())) {
            filters.add(new QFilter("maincurrency", "in", currencyIds));
        }
        return filters;
    }

    private DataSetX getAdjExchDataSetX() {
        DataSetX adjExchDataSetX = null;
        QFilter qFilter = this.getAdjExchFilter();
        if (qFilter != null) {
            Map<Long, List<Long>> map = AcctageHelper.getPreviousPeriodEndDate(this.entityKey, this.reportParam.getOrgIds(), this.reportParam.getQueryDate());
            for (Map.Entry<Long, List<Long>> entry : map.entrySet()) {
                Date bizDate = new Date(entry.getKey());
                List<Long> orgIds = entry.getValue();
                qFilter.and("org", "in", orgIds);
                qFilter.and("bizdate", "=", (Object)bizDate);
                boolean isAr = StringUtils.contains((String)this.entityKey, (String)"ar_");
                String adjEntityKey = isAr ? "ar_adjustexchbill" : "ap_adjexchbill";
                OrmInput adjInput = new OrmInput("adjExchBill", adjEntityKey, "entry.e_srcbillid as mainbillid,entry.e_srcentryid as mainbillentryid, entry.e_curgainloss as localtotalsettleamt", new QFilter[]{qFilter});
                DataSetX eachAdjExchDataSetX = this.ctx.getCurrentJob().fromInput((Input)adjInput);
                Field[] fields = new Field[]{new Field("totalsettleamt", (DataType)DataType.BigDecimalType)};
                Object[] vals = new Object[]{BigDecimal.ZERO};
                eachAdjExchDataSetX = eachAdjExchDataSetX.addFields(fields, vals);
                eachAdjExchDataSetX = eachAdjExchDataSetX.select(new String[]{"mainbillid", "mainbillentryid", "totalsettleamt", "localtotalsettleamt"});
                if (adjExchDataSetX == null) {
                    adjExchDataSetX = eachAdjExchDataSetX;
                    continue;
                }
                adjExchDataSetX = adjExchDataSetX.union(eachAdjExchDataSetX);
            }
        }
        return adjExchDataSetX;
    }
}

