/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctagev2.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.fi.arapcommon.report.acctage.AcctageHelper;
import kd.fi.arapcommon.report.acctagev2.AbstractAcctage;
import kd.fi.arapcommon.util.DateUtils;
import org.apache.commons.lang.StringUtils;

public class ReceivedBillAcctageImpl
extends AbstractAcctage {
    private Set<Long> receivedPks;

    public ReceivedBillAcctageImpl(ReportDataCtx ctx) {
        super(ctx);
        if (this.entityKey == null) {
            this.entityKey = "ar_receivedbill";
        }
    }

    @Override
    protected QFilter getSrcBlockFilter(Set<Long> reversePks) {
        String asstactType;
        this.receivedPks.addAll(reversePks);
        QFilter filter = new QFilter("id", "in", this.receivedPks);
        List<Object> orgIds = this.reportParam.getOrgIds();
        if (!orgIds.isEmpty()) {
            filter.and(new QFilter("org", "in", orgIds));
        }
        filter.and("billstatus", "in", (Object)new String[]{"C"});
        List<Object> paymentTypePks = this.reportParam.getPaymentTypePks();
        if (!ObjectUtils.isEmpty(paymentTypePks)) {
            filter.and("rectype", "in", paymentTypePks);
        }
        if (!ObjectUtils.isEmpty((Object)(asstactType = this.reportParam.getAsstactType()))) {
            filter.and("asstacttype", "=", (Object)asstactType);
            List<Object> asstactPks = this.reportParam.getAsstactPks();
            if (!ObjectUtils.isEmpty(asstactPks)) {
                filter.and("asstact", "in", asstactPks);
            }
        } else {
            filter.and("asstacttype", "in", Arrays.asList("bd_supplier", "bd_customer", "bos_user"));
        }
        return filter;
    }

    @Override
    protected DataSetX getReserveDataSetX() {
        this.receivedPks = this.getReceivedPks();
        DataSetX settleDataSetX = this.getSettleDataSetX();
        DataSetX adjExchDataSetX = this.getAdjExchDataSetX();
        DataSetX groupByDataSetX = null;
        if (adjExchDataSetX == null) {
            groupByDataSetX = settleDataSetX.groupBy(new String[]{"mainbillid", "mainbillentryid"}).sum("totalsettleamt").sum("localtotalsettleamt");
        } else {
            DataSetX settleRecords = settleDataSetX.union(adjExchDataSetX);
            groupByDataSetX = settleRecords.groupBy(new String[]{"mainbillid", "mainbillentryid"}).sum("totalsettleamt").sum("localtotalsettleamt");
        }
        return groupByDataSetX;
    }

    private Set<Long> getReceivedPks() {
        List<QFilter> filters = this.getReceivedFilters();
        DynamicObjectCollection receivedBills = QueryServiceHelper.query((String)this.entityKey, (String)"id", (QFilter[])filters.toArray(new QFilter[0]));
        return receivedBills.stream().map(bill -> bill.getLong("id")).collect(Collectors.toSet());
    }

    private List<QFilter> getReceivedFilters() {
        QFilter asstactTypeFilter;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        Date compareDate = DateUtils.getDataFormat(this.reportParam.getQueryDate(), false);
        QFilter bizDateFilter = new QFilter("bizdate", "<=", (Object)compareDate);
        filters.add(bizDateFilter);
        QFilter bizTypeFilter = new QFilter("rectype.biztype", "=", (Object)"101");
        filters.add(bizTypeFilter);
        QFilter isPartPaymentFilter = new QFilter("rectype.ispartreceivable", "=", (Object)Boolean.TRUE);
        filters.add(isPartPaymentFilter);
        QFilter settleAmtFilter = new QFilter("entry.e_unsettledamt", "<>", (Object)0);
        filters.add(settleAmtFilter);
        String asstactType = this.reportParam.getAsstactType();
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            asstactTypeFilter = new QFilter("asstacttype", "=", (Object)asstactType);
            List<Object> asstactPks = this.reportParam.getAsstactPks();
            if (!ObjectUtils.isEmpty(asstactPks)) {
                QFilter asstactFilter = new QFilter("asstact", "in", asstactPks);
                filters.add(asstactFilter);
            }
        } else {
            asstactTypeFilter = new QFilter("asstacttype", "in", Arrays.asList("bd_supplier", "bd_customer", "bos_user"));
        }
        filters.add(asstactTypeFilter);
        return filters;
    }

    private DataSetX getSettleDataSetX() {
        List<Object> asstacts;
        Date compareDate = DateUtils.getDataFormat(this.reportParam.getQueryDate(), false);
        List<QFilter> filters = this.getFilters(compareDate);
        ArrayList<QFilter> mainFilters = new ArrayList<QFilter>(filters);
        String asstactType = this.reportParam.getAsstactType();
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            mainFilters.add(new QFilter("mainasstacttype", "=", (Object)asstactType));
        }
        if (!ObjectUtils.isEmpty(asstacts = this.reportParam.getAsstactPks())) {
            mainFilters.add(new QFilter("mainasstactid", "in", asstacts));
        }
        mainFilters.add(new QFilter("mainbizdate", "<=", (Object)compareDate));
        mainFilters.add(new QFilter("billentity", "=", (Object)"ar_receivedbill"));
        List<Object> paymentTypePks = this.reportParam.getPaymentTypePks();
        if (!paymentTypePks.isEmpty()) {
            mainFilters.add(new QFilter("paypropertytype", "=", (Object)this.reportParam.getPaymentType()));
            mainFilters.add(new QFilter("paypropertyfield", "in", paymentTypePks));
        }
        JobSession session = this.ctx.getCurrentJob();
        OrmInput mainInput = new OrmInput("mainSettle", "ar_settlerecord", "mainbillid,mainbillentryid,totalsettleamt,localtotalsettleamt", mainFilters.toArray(new QFilter[0]));
        DataSetX mainSettle = session.fromInput((Input)mainInput);
        ArrayList<QFilter> asstFilters = new ArrayList<QFilter>(filters);
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            asstFilters.add(new QFilter("entry.asstacttype", "=", (Object)asstactType));
        }
        if (!ObjectUtils.isEmpty(asstacts)) {
            asstFilters.add(new QFilter("entry.asstactid", "in", asstacts));
        }
        asstFilters.add(new QFilter("entry.billdate", "<=", (Object)compareDate));
        asstFilters.add(new QFilter("entry.e_billentity", "=", (Object)"ar_receivedbill"));
        if (!paymentTypePks.isEmpty()) {
            asstFilters.add(new QFilter("entry.e_paypropertytype", "=", (Object)this.reportParam.getPaymentType()));
            asstFilters.add(new QFilter("entry.e_paypropertyfield", "in", paymentTypePks));
        }
        OrmInput asstInput = new OrmInput("asstSettle", "ap_settlerecord", "entry.billid as mainbillid,entry.billentryid as mainbillentryid,entry.settleamt as totalsettleamt,entry.localsettleamt as localtotalsettleamt", asstFilters.toArray(new QFilter[0]));
        DataSetX asstSettle = session.fromInput((Input)asstInput);
        return mainSettle.union(asstSettle);
    }

    private List<QFilter> getFilters(Date compareDate) {
        List<Object> currencyIds;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        filters.add(new QFilter("settledate", ">", (Object)compareDate));
        List<Object> orgIds = this.reportParam.getOrgIds();
        if (!orgIds.isEmpty()) {
            filters.add(new QFilter("org", "in", orgIds));
        }
        if (!ObjectUtils.isEmpty(currencyIds = this.reportParam.getCurrencyIds())) {
            filters.add(new QFilter("maincurrency", "in", currencyIds));
        }
        return filters;
    }

    private DataSetX getAdjExchDataSetX() {
        DataSetX adjExchDataSetX = null;
        QFilter qFilter = this.getAdjExchFilter();
        if (qFilter != null) {
            Map<Long, List<Long>> map = AcctageHelper.getPreviousPeriodEndDate(this.entityKey, this.reportParam.getOrgIds(), this.reportParam.getQueryDate());
            for (Map.Entry<Long, List<Long>> entry : map.entrySet()) {
                Date bizDate = new Date(entry.getKey());
                List<Long> orgIds = entry.getValue();
                qFilter.and("org", "in", orgIds);
                qFilter.and("bizdate", "=", (Object)bizDate);
                boolean isAr = StringUtils.contains((String)this.entityKey, (String)"ar_");
                String adjEntityKey = isAr ? "ar_adjustexchbill" : "ap_adjexchbill";
                OrmInput adjInput = new OrmInput("adjExchBill", adjEntityKey, "entry.e_srcbillid as mainbillid,entry.e_srcentryid as mainbillentryid, entry.e_curgainloss as localtotalsettleamt", new QFilter[]{qFilter});
                DataSetX eachAdjExchDataSetX = this.ctx.getCurrentJob().fromInput((Input)adjInput);
                Field[] fields = new Field[]{new Field("totalsettleamt", (DataType)DataType.BigDecimalType)};
                Object[] vals = new Object[]{BigDecimal.ZERO};
                eachAdjExchDataSetX = eachAdjExchDataSetX.addFields(fields, vals);
                eachAdjExchDataSetX = eachAdjExchDataSetX.select(new String[]{"mainbillid", "mainbillentryid", "totalsettleamt", "localtotalsettleamt"});
                if (adjExchDataSetX == null) {
                    adjExchDataSetX = eachAdjExchDataSetX;
                    continue;
                }
                adjExchDataSetX = adjExchDataSetX.union(eachAdjExchDataSetX);
            }
        }
        return adjExchDataSetX;
    }
}

