/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctagev2.transform;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.MapFunction;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.arapcommon.report.acctage.AcctageGroup;
import kd.fi.arapcommon.report.acctage.AcctageHelper;
import kd.fi.arapcommon.report.acctagev2.AcctageParam;
import kd.fi.arapcommon.report.acctagev2.transform.func.BalanceFieldFilterFunc;
import kd.fi.arapcommon.report.acctagev2.transform.func.GroupBalColMapFunc;
import org.apache.commons.lang.StringUtils;

public class HandleGroupColumns
implements IDataXTransform {
    private ReportDataCtx ctx;
    private Set<String> showQtyCols;
    private AcctageParam reportParam;

    public HandleGroupColumns(ReportDataCtx ctx) {
        this.ctx = ctx;
        this.showQtyCols = ctx.getShowQtyCols();
        this.reportParam = (AcctageParam)ctx.getParam(AcctageParam.class.getName());
    }

    public DataSetX doTransform(DataSetX srcData) {
        srcData = this.fillingQtyCols(srcData);
        srcData = srcData.map((MapFunction)new GroupBalColMapFunc(srcData.getRowMeta(), this.ctx));
        if (this.reportParam.isHyperLinkClick()) {
            HashMap<String, Integer> balanceIdx = new HashMap<String, Integer>(1);
            for (String qtyCol : this.showQtyCols) {
                for (AcctageGroup group : this.reportParam.getGroups()) {
                    if (!StringUtils.contains((String)qtyCol, (String)"balance")) continue;
                    String balanceField = AcctageHelper.getAmountFieldName(group, qtyCol);
                    balanceIdx.put(balanceField, srcData.getRowMeta().getFieldIndex(balanceField));
                }
            }
            srcData = srcData.filter((FilterFunction)new BalanceFieldFilterFunc(balanceIdx));
        }
        return srcData;
    }

    private DataSetX fillingQtyCols(DataSetX srcData) {
        ArrayList<Field> fields = new ArrayList<Field>(8);
        ArrayList<BigDecimal> vals = new ArrayList<BigDecimal>(8);
        for (String qtyCol : this.showQtyCols) {
            if (!StringUtils.contains((String)qtyCol, (String)"balance")) continue;
            for (AcctageGroup group : this.reportParam.getGroups()) {
                fields.add(new Field(AcctageHelper.getAmountFieldName(group, qtyCol), (DataType)DataType.BigDecimalType));
                vals.add(BigDecimal.ZERO);
            }
        }
        return srcData.addFields(fields.toArray(new Field[0]), vals.toArray());
    }
}

