/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctagev2.transform.func;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.util.TransformUtil;

public class AsstactTranseferReduceFunc
extends GroupReduceFunction {
    private RowMeta rowMeta;
    private Map<String, Integer> indexs;

    public AsstactTranseferReduceFunc(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.indexs = this.buildIndexs();
    }

    private Map<String, Integer> buildIndexs() {
        ArrayList<String> columns = new ArrayList<String>(2);
        List<String> fieldNames = Arrays.asList(this.rowMeta.getFieldNames());
        if (fieldNames.contains("asstact")) {
            columns.add("asstact");
        }
        if (fieldNames.contains("asstacttype")) {
            columns.add("asstacttype");
        }
        return TransformUtil.buildIndexs((RowMeta)this.rowMeta, columns);
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        HashMap<String, Set> asstactIdMap = new HashMap<String, Set>(3);
        ArrayList<RowX> rows = new ArrayList<RowX>(100);
        for (RowX row : iterable) {
            rows.add(row.copy());
        }
        for (RowX row : rows) {
            Integer asstactIndex = this.indexs.get("asstact");
            if (asstactIndex == null) continue;
            Integer asstactTypeIndex = this.indexs.get("asstacttype");
            String asstactType = asstactTypeIndex == null ? "all" : row.getString(asstactTypeIndex.intValue());
            Set asstactIds = asstactIdMap.getOrDefault(asstactType, new HashSet(1));
            Long asstactId = row.getLong(asstactIndex.intValue());
            asstactIds.add(asstactId);
            asstactIdMap.put(asstactType, asstactIds);
        }
        HashMap<Long, Long> asstactId2MasterIdMap = new HashMap<Long, Long>(2);
        for (Map.Entry asstactMap : asstactIdMap.entrySet()) {
            String asstactType = (String)asstactMap.getKey();
            Set asstactIds = (Set)asstactMap.getValue();
            if ("bd_supplier".equals(asstactType) || "bd_customer".equals(asstactType)) {
                DynamicObjectCollection asstacts = QueryServiceHelper.query((String)asstactType, (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)asstactIds)});
                for (DynamicObject asstact : asstacts) {
                    asstactId2MasterIdMap.put(asstact.getLong("id"), asstact.getLong("masterid"));
                }
                continue;
            }
            if (!"all".equals(asstactType)) continue;
            DynamicObjectCollection suppliers = QueryServiceHelper.query((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)asstactIds)});
            for (DynamicObject supplier : suppliers) {
                asstactId2MasterIdMap.put(supplier.getLong("id"), supplier.getLong("masterid"));
            }
            DynamicObjectCollection customers = QueryServiceHelper.query((String)"bd_customer", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)asstactIds)});
            for (DynamicObject customer : customers) {
                asstactId2MasterIdMap.put(customer.getLong("id"), customer.getLong("masterid"));
            }
        }
        for (RowX row : rows) {
            Long asstactId;
            Long asstactMasterId;
            Integer asstactIndex = this.indexs.get("asstact");
            if (asstactIndex != null && (asstactMasterId = (Long)asstactId2MasterIdMap.get(asstactId = row.getLong(asstactIndex.intValue()))) != null) {
                row.set(asstactIndex.intValue(), (Object)asstactMasterId);
            }
            collector.collect(row);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

