/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctagev2.transform.func;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.JoinFunction;
import kd.bos.algox.RowX;

public class BusReverseJoinFunc
extends JoinFunction {
    private static final long serialVersionUID = 6021277732721443976L;
    private boolean isShowLocalAmt;
    private RowMeta resultRowMeta;
    private Map<String, Integer> leftIdx;
    private Map<String, Integer> rightIdx;

    public BusReverseJoinFunc(RowMeta left, RowMeta right, boolean isShowLocalAmt) {
        this.isShowLocalAmt = isShowLocalAmt;
        this.resultRowMeta = new RowMeta(left.getFields());
        this.leftIdx = new HashMap<String, Integer>(2);
        this.leftIdx.put("balance", left.getFieldIndex("balance"));
        if (isShowLocalAmt) {
            this.leftIdx.put("balanceloc", left.getFieldIndex("balanceloc"));
        }
        this.rightIdx = new HashMap<String, Integer>(2);
        this.rightIdx.put("e_pricetaxtotal", right.getFieldIndex("e_pricetaxtotal"));
        if (isShowLocalAmt) {
            this.rightIdx.put("e_pricetaxtotalbase", right.getFieldIndex("e_pricetaxtotalbase"));
        }
    }

    public RowMeta getResultRowMeta() {
        return this.resultRowMeta;
    }

    public RowX join(RowX row1, RowX row2) {
        BigDecimal pricetaxtotal;
        BigDecimal balanceResult = null;
        BigDecimal balance = row1.getBigDecimal(this.leftIdx.get("balance").intValue());
        balanceResult = row2 != null ? ((pricetaxtotal = row2.getBigDecimal(this.rightIdx.get("e_pricetaxtotal").intValue())) == null ? balance : balance.add(pricetaxtotal)) : balance;
        row1.set(this.leftIdx.get("balance").intValue(), (Object)balanceResult);
        if (this.isShowLocalAmt) {
            BigDecimal pricetaxtotalbase;
            BigDecimal balanceLocResult = null;
            BigDecimal balanceloc = row1.getBigDecimal(this.leftIdx.get("balanceloc").intValue());
            balanceLocResult = row2 != null ? ((pricetaxtotalbase = row2.getBigDecimal(this.rightIdx.get("e_pricetaxtotalbase").intValue())) == null ? balanceloc : balanceloc.add(pricetaxtotalbase)) : balanceloc;
            row1.set(this.leftIdx.get("balanceloc").intValue(), (Object)balanceLocResult);
        }
        return row1;
    }
}

