/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctagev2.transform.func;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.JoinFunction;
import kd.bos.algox.RowX;

public class FinReverseJoinFunc
extends JoinFunction {
    private static final long serialVersionUID = 6003468680870808636L;
    private boolean isShowLocalAmt;
    private RowMeta resultRowMeta;
    private Map<String, Integer> leftIdx;
    private Map<String, Integer> rightIdx;

    public FinReverseJoinFunc(RowMeta left, RowMeta right, boolean isShowLocalAmt) {
        this.isShowLocalAmt = isShowLocalAmt;
        this.resultRowMeta = new RowMeta(left.getFields());
        this.leftIdx = new HashMap<String, Integer>(2);
        this.leftIdx.put("balance", left.getFieldIndex("balance"));
        if (isShowLocalAmt) {
            this.leftIdx.put("balanceloc", left.getFieldIndex("balanceloc"));
        }
        this.rightIdx = new HashMap<String, Integer>(2);
        this.rightIdx.put("totalsettleamt", right.getFieldIndex("totalsettleamt"));
        if (isShowLocalAmt) {
            this.rightIdx.put("localtotalsettleamt", right.getFieldIndex("localtotalsettleamt"));
        }
    }

    public RowMeta getResultRowMeta() {
        return this.resultRowMeta;
    }

    public RowX join(RowX row1, RowX row2) {
        BigDecimal totalsettleamt;
        BigDecimal balanceResult = null;
        BigDecimal balance = row1.getBigDecimal(this.leftIdx.get("balance").intValue());
        balanceResult = row2 != null ? ((totalsettleamt = row2.getBigDecimal(this.rightIdx.get("totalsettleamt").intValue())) == null ? balance : balance.add(totalsettleamt)) : balance;
        row1.set(this.leftIdx.get("balance").intValue(), (Object)balanceResult);
        if (this.isShowLocalAmt) {
            BigDecimal localtotalsettleamt;
            BigDecimal balanceLocResult = null;
            BigDecimal balanceloc = row1.getBigDecimal(this.leftIdx.get("balanceloc").intValue());
            balanceLocResult = row2 != null ? ((localtotalsettleamt = row2.getBigDecimal(this.rightIdx.get("localtotalsettleamt").intValue())) == null ? balanceloc : balanceloc.add(localtotalsettleamt)) : balanceloc;
            row1.set(this.leftIdx.get("balanceloc").intValue(), (Object)balanceLocResult);
        }
        return row1;
    }
}

