/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctagev2.transform.func;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.util.TransformUtil;
import kd.fi.arapcommon.report.acctage.AcctageGroup;
import kd.fi.arapcommon.report.acctage.AcctageHelper;
import kd.fi.arapcommon.report.acctagev2.AcctageParam;
import org.apache.commons.lang.StringUtils;

public class GroupBalColMapFunc
extends MapFunction {
    private static final long serialVersionUID = 6680303490668190214L;
    private RowMeta rowMeta;
    private Map<String, Integer> indexs;
    private Set<String> showQtyCols;
    private List<AcctageGroup> groups;
    private Date queryDate;

    public GroupBalColMapFunc(RowMeta rowMeta, ReportDataCtx ctx) {
        this.rowMeta = rowMeta;
        this.showQtyCols = ctx.getShowQtyCols();
        AcctageParam reportParam = (AcctageParam)ctx.getParam(AcctageParam.class.getName());
        this.groups = reportParam.getGroups();
        this.queryDate = reportParam.getQueryDate();
        this.buildIndexs();
    }

    private void buildIndexs() {
        this.indexs = new HashMap<String, Integer>(8);
        ArrayList<String> cols = new ArrayList<String>(8);
        cols.add("comparedate");
        cols.addAll(this.showQtyCols);
        cols.addAll(AcctageHelper.getBalanceGroupCols(this.showQtyCols, this.groups));
        this.indexs = TransformUtil.buildIndexs((RowMeta)this.rowMeta, cols);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX row) {
        Date compareDate = row.getDate(this.indexs.get("comparedate").intValue());
        block0: for (String sumNumCol : this.showQtyCols) {
            if (!StringUtils.contains((String)sumNumCol, (String)"balance")) continue;
            BigDecimal amt = row.getBigDecimal(this.indexs.get(sumNumCol).intValue());
            int j = 0;
            for (AcctageGroup group : this.groups) {
                if (!AcctageHelper.match(group, this.queryDate, compareDate)) continue;
                String balanceField = AcctageHelper.getAmountFieldName(group, sumNumCol);
                int index = this.indexs.get(balanceField);
                row.set(index, (Object)amt);
                if (j != 0) continue block0;
                ++j;
            }
        }
        return row;
    }
}

