/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.bizpartner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.BizPartnerHelper;

public class AsstactSumRpt4Upgrade
extends AbstractReportFormPlugin {
    private static final Log logger = LogFactory.getLog(AsstactSumRpt4Upgrade.class);

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        AbstractOperate op = (AbstractOperate)e.getSource();
        String key = op.getOperateKey();
        if ("upgrade".equals(key)) {
            this.upgrade();
        }
    }

    private void upgrade() {
        List<Long> cusAndSupPks = BizPartnerHelper.getCusAndSupPksByPartners(null);
        Map<String, List<Map<String, Long>>> cusSupMap = this.getCusSupMap(cusAndSupPks);
        this.doUpgrade(cusSupMap);
    }

    private void doUpgrade(Map<String, List<Map<String, Long>>> cusSupMap) {
        List<Map<String, Long>> customerList;
        int customerCnt;
        List<Map<String, Long>> supplierList = cusSupMap.get("bd_supplier");
        int supplierCnt = this.upgradeUseOrg("bd_supplier", supplierList);
        int count = supplierCnt + (customerCnt = this.upgradeUseOrg("bd_customer", customerList = cusSupMap.get("bd_customer")));
        if (count != 0) {
            String message = String.format(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u6210\u529f\uff0c\u5171\u5347\u7ea7 %s \u6761\u3002", (String)"AsstactSumRpt4Upgrade_0", (String)"fi-arapcommon", (Object[])new Object[0]), count);
            this.getView().showSuccessNotification(message);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5347\u7ea7\u7684\u6570\u636e\u3002", (String)"AsstactSumRpt4Upgrade_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    private int upgradeUseOrg(String entityKey, List<Map<String, Long>> asstactList) {
        int insertCnt = 0;
        if (asstactList != null && asstactList.size() > 0) {
            Set<Long> asstactPks = asstactList.stream().map(m -> (Long)m.get("asstact")).collect(Collectors.toSet());
            logger.info("--- asstactPks =  " + asstactPks);
            String tableName = "T_BD_Supplier_U";
            if ("bd_customer".equals(entityKey)) {
                tableName = "T_BD_Customer_U";
            }
            Map<Long, List<Long>> supUseMap = this.getUseOrgs(tableName, asstactPks);
            ArrayList<Object[]> params = new ArrayList<Object[]>(8);
            ArrayList<String> uniqueParams = new ArrayList<String>(8);
            for (Map<String, Long> map : asstactList) {
                Object[] param;
                Long asstactPk = map.get("asstact");
                Long orgPk = map.get("org");
                List<Long> orgList = supUseMap.get(asstactPk);
                String uniqueKey = asstactPk + "_" + orgPk;
                if (orgList == null) {
                    if (uniqueParams.contains(uniqueKey)) continue;
                    uniqueParams.add(uniqueKey);
                    param = new Object[]{asstactPk, orgPk};
                    params.add(param);
                    continue;
                }
                if (orgList.contains(orgPk) || uniqueParams.contains(uniqueKey)) continue;
                uniqueParams.add(uniqueKey);
                param = new Object[]{asstactPk, orgPk};
                params.add(param);
            }
            if (!params.isEmpty()) {
                insertCnt = params.size();
                DB.executeBatch((DBRoute)DBRouteConst.BASEDATA, (String)("INSERT INTO " + tableName + "(fdataid, fcreateorgid, fuseorgid) VALUES (?, NULL, ?)"), params);
                logger.info("--- \u5171insert " + tableName + ", insertCnt = " + insertCnt);
            }
        }
        return insertCnt;
    }

    private Map<Long, List<Long>> getUseOrgs(String tableName, Set<Long> asstactList) {
        HashMap<Long, List<Long>> dataMap = new HashMap<Long, List<Long>>(8);
        String sql = "Select FDataId, FUseOrgId From " + tableName + " Where FDataId IN (" + StringUtils.join((Object[])asstactList.toArray(), (char)',') + ")";
        try (DataSet ds = DB.queryDataSet((String)"getUseOrgs", (DBRoute)DBRouteConst.BASEDATA, (String)sql);){
            for (Row data : ds) {
                Long key = data.getLong("FDataId");
                ArrayList<Long> list = (ArrayList<Long>)dataMap.get(key);
                if (list == null) {
                    list = new ArrayList<Long>();
                }
                list.add(data.getLong("FUseOrgId"));
                dataMap.put(key, list);
            }
        }
        return dataMap;
    }

    private Map<String, List<Map<String, Long>>> getCusSupMap(List<Long> cusAndSupPks) {
        List<Map<String, Long>> customerList;
        Map<String, List<Map<String, Long>>> arMap;
        HashMap<String, List<Map<String, Long>>> cusSupMap = new HashMap<String, List<Map<String, Long>>>(2);
        Map<String, List<Map<String, Long>>> apMap = this.getCusSupMap("ap_journal", cusAndSupPks);
        List<Map<String, Long>> supplierList = this.merge(apMap, arMap = this.getCusSupMap("ar_journal", cusAndSupPks), "bd_supplier");
        if (supplierList != null) {
            cusSupMap.put("bd_supplier", supplierList);
        }
        if ((customerList = this.merge(apMap, arMap, "bd_customer")) != null) {
            cusSupMap.put("bd_customer", customerList);
        }
        return cusSupMap;
    }

    private List<Map<String, Long>> merge(Map<String, List<Map<String, Long>>> apMap, Map<String, List<Map<String, Long>>> arMap, String asstActType) {
        List<Map<String, Long>> asstactList = null;
        List<Map<String, Long>> apList = apMap.get(asstActType);
        List<Map<String, Long>> arList = arMap.get(asstActType);
        if (apList != null && arList == null) {
            asstactList = apList;
        } else if (apList == null && arList != null) {
            asstactList = arList;
        } else if (apList != null && arList != null) {
            apList.addAll(arList);
            asstactList = apList;
        }
        return asstactList;
    }

    private Map<String, List<Map<String, Long>>> getCusSupMap(String journalEntity, List<Long> cusAndSupPks) {
        HashMap<String, List<Map<String, Long>>> cusSupMap = new HashMap<String, List<Map<String, Long>>>(2);
        QFilter qFilter = new QFilter("asstact", "in", cusAndSupPks);
        qFilter.and(new QFilter("asstacttype", "in", Arrays.asList("bd_supplier", "bd_customer")));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"asstact.getJournals", (String)journalEntity, (String)"org, asstacttype, asstact", (QFilter[])new QFilter[]{qFilter}, null).groupBy(new String[]{"org", "asstacttype", "asstact"}).finish();){
            for (Row data : ds) {
                String key = data.getString("asstacttype");
                ArrayList list = (ArrayList)cusSupMap.get(key);
                if (list == null) {
                    list = new ArrayList();
                }
                HashMap<String, Long> m = new HashMap<String, Long>(2);
                m.put("org", data.getLong("org"));
                m.put("asstact", data.getLong("asstact"));
                list.add(m);
                cusSupMap.put(key, list);
            }
        }
        return cusSupMap;
    }
}

