/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.detailv2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataHandle;
import kd.fi.arapcommon.form.AbstractARAPReportFormPlugin;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.report.BizTypeDisplayNameProvider;
import kd.fi.arapcommon.report.ReportHelper;
import kd.fi.arapcommon.service.CloseRecordService;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.SumRptParam;
import org.apache.commons.lang.StringUtils;

public class DetailForm
extends AbstractARAPReportFormPlugin
implements HyperLinkClickListener {
    private static String[] asstactPropKeys = new String[]{"bd_supplier", "bd_customer", "bos_user"};
    private List<Long> orgIds = null;
    private ReportConf confCache;

    @Override
    protected List<Long> getOrgIds() {
        if (this.orgIds == null) {
            List<DynamicObject> orgs = OrgHelper.getAuthorizedInitializedOrgs(this.getView().getEntityId(), "47150e89000000ac", !this.isAp());
            this.orgIds = orgs.stream().map(org -> org.getLong("id")).distinct().collect(Collectors.toList());
        }
        return this.orgIds;
    }

    private boolean isAp() {
        return StringUtils.startsWith((String)this.getView().getEntityId(), (String)"ap_");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        if ("showkeycols".equals(key)) {
            List keyCols = Stream.of(((String)value).split(",")).collect(Collectors.toList());
            if (keyCols.contains("asstact") && !keyCols.contains("asstacttype")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7edf\u8ba1\u7ef4\u5ea6\u201d\u4e2d\u9009\u62e9\u201c\u5f80\u6765\u6237\u201d\u65f6\uff0c\u201c\u5f80\u6765\u7c7b\u578b\u201d\u5fc5\u9009\u3002", (String)"SumandDetailForm_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            } else if (!keyCols.contains("currency")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7edf\u8ba1\u7ef4\u5ea6\u201d\u4e2d\u201c\u5e01\u79cd\u201d\u5fc5\u9009\u3002", (String)"SumandDetailForm_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            } else if (!((Boolean)this.getModel().getValue("showmaincurrency")).booleanValue() && keyCols.contains("basecurrency")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u663e\u793a\u6298\u672c\u5e01\u65f6\u201c\u7edf\u8ba1\u7ef4\u5ea6\u201d\u4e2d\u201c\u672c\u4f4d\u5e01\u201d\u4e0d\u5141\u8bb8\u9009\u62e9\u3002", (String)"SumandDetailForm_2", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter == null) {
            return;
        }
        Map customParams = formShowParameter.getCustomParams();
        if (customParams == null) {
            return;
        }
        Boolean isopenbyhyperlink = (Boolean)customParams.get("isopenbyhyperlink");
        if (isopenbyhyperlink == null || !isopenbyhyperlink.booleanValue()) {
            return;
        }
        IDataModel parentModel = this.getView().getParentView().getModel();
        MainEntityType parentFormEntityType = MetadataServiceHelper.getDataEntityType((String)this.getView().getParentView().getEntityId());
        DataEntityPropertyCollection parentFormProps = parentFormEntityType.getProperties();
        Map row = (Map)customParams.get("row");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.getView().getEntityId());
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        List<String> filterFieldKeys = this.getFilterFieldKeys();
        Iterator<String> iterator = filterFieldKeys.iterator();
        while (iterator.hasNext()) {
            IDataEntityProperty prop;
            String string;
            String propKey = string = iterator.next();
            if ("showtotalqty".equals(string)) continue;
            if ("orgs".equals(string)) {
                propKey = "org";
            } else if ("currencys".equals(string)) {
                propKey = "currency";
            } else if ("bd_supplier".equals(string) || "bd_customer".equals(string) || "bos_user".equals(string)) {
                propKey = "asstact";
            } else if (string.startsWith("q_")) {
                propKey = propKey.substring(2);
            }
            Object value = null;
            if (row.get(propKey) != null) {
                value = row.get(propKey);
            }
            if (ObjectUtils.isEmpty(value) && parentFormProps.containsKey((Object)string)) {
                value = parentModel.getValue(string);
            }
            if ((prop = (IDataEntityProperty)properties.get((Object)string)) == null) continue;
            if (prop instanceof MulBasedataProp) {
                value = this.getMutlBasedataPks(value);
            }
            this.getModel().setValue(string, value);
        }
        this.getModel().setValue("startdate", parentModel.getValue("startdate"));
        this.getModel().setValue("stopdate", parentModel.getValue("stopdate"));
        String asstactType = (String)this.getModel().getValue("q_asstacttype");
        for (String asstactProp : asstactPropKeys) {
            this.getView().setVisible(Boolean.valueOf(asstactProp.equals(asstactType)), new String[]{asstactProp});
        }
        ReportFilter reportFilter = (ReportFilter)this.getControl("reportfilterap");
        reportFilter.search();
    }

    private List<String> getFilterFieldKeys() {
        Container fixFilterContainer = (Container)this.getView().getControl("fsap");
        Container commFilterContainer = (Container)this.getView().getControl("commonfs");
        Container showFilterContainer = (Container)this.getView().getControl("flexpanelap1");
        Container moreFilterContainer = (Container)this.getView().getControl("reportmorefilterpanelap");
        ArrayList filterItems = new ArrayList(8);
        filterItems.addAll(fixFilterContainer.getItems());
        filterItems.addAll(commFilterContainer.getItems());
        filterItems.addAll(showFilterContainer.getItems());
        filterItems.addAll(moreFilterContainer.getItems());
        return filterItems.stream().map(Control::getKey).collect(Collectors.toList());
    }

    private Object getMutlBasedataPks(Object value) {
        if (value instanceof DynamicObjectCollection) {
            DynamicObjectCollection temCollectionValue = (DynamicObjectCollection)value;
            ArrayList<Object> pks = new ArrayList<Object>(((DynamicObjectCollection)value).size());
            for (DynamicObject eachValue : temCollectionValue) {
                pks.add(eachValue.getDynamicObject("fbasedataid").getPkValue());
            }
            value = pks.toArray(new Object[0]);
        } else if (value instanceof DynamicObject) {
            value = new Object[]{((DynamicObject)value).getPkValue()};
        } else if (value instanceof Map) {
            Object id = ((Map)value).get("id");
            value = new Object[]{Long.valueOf(id.toString())};
        }
        return value;
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        BizTypeDisplayNameProvider bizTypeDisplayNameProvider = new BizTypeDisplayNameProvider("ar_finarbill", "ar_busbill", "cas_recbill", "ar_receivedbill", "ar_settlerecord", "ap_finapbill", "ap_busbill", "cas_paybill", "ap_paidbill", "ap_settlerecord");
        for (int i = 0; i < rowData.size(); ++i) {
            ILocaleString displayName;
            DynamicObject row = (DynamicObject)rowData.get(i);
            String bizType = row.getString("biztype");
            if (ObjectUtils.isEmpty((Object)bizType) || (displayName = bizTypeDisplayNameProvider.getDisplayName(bizType)) == null) continue;
            row.set("biztype", (Object)displayName.getLocaleValue());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        IDataModel m = this.getModel();
        if ("showmaincurrency".equals(key)) {
            ChangeData[] changeDatas = e.getChangeSet();
            Object newValue = changeDatas[0].getNewValue();
            boolean isShowLocalAmt = (Boolean)newValue;
            ReportConf conf = this.getReportConf();
            List bigTableColConfs = conf.getBigTableColConf();
            String showKeyCols = (String)m.getValue("showkeycols");
            for (BigTableColConf bigTableColConf : bigTableColConfs) {
                if (isShowLocalAmt) {
                    if (!"basecurrency".equals(bigTableColConf.getCol())) continue;
                    String concat = showKeyCols.concat(",basecurrency");
                    m.setValue("showkeycols", (Object)concat);
                    continue;
                }
                List showKeyColList = Stream.of(showKeyCols.split(",")).filter(EmptyUtils::isNotEmpty).collect(Collectors.toList());
                showKeyColList.removeIf("basecurrency"::equals);
                m.setValue("showkeycols", (Object)String.join((CharSequence)",", showKeyColList));
            }
            List cols = bigTableColConfs.stream().filter(colConf -> "B".equals(colConf.getCalType())).map(BigTableColConf::getCol).collect(Collectors.toList());
            if (!isShowLocalAmt) {
                cols.removeIf(col -> StringUtils.startsWith((String)col, (String)"local"));
            }
            m.setValue("showqtycols", (Object)String.join((CharSequence)",", cols));
        }
    }

    private ReportConf getReportConf() {
        if (this.confCache == null) {
            this.confCache = ReportDataHandle.loadReportConf((String)this.getModel().getDataEntityType().getName());
        }
        return this.confCache;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        SumRptParam param = this.getSumParam(queryParam);
        queryParam.getCustomParam().put(SumRptParam.class.getName(), param);
    }

    private SumRptParam getSumParam(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        SumRptParam param = new SumRptParam();
        param.setApSys(this.isAp());
        DynamicObjectCollection orgs = filterInfo.getDynamicObjectCollection("orgs");
        List<Long> orgIds = DynamicObjectHelper.getLongIds((Collection<DynamicObject>)orgs);
        param.setOrgIds(orgIds);
        param.setAsstactType(filterInfo.getString("q_asstacttype"));
        if (!EmptyUtils.isEmpty(param.getAsstactType())) {
            DynamicObjectCollection asstacts = filterInfo.getDynamicObjectCollection(param.getAsstactType());
            param.setAsstactIds(ReportHelper.getBasedataIds((List<DynamicObject>)asstacts));
        }
        DynamicObjectCollection currencys = filterInfo.getDynamicObjectCollection("currencys");
        param.setCurrencyIds(DynamicObjectHelper.getLongIds((Collection<DynamicObject>)currencys));
        Date startDate = DateUtils.getDataFormat(filterInfo.getDate("startdate"), true);
        param.setStartDate(startDate);
        param.setStopDate(DateUtils.getDataFormat(filterInfo.getDate("stopdate"), false));
        param.setBillScope(filterInfo.getString("billscope"));
        param.setNotShowZero(filterInfo.getBoolean("notshowzero"));
        param.setNotShowNull(filterInfo.getBoolean("notshownull"));
        param.setNotShowNullAndZero(filterInfo.getBoolean("notshownullandzero"));
        param.setShowMainCurrency(filterInfo.getBoolean("showmaincurrency"));
        param.setContainsPrepaid(filterInfo.getBoolean("containsprepaid"));
        param.setOnlyContainsAmount(filterInfo.getBoolean("onlycontainsamount"));
        CloseRecordService closeRecordService = new CloseRecordService(this.isAp());
        HashMap<Long, Map<Long, Date>> closeInfoMap = new HashMap<Long, Map<Long, Date>>(orgIds.size());
        Date minCloseDate = null;
        Date balanceDate = DateUtils.getLastDay(startDate, 1);
        for (Long orgId : orgIds) {
            HashMap<Long, Date> closeMap = new HashMap<Long, Date>(1);
            DynamicObject closeRecord = closeRecordService.queryCloseRecord(orgId, balanceDate);
            if (closeRecord == null) continue;
            if (minCloseDate == null) {
                minCloseDate = new Date();
            }
            Date closeDate = closeRecord.getDate("closedate");
            closeMap.put(closeRecord.getLong("id"), closeDate);
            closeInfoMap.put(orgId, closeMap);
            if (!minCloseDate.after(closeDate)) continue;
            minCloseDate = closeDate;
        }
        param.setCloseInfoMap(closeInfoMap);
        param.setMinCloseDate(minCloseDate);
        return param;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        super.registerListener((EventObject)hyperLinkClickEvent);
        ReportList reportList = (ReportList)hyperLinkClickEvent.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(hyperLinkClickEvent.getRowIndex());
        String type = rowData.getString("type");
        if ("sum".equals(type) || "totalsum".equals(type) || "periodbalance".equals(type)) {
            return;
        }
        if ("ar_settlerecord".equals(type) || "ap_settlerecord".equals(type)) {
            String message = ResManager.loadKDString((String)"\u660e\u7ec6\u8868\u4e0d\u652f\u6301\u8054\u67e5\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"DetailForm_0", (String)"fi-arapcommon", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        long billId = rowData.getLong("billid");
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(type);
        parameter.setPkId((Object)billId);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

