/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.detailv2;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.bplat.scmc.report.core.transform.plan.GroupPlan;
import kd.fi.arapcommon.report.detailv2.impl.BalanceDetailImpl;
import kd.fi.arapcommon.report.detailv2.impl.JournalDetailImpl;
import kd.fi.arapcommon.report.detailv2.transform.CalculateShowColumns;
import kd.fi.arapcommon.report.detailv2.transform.FilterandSortResults;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.SumRptParam;
import org.apache.commons.lang.StringUtils;

public class DetailRptHandle
implements IReportDataHandle {
    private SumRptParam param;

    public void setupCtx(ReportDataCtx ctx) {
        this.param = (SumRptParam)ctx.getParam(SumRptParam.class.getName());
        ctx.setShowBlockEntity(false);
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getFixedFilter());
        } else {
            fixedFs.addAll(this.getFixedFilter());
        }
    }

    private List<QFilter> getFixedFilter() {
        List<Long> currencyIds;
        LinkedList<QFilter> fixedFilters = new LinkedList<QFilter>();
        QFilter orgFilter = new QFilter("org", "in", this.param.getOrgIds());
        fixedFilters.add(orgFilter);
        if (!EmptyUtils.isEmpty(this.param.getAsstactType())) {
            QFilter asstactTypeFilter = new QFilter("asstacttype", "=", (Object)this.param.getAsstactType());
            fixedFilters.add(asstactTypeFilter);
        } else {
            fixedFilters.add(new QFilter("asstacttype", "in", Arrays.asList("bd_supplier", "bd_customer", "bos_user")));
        }
        List<Object> asstactIds = this.param.getAsstactIds();
        if (!EmptyUtils.isEmpty(asstactIds)) {
            QFilter asstactFilter = new QFilter("asstact", "in", asstactIds);
            fixedFilters.add(asstactFilter);
        }
        if (!EmptyUtils.isEmpty(currencyIds = this.param.getCurrencyIds())) {
            QFilter currencyFilter = new QFilter("currency", "in", currencyIds);
            fixedFilters.add(currencyFilter);
        }
        return fixedFilters;
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        for (SrcBlockConf blockConf : blockCollector) {
            String srcEntity = blockConf.getSrcEntity();
            if (StringUtils.contains((String)srcEntity, (String)"journal")) {
                new JournalDetailImpl(this.param).modifyBlock(blockConf);
                continue;
            }
            if (!StringUtils.contains((String)srcEntity, (String)"balance")) continue;
            new BalanceDetailImpl(this.param).modifyBlock(blockConf);
        }
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("org");
        repoColFilter.add("bizdate");
        repoColFilter.add("biztype");
        repoColFilter.add("entitykey");
        repoColFilter.add("billScope");
        repoColFilter.add("sourcebilltype");
        repoColFilter.add("type");
        repoColFilter.add("sumlevel");
        repoColFilter.add("billid");
        repoColFilter.add("billno");
        repoColFilter.add("billstatus");
        repoColFilter.add("periodamt");
        repoColFilter.add("finamount");
        repoColFilter.add("busamount");
        repoColFilter.add("precasamount");
        if (this.param.isShowMainCurrency()) {
            repoColFilter.add("basecurrency");
            repoColFilter.add("localperiodamt");
            repoColFilter.add("localfinamount");
            repoColFilter.add("localbusamount");
            repoColFilter.add("localprecasamount");
        }
    }

    public void handleBlockDataSelectCols(Set<String> repoColFilter, SrcBlockConf blockConf, ReportDataCtx ctx) {
        Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
        String entityKey = blockConf.getSrcEntity();
        boolean onlyContainsAmount = this.param.isOnlyContainsAmount();
        if ("ar_journal".equals(entityKey) || "ap_journal".equals(entityKey)) {
            repoColFullSrcColMap.put("billid", "sourcebillid");
            repoColFullSrcColMap.put("billno", "billno");
            repoColFullSrcColMap.put("type", "sourcebilltype");
            repoColFullSrcColMap.put("sumlevel", "0");
            if (onlyContainsAmount) {
                repoColFullSrcColMap.put("busamount", "estimatednotaxamt");
                repoColFullSrcColMap.put("localbusamount", "localestimatednotaxamt");
            }
        } else if (onlyContainsAmount && ("ap_newbalance".equals(entityKey) || "ar_balance".equals(entityKey))) {
            repoColFullSrcColMap.put("busamount", "busnotaxbalance");
            repoColFullSrcColMap.put("localbusamount", "localbusnotaxbalance");
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new CalculateShowColumns(ctx));
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        GroupPlan groupPlan = ctx.getGroupPlan();
        Collection keyCols = groupPlan.getKeyCols();
        keyCols.add("type");
        keyCols.add("sumlevel");
        keyCols.add("biztype");
        keyCols.add("billid");
        keyCols.add("billno");
        keyCols.add("bizdate");
        keyCols.add("billstatus");
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new FilterandSortResults(ctx));
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> columns, ReportDataCtx ctx) {
        LinkedList<AbstractReportColumn> showCols = new LinkedList<AbstractReportColumn>();
        LinkedList<AbstractReportColumn> localColumns = new LinkedList<AbstractReportColumn>();
        LinkedList<AbstractReportColumn> originColumns = new LinkedList<AbstractReportColumn>();
        for (AbstractReportColumn col : columns) {
            ReportColumn column = (ReportColumn)col;
            if ("currency".equals(column.getFieldKey())) {
                originColumns.add(col);
                continue;
            }
            if ("basecurrency".equals(column.getFieldKey())) {
                localColumns.add(col);
                continue;
            }
            if ("amount".equals(column.getFieldType())) {
                if (StringUtils.startsWith((String)column.getFieldKey(), (String)"local")) {
                    localColumns.add(col);
                    continue;
                }
                originColumns.add(col);
                continue;
            }
            showCols.add(col);
        }
        ReportColumnGroup columnGroup = this.createColumnGroup("currencygroup", originColumns);
        showCols.add((AbstractReportColumn)columnGroup);
        if (!ObjectUtils.isEmpty(localColumns)) {
            ReportColumnGroup locColumnGroup = this.createColumnGroup("maincurrencygroup", localColumns);
            showCols.add((AbstractReportColumn)locColumnGroup);
        }
        return showCols;
    }

    private ReportColumnGroup createColumnGroup(String groupKey, List<AbstractReportColumn> amtColumns) {
        String caption = ResManager.loadKDString((String)"\u539f\u5e01", (String)"SumandDetailRptHandle_0", (String)"fi-arapcommon", (Object[])new Object[0]);
        if ("maincurrencygroup".equals(groupKey)) {
            caption = ResManager.loadKDString((String)"\u672c\u4f4d\u5e01", (String)"SumandDetailRptHandle_1", (String)"fi-arapcommon", (Object[])new Object[0]);
        }
        ReportColumnGroup columnGroup = new ReportColumnGroup();
        columnGroup.setCaption(new LocaleString(caption));
        columnGroup.setFieldKey(groupKey);
        columnGroup.getChildren().addAll(amtColumns);
        return columnGroup;
    }
}

