/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.detailv2.transform.func;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.util.RowXIterator;
import kd.bplat.scmc.report.util.TransformUtil;
import kd.fi.arapcommon.vo.SumRptParam;

public class AddBalRowGroupReduceFunc
extends GroupReduceFunction {
    private RowMeta rowMeta;
    private Map<String, Integer> indexs;
    private Set<String> qtyCols;
    private Set<String> keyCols;
    private Date startDate;
    private boolean isShowMainCurrency;

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public AddBalRowGroupReduceFunc(ReportDataCtx ctx, RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.qtyCols = ctx.getShowQtyCols();
        this.keyCols = ctx.getShowKeyCols();
        SumRptParam param = (SumRptParam)ctx.getParam(SumRptParam.class.getName());
        this.startDate = param.getStartDate();
        this.isShowMainCurrency = param.isShowMainCurrency();
        this.indexs = this.buildIndexs();
    }

    private Map<String, Integer> buildIndexs() {
        ArrayList<String> columns = new ArrayList<String>(13);
        columns.add("type");
        columns.add("sumlevel");
        columns.add("billstatus");
        columns.add("bizdate");
        for (String keyCol : this.keyCols) {
            columns.add(keyCol);
        }
        columns.add("currency");
        columns.add("periodamt");
        columns.add("finamt");
        columns.add("precasamt");
        columns.add("settleamt");
        columns.add("cassettleamt");
        columns.add("balance");
        if (this.isShowMainCurrency) {
            columns.add("basecurrency");
            columns.add("localperiodamt");
            columns.add("localfinamt");
            columns.add("localprecasamt");
            columns.add("localsettleamt");
            columns.add("localcassettleamt");
            columns.add("localbalance");
        }
        return TransformUtil.buildIndexs((RowMeta)this.rowMeta, columns);
    }

    public void reduce(Iterable<RowX> it, Collector cl) {
        DataSet dataSet = Algo.create((String)"AddBalRowGroupReduceFunc").createDataSet((Iterator)new RowXIterator(it), this.rowMeta);
        dataSet = dataSet.orderBy(new String[]{"bizdate asc"});
        this.buildBalCol(dataSet, cl);
    }

    private void buildBalCol(DataSet dataSet, Collector cl) {
        RowX periodBalanceRow = null;
        RowX sumRow = null;
        for (Row row : dataSet) {
            RowX data = new RowX(RowUtil.toArray((Row)row));
            if (periodBalanceRow == null) {
                periodBalanceRow = this.buildPeriodBalanceRow(data);
            }
            if (data.getDate(this.indexs.get("bizdate").intValue()).before(this.startDate)) {
                this.calPeriodBalance(periodBalanceRow, data);
                continue;
            }
            if (sumRow == null) {
                sumRow = this.buildSumRow(periodBalanceRow);
                cl.collect(periodBalanceRow);
            }
            this.calDataandSumRow(sumRow, data);
            cl.collect(data);
        }
        if (periodBalanceRow == null) {
            return;
        }
        if (sumRow == null) {
            sumRow = this.buildSumRow(periodBalanceRow);
            cl.collect(periodBalanceRow);
        }
        cl.collect(sumRow);
    }

    private RowX buildPeriodBalanceRow(RowX data) {
        RowX periodBalanceRow = new RowX(new Object[data.size()]);
        int index = -1;
        for (String keyCol : this.keyCols) {
            index = this.indexs.get(keyCol);
            periodBalanceRow.set(index, data.get(index));
        }
        int currencyIndex = this.indexs.get("currency");
        periodBalanceRow.set(currencyIndex, data.get(currencyIndex));
        if (this.isShowMainCurrency) {
            int baseCurrencyIndex = this.indexs.get("basecurrency");
            periodBalanceRow.set(baseCurrencyIndex, data.get(baseCurrencyIndex));
        }
        periodBalanceRow.set(this.indexs.get("type").intValue(), (Object)"periodbalance");
        periodBalanceRow.set(this.indexs.get("sumlevel").intValue(), (Object)-1);
        for (String amt : this.qtyCols) {
            periodBalanceRow.set(this.indexs.get(amt).intValue(), (Object)BigDecimal.ZERO);
        }
        return periodBalanceRow;
    }

    private void calPeriodBalance(RowX periodBalanceRow, RowX data) {
        int periodAmtIndex = this.indexs.get("periodamt");
        int balanceIndex = this.indexs.get("balance");
        periodBalanceRow.set(balanceIndex, (Object)periodBalanceRow.getBigDecimal(balanceIndex).add(data.getBigDecimal(periodAmtIndex)));
        if (this.isShowMainCurrency) {
            int localPeriodAmtIndex = this.indexs.get("localperiodamt");
            int localBalanceIndex = this.indexs.get("localbalance");
            periodBalanceRow.set(localBalanceIndex, (Object)periodBalanceRow.getBigDecimal(localBalanceIndex).add(data.getBigDecimal(localPeriodAmtIndex)));
        }
    }

    private RowX buildSumRow(RowX periodBalanceRow) {
        RowX sumRow = periodBalanceRow.copy();
        sumRow.set(this.indexs.get("type").intValue(), (Object)"sum");
        sumRow.set(this.indexs.get("sumlevel").intValue(), (Object)1);
        return sumRow;
    }

    private void calDataandSumRow(RowX sumRow, RowX data) {
        int balanceIndex = this.indexs.get("balance");
        BigDecimal balance = sumRow.getBigDecimal(balanceIndex).add(data.getBigDecimal(balanceIndex));
        sumRow.set(balanceIndex, (Object)balance);
        int finAmtIndex = this.indexs.get("finamt");
        int preCasAmtIndex = this.indexs.get("precasamt");
        int settleAmtIndex = this.indexs.get("settleamt");
        int casSettleAmtIndex = this.indexs.get("cassettleamt");
        sumRow.set(finAmtIndex, (Object)sumRow.getBigDecimal(finAmtIndex).add(data.getBigDecimal(finAmtIndex)));
        sumRow.set(preCasAmtIndex, (Object)sumRow.getBigDecimal(preCasAmtIndex).add(data.getBigDecimal(preCasAmtIndex)));
        sumRow.set(settleAmtIndex, (Object)sumRow.getBigDecimal(settleAmtIndex).add(data.getBigDecimal(settleAmtIndex)));
        sumRow.set(casSettleAmtIndex, (Object)sumRow.getBigDecimal(casSettleAmtIndex).add(data.getBigDecimal(casSettleAmtIndex)));
        data.set(this.indexs.get("sumlevel").intValue(), (Object)0);
        data.set(balanceIndex, (Object)balance);
        String type = data.getString(this.indexs.get("type").intValue());
        boolean isCasBill = "cas_recbill".equals(type) || "cas_paybill".equals(type);
        data.set(this.indexs.get("billstatus").intValue(), (Object)(isCasBill ? "D" : "C"));
        if (this.isShowMainCurrency) {
            int localBalanceIndex = this.indexs.get("localbalance");
            BigDecimal localBalance = sumRow.getBigDecimal(localBalanceIndex).add(data.getBigDecimal(localBalanceIndex));
            sumRow.set(localBalanceIndex, (Object)localBalance);
            data.set(localBalanceIndex, (Object)localBalance);
            int localFinAmtIndex = this.indexs.get("localfinamt");
            int localPreCasIndex = this.indexs.get("localprecasamt");
            int localSettleAmtIndex = this.indexs.get("localsettleamt");
            int localCasSettleAmtIndex = this.indexs.get("localcassettleamt");
            sumRow.set(localFinAmtIndex, (Object)sumRow.getBigDecimal(localFinAmtIndex).add(data.getBigDecimal(localFinAmtIndex)));
            sumRow.set(localPreCasIndex, (Object)sumRow.getBigDecimal(localPreCasIndex).add(data.getBigDecimal(localPreCasIndex)));
            sumRow.set(localSettleAmtIndex, (Object)sumRow.getBigDecimal(localSettleAmtIndex).add(data.getBigDecimal(localSettleAmtIndex)));
            sumRow.set(localCasSettleAmtIndex, (Object)sumRow.getBigDecimal(localCasSettleAmtIndex).add(data.getBigDecimal(localCasSettleAmtIndex)));
        }
    }
}

