/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.detailv2.transform.func;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.util.TransformUtil;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.vo.SumRptParam;

public class ApCalculateColumnMapFunc
extends MapFunction {
    private RowMeta rowMeta;
    private SumRptParam param;
    private Date startDate;
    private boolean isContainsPrepaid;
    private Map<String, Integer> indexs;
    private boolean isShowMainCurrency;
    private String billScope;

    public ApCalculateColumnMapFunc(RowMeta rowMeta, ReportDataCtx ctx) {
        this.rowMeta = rowMeta;
        this.param = (SumRptParam)ctx.getParam(SumRptParam.class.getName());
        this.startDate = this.param.getStartDate();
        this.isContainsPrepaid = this.param.isContainsPrepaid();
        this.isShowMainCurrency = this.param.isShowMainCurrency();
        this.billScope = this.param.getBillScope();
        this.indexs = this.buildIndexs();
    }

    private Map<String, Integer> buildIndexs() {
        ArrayList<String> columns = new ArrayList<String>(24);
        columns.add("bizdate");
        columns.add("biztype");
        columns.add("entitykey");
        columns.add("sourcebilltype");
        columns.add("org");
        columns.add("finamount");
        columns.add("busamount");
        columns.add("precasamount");
        columns.add("finamt");
        columns.add("precasamt");
        columns.add("settleamt");
        columns.add("cassettleamt");
        columns.add("periodamt");
        columns.add("balance");
        if (this.isShowMainCurrency) {
            columns.add("localfinamount");
            columns.add("localbusamount");
            columns.add("localprecasamount");
            columns.add("localfinamt");
            columns.add("localprecasamt");
            columns.add("localsettleamt");
            columns.add("localcassettleamt");
            columns.add("localperiodamt");
            columns.add("localbalance");
        }
        return TransformUtil.buildIndexs((RowMeta)this.rowMeta, columns);
    }

    public RowX map(RowX rowX) {
        this.calculate(rowX, false);
        if (this.isShowMainCurrency) {
            this.calculate(rowX, true);
        }
        return rowX;
    }

    private void calculate(RowX rowX, boolean isShowMainCurrency) {
        BigDecimal periodAmt;
        BigDecimal finAmount = rowX.getBigDecimal(this.indexs.get(isShowMainCurrency ? "localfinamount" : "finamount").intValue());
        BigDecimal busAmount = rowX.getBigDecimal(this.indexs.get(isShowMainCurrency ? "localbusamount" : "busamount").intValue());
        BigDecimal preCasAmount = rowX.getBigDecimal(this.indexs.get(isShowMainCurrency ? "localprecasamount" : "precasamount").intValue());
        String sourceBillType = rowX.getString(this.indexs.get("sourcebilltype").intValue());
        Date bizDate = rowX.getDate(this.indexs.get("bizdate").intValue());
        bizDate = DateUtils.getDataFormat(bizDate, true);
        this.startDate = DateUtils.getDataFormat(this.startDate, true);
        if (bizDate.compareTo(this.startDate) < 0) {
            periodAmt = this.calculatePeriodAmt(finAmount, busAmount, preCasAmount);
            rowX.set(this.indexs.get(isShowMainCurrency ? "localperiodamt" : "periodamt").intValue(), (Object)periodAmt);
        }
        if (bizDate.compareTo(this.startDate) >= 0) {
            if (this.isContainsPrepaid && ("cas_paybill".equals(sourceBillType) || "ap_paidbill".equals(sourceBillType) || "ap_adjexchbill".equals(sourceBillType))) {
                rowX.set(this.indexs.get(isShowMainCurrency ? "localprecasamt" : "precasamt").intValue(), (Object)preCasAmount);
            }
            if ("ap_settlerecord".equals(sourceBillType) || "ar_settlerecord".equals(sourceBillType)) {
                String bizType = rowX.getString(this.indexs.get("biztype").intValue());
                HashSet<String> bizTypes = new HashSet<String>(4);
                bizTypes.add("recpaysettle");
                bizTypes.add("payrecsettle");
                bizTypes.add("payself");
                bizTypes.add("payclearing");
                if (!bizTypes.contains(bizType)) {
                    rowX.set(this.indexs.get(isShowMainCurrency ? "localsettleamt" : "settleamt").intValue(), (Object)finAmount.negate());
                }
                if (this.isContainsPrepaid) {
                    bizTypes.add("arpaysettle");
                    bizTypes.add("appaysettle");
                    if (bizTypes.contains(bizType)) {
                        rowX.set(this.indexs.get(isShowMainCurrency ? "localcassettleamt" : "cassettleamt").intValue(), (Object)preCasAmount.negate());
                    }
                }
            }
            BigDecimal finAmt = BigDecimal.ZERO;
            if ("ap_finapbill".equals(sourceBillType) || "ap_busbill".equals(sourceBillType) || "ap_adjexchbill".equals(sourceBillType)) {
                if ("ALL".equals(this.billScope)) {
                    finAmt = finAmount.add(busAmount);
                } else if ("ap_finapbill".equals(this.billScope)) {
                    finAmt = finAmount;
                } else if ("ap_busbill".equals(this.billScope)) {
                    finAmt = busAmount;
                }
                rowX.set(this.indexs.get(isShowMainCurrency ? "localfinamt" : "finamt").intValue(), (Object)finAmt);
            }
        }
        periodAmt = rowX.getBigDecimal(this.indexs.get(isShowMainCurrency ? "localperiodamt" : "periodamt").intValue());
        BigDecimal finAmt = rowX.getBigDecimal(this.indexs.get(isShowMainCurrency ? "localfinamt" : "finamt").intValue());
        BigDecimal preCasAmt = rowX.getBigDecimal(this.indexs.get(isShowMainCurrency ? "localprecasamt" : "precasamt").intValue());
        BigDecimal settleAmt = rowX.getBigDecimal(this.indexs.get(isShowMainCurrency ? "localsettleamt" : "settleamt").intValue());
        BigDecimal casSettleAmt = rowX.getBigDecimal(this.indexs.get(isShowMainCurrency ? "localcassettleamt" : "cassettleamt").intValue());
        rowX.set(this.indexs.get(isShowMainCurrency ? "localbalance" : "balance").intValue(), (Object)periodAmt.add(finAmt).subtract(preCasAmt).subtract(settleAmt).add(casSettleAmt));
    }

    private BigDecimal calculatePeriodAmt(BigDecimal finAmount, BigDecimal busAmount, BigDecimal preCasAmount) {
        String billScope = this.param.getBillScope();
        BigDecimal periodAmt = "ap_finapbill".equals(billScope) ? (this.param.isContainsPrepaid() ? finAmount.subtract(preCasAmount) : finAmount) : ("ap_busbill".equals(billScope) ? (this.param.isContainsPrepaid() ? busAmount.subtract(preCasAmount) : busAmount) : (this.param.isContainsPrepaid() ? finAmount.add(busAmount).subtract(preCasAmount) : finAmount.add(busAmount)));
        return periodAmt;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

