/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.invoicev2;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.JoinBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.fi.arapcommon.report.acctagev2.transform.AsstactTransfer;
import kd.fi.arapcommon.report.invoicev2.InvoiceRptParam;
import kd.fi.arapcommon.report.invoicev2.transform.SortResults;

public class InvoiceRptHandle
implements IReportDataHandle {
    private InvoiceRptParam reportParam;

    public void setupCtx(ReportDataCtx ctx) {
        this.reportParam = (InvoiceRptParam)ctx.getParam(InvoiceRptParam.class.getName());
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getBaseFilter());
        } else {
            fixedFs.addAll(this.getBaseFilter());
        }
    }

    private List<QFilter> getBaseFilter() {
        LinkedList<QFilter> filters = new LinkedList<QFilter>();
        QFilter orgFilter = new QFilter("org", "in", this.reportParam.getOrgIds());
        filters.add(orgFilter);
        if (!ObjectUtils.isEmpty((Object)this.reportParam.getAsstactType())) {
            QFilter asstactTypeFilter = new QFilter("asstacttype", "=", (Object)this.reportParam.getAsstactType());
            filters.add(asstactTypeFilter);
            List<Object> asstactIds = this.reportParam.getAsstactIds();
            if (!ObjectUtils.isEmpty(asstactIds)) {
                QFilter asstactFilter = new QFilter("asstact", "in", asstactIds);
                filters.add(asstactFilter);
            }
        } else {
            filters.add(new QFilter("asstacttype", "in", Arrays.asList("bd_supplier", "bd_customer", "bos_user")));
        }
        QFilter bizStartDateFilter = new QFilter("bizdate", ">=", (Object)this.reportParam.getBizStartDate());
        filters.add(bizStartDateFilter);
        QFilter bizStopDateFilter = new QFilter("bizdate", "<=", (Object)this.reportParam.getBizStopDate());
        filters.add(bizStopDateFilter);
        String isVoucherStr = this.reportParam.getIsVoucherStr();
        if ("0".equals(isVoucherStr)) {
            filters.add(new QFilter("isvoucher", "=", (Object)Boolean.FALSE));
        } else if ("1".equals(isVoucherStr)) {
            filters.add(new QFilter("isvoucher", "=", (Object)Boolean.TRUE));
        }
        return filters;
    }

    public void modifyJoinBlocks(List<JoinBlockConf> joinBlockConfs, ReportDataCtx ctx) {
        for (JoinBlockConf joinBlockConf : joinBlockConfs) {
            joinBlockConf.setAllowNotMatch(true);
            QFilter filter = new QFilter("invoicedate", ">=", (Object)this.reportParam.getInvoiceStartDate());
            QFilter invoiceStopDateFilter = new QFilter("invoicedate", "<=", (Object)this.reportParam.getInvoiceStopDate());
            filter.and(invoiceStopDateFilter);
            List<Long> invoiceTypeIds = this.reportParam.getInvoiceTypeIds();
            if (!ObjectUtils.isEmpty(invoiceTypeIds)) {
                QFilter invoiceTypeFlter = new QFilter("invoicetypef7", "in", invoiceTypeIds);
                filter.and(invoiceTypeFlter);
            }
            joinBlockConf.setDataFs(filter);
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new AsstactTransfer());
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new SortResults());
    }
}

