/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.mlv2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.report.ReportHelper;
import kd.fi.arapcommon.report.mlv2.MaturityLiabParam;
import kd.fi.arapcommon.util.DateUtils;

public class MaturityLiabForm
extends AbstractReportFormPlugin {
    private List<Long> orgIds = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initF7();
        ReportList rptList = (ReportList)this.getView().getControl("reportlistap");
        rptList.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent event) {
                if ("billno".equals(event.getFieldName())) {
                    int rowIndex = event.getRowIndex();
                    ReportList reportList = (ReportList)event.getSource();
                    IReportListModel reportModel = reportList.getReportModel();
                    DynamicObject rowData = reportModel.getRowData(rowIndex);
                    MaturityLiabForm.this.showFormEditPage(rowData);
                }
            }
        });
    }

    private void initF7() {
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl("orgs");
        orgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (this.orgIds == null) {
                List<DynamicObject> orgs = OrgHelper.getAuthorizedInitializedOrgs(this.getView().getEntityId(), "47150e89000000ac", false);
                this.orgIds = orgs.stream().map(org -> org.getLong("id")).distinct().collect(Collectors.toList());
            }
            QFilter qFilter = new QFilter("id", "in", this.orgIds);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void showFormEditPage(DynamicObject rowData) {
        BillShowParameter parameter = new BillShowParameter();
        if (rowData.getLong("id") > 0L) {
            parameter.setPkId((Object)rowData.getLong("id"));
            parameter.setFormId("ap_finapbill");
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            boolean isPeriod = rowData.getBoolean("isperiod");
            parameter.setCustomParam("isPeriod", (Object)isPeriod);
            if (isPeriod) {
                String caption = ResManager.loadKDString((String)"\u671f\u521d\u8d22\u52a1\u5e94\u4ed8\u5355", (String)"MaturityLiabForm_0", (String)"fi-arapcommon", (Object[])new Object[0]);
                parameter.setCaption(caption);
            }
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        if (this.orgIds == null) {
            List<DynamicObject> orgs = OrgHelper.getAuthorizedInitializedOrgs(this.getView().getEntityId(), "47150e89000000ac", false);
            this.orgIds = orgs.stream().map(org -> org.getLong("id")).distinct().collect(Collectors.toList());
        }
        long loginOrgID = RequestContext.get().getOrgId();
        if (!this.orgIds.isEmpty()) {
            long orgId = this.orgIds.get(0);
            if (this.orgIds.contains(loginOrgID)) {
                orgId = loginOrgID;
            }
            this.getModel().setValue("orgs", (Object)new Object[]{orgId});
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection orgs = filterInfo.getDynamicObjectCollection("orgs");
        if (orgs == null || orgs.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MaturityLiabForm_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        Date date = filterInfo.getDate("date");
        if (ObjectUtils.isEmpty((Object)date)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MaturityLiabForm_2", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getString("standard") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u9f84\u8ba1\u7b97\u6807\u51c6\u3002", (String)"MaturityLiabForm_3", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        FilterInfo filter = queryParam.getFilter();
        Date date = filter.getDate("date");
        for (DynamicObject row : rowData) {
            Date compareDate = row.getDate("comparedate");
            String standard = filter.getString("standard");
            if ("bizdate".equals(standard)) {
                compareDate = row.getDate("bizdate");
            }
            if (compareDate == null || date == null) continue;
            row.set("duedays", (Object)DateUtils.getDiffDaysIgnoreTime(compareDate, date));
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        MaturityLiabParam param = this.buildReportParam(queryParam);
        queryParam.getCustomParam().put(MaturityLiabParam.class.getName(), param);
    }

    private MaturityLiabParam buildReportParam(ReportQueryParam queryParam) {
        Date queryDate;
        MaturityLiabParam param = new MaturityLiabParam();
        FilterInfo filterInfo = queryParam.getFilter();
        String compareDateFieldKey = filterInfo.getString("standard");
        param.setStandard(compareDateFieldKey);
        param.setOrgIds(DynamicObjectHelper.getIdList((Collection<DynamicObject>)filterInfo.getDynamicObjectCollection("orgs")));
        param.setCurrencyIds(DynamicObjectHelper.getLongIds((Collection<DynamicObject>)filterInfo.getDynamicObjectCollection("currencys")));
        String asstactType = filterInfo.getString("q_asstacttype");
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            param.setAsstactType(asstactType);
            DynamicObjectCollection acctacts = filterInfo.getDynamicObjectCollection(param.getAsstactType());
            param.setAsstactIds(ReportHelper.getBasedataIds((List<DynamicObject>)acctacts));
        }
        if ((queryDate = filterInfo.getDate("date")) != null) {
            queryDate = DateUtils.getDataFormat(queryDate, true);
        }
        param.setQueryDate(queryDate);
        param.setContainsUnaudit(filterInfo.getBoolean("isincludesubmit"));
        return param;
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        if ("showqtycols".equals(key)) {
            List qtyCols = Stream.of(((String)value).split(",")).collect(Collectors.toList());
            if (!qtyCols.contains("topayamt")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u503c\u201d\u4e2d\u9009\u9879\u201c\u5f85\u4ed8\u6b3e\u91d1\u989d\u201d\u5fc5\u9009\u3002", (String)"MaturityLiabForm_4", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
        } else if ("showkeycols".equals(key)) {
            List keyCols = Stream.of(((String)value).split(",")).collect(Collectors.toList());
            if (!keyCols.contains("org")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u4f9d\u636e\u201d\u4e2d\u9009\u9879\u201c\u7ec4\u7ec7\u201d\u5fc5\u9009\u3002", (String)"MaturityLiabForm_5", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
            if (!keyCols.contains("currency")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u4f9d\u636e\u201d\u4e2d\u9009\u9879\u201c\u5e01\u79cd\u201d\u5fc5\u9009\u3002", (String)"MaturityLiabForm_6", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
            if (!keyCols.contains("remark")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u4f9d\u636e\u201d\u4e2d\u9009\u9879\u201c\u5907\u6ce8\u201d\u5fc5\u9009\u3002", (String)"MaturityLiabForm_7", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
            if (!keyCols.contains("comparedate")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u4f9d\u636e\u201d\u4e2d\u9009\u9879\u201c\u8d26\u9f84\u8ba1\u7b97\u65e5\u671f\u201d\u5fc5\u9009\u3002", (String)"MaturityLiabForm_8", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
            if (!keyCols.contains("bizdate")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u4f9d\u636e\u201d\u4e2d\u9009\u9879\u201c\u5355\u636e\u65e5\u671f\u201d\u5fc5\u9009\u3002", (String)"MaturityLiabForm_9", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
            if (!keyCols.contains("planseq")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u4f9d\u636e\u201d\u4e2d\u9009\u9879\u201c\u8ba1\u5212\u884c\u884c\u53f7\u201d\u5fc5\u9009\u3002", (String)"MaturityLiabForm_10", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
            if (!keyCols.contains("billno")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u4f9d\u636e\u201d\u4e2d\u9009\u9879\u201c\u5355\u636e\u7f16\u53f7\u201d\u5fc5\u9009\u3002", (String)"MaturityLiabForm_11", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.resetFilterGrid();
    }

    private void resetFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        for (Map info : filterColumns) {
            String fieldName = (String)info.get("fieldName");
            if (!this.filterGrid(fieldName)) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
    }

    private boolean filterGrid(String fieldName) {
        String[] split = fieldName.split("\\.");
        HashSet<String> removedPros = new HashSet<String>(32);
        removedPros.add("org");
        removedPros.add("asstacttype");
        removedPros.add("asstact");
        removedPros.add("currency");
        removedPros.add("billtype");
        removedPros.add("billstatus");
        removedPros.add("bizdate");
        removedPros.add("comparedate");
        removedPros.add("remark");
        removedPros.add("pricetaxtotal");
        removedPros.add("unsettleamount");
        removedPros.add("lockedamt");
        removedPros.add("settledamt");
        removedPros.add("topayamt");
        removedPros.add("duedays");
        removedPros.add("isperiod");
        removedPros.add("id");
        removedPros.add("entryid");
        removedPros.add("planseq");
        return !removedPros.contains(split[0]);
    }
}

