/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.mlv2;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.metadata.entity.report.ReportColumnFactory;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.bplat.scmc.report.core.transform.plan.GroupPlan;
import kd.fi.arapcommon.report.acctagev2.transform.AsstactTransfer;
import kd.fi.arapcommon.report.mlv2.MaturityLiabParam;
import kd.fi.arapcommon.report.mlv2.transform.CalculateShowColumns;
import kd.fi.arapcommon.report.mlv2.transform.SortResults;
import kd.fi.arapcommon.util.EmptyUtils;

public class MaturityLiabHandle
implements IReportDataHandle {
    private MaturityLiabParam reportParam;

    public void setupCtx(ReportDataCtx ctx) {
        this.reportParam = (MaturityLiabParam)ctx.getParam(MaturityLiabParam.class.getName());
        ctx.setShowBlockEntity(false);
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getBaseFilter());
        } else {
            fixedFs.addAll(this.getBaseFilter());
        }
    }

    private List<QFilter> getBaseFilter() {
        List<Long> currencyIds;
        LinkedList<QFilter> filters = new LinkedList<QFilter>();
        QFilter orgFilter = new QFilter("org", "in", this.reportParam.getOrgIds());
        filters.add(orgFilter);
        if (!EmptyUtils.isEmpty(this.reportParam.getAsstactType())) {
            QFilter asstactTypeFilter = new QFilter("asstacttype", "=", (Object)this.reportParam.getAsstactType());
            filters.add(asstactTypeFilter);
        } else {
            filters.add(new QFilter("asstacttype", "in", Arrays.asList("bd_supplier", "bd_customer", "bos_user")));
        }
        List<Object> asstactIds = this.reportParam.getAsstactIds();
        if (!EmptyUtils.isEmpty(asstactIds)) {
            QFilter asstactFilter = new QFilter("asstact", "in", asstactIds);
            filters.add(asstactFilter);
        }
        if (!EmptyUtils.isEmpty(currencyIds = this.reportParam.getCurrencyIds())) {
            QFilter currencyFilter = new QFilter("currency", "in", currencyIds);
            filters.add(currencyFilter);
        }
        boolean containsUnaudit = this.reportParam.isContainsUnaudit();
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        if (containsUnaudit) {
            billStatusFilter = new QFilter("billstatus", "in", (Object)new String[]{"B", "C"});
        }
        filters.add(billStatusFilter);
        Date date = this.reportParam.getQueryDate();
        if (date != null) {
            QFilter queryDateFilter = new QFilter(this.reportParam.getStandard(), "<", (Object)date);
            filters.add(queryDateFilter);
        }
        QFilter settleStatusFilter = new QFilter("settlestatus", "in", (Object)new String[]{"unsettle", "partsettle"});
        filters.add(settleStatusFilter);
        QFilter priceTaxTotalFilter = new QFilter("pricetaxtotal", "<>", (Object)BigDecimal.ZERO);
        filters.add(priceTaxTotalFilter);
        return filters;
    }

    public void modifyBlocks(List<SrcBlockConf> srcBlockConfs, ReportDataCtx ctx) {
        for (SrcBlockConf blockConf : srcBlockConfs) {
            if (!"ap_finapbill".equals(blockConf.getSrcEntity())) continue;
            blockConf.setAllowNotMatch(true);
            Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
            String standard = this.reportParam.getStandard();
            repoColFullSrcColMap.put(this.reportParam.getStandard(), "planduedate".equals(standard) ? "planentity." + standard : standard);
            repoColFullSrcColMap.put("settlestatus", "settlestatus");
        }
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("id");
        repoColFilter.add("entryid");
        repoColFilter.add("comparedate");
        repoColFilter.add("lockedamt");
        repoColFilter.add("settledamt");
        repoColFilter.add("isperiod");
    }

    public void handleBlockDataSelectCols(Set<String> repoColFilter, SrcBlockConf blockConf, ReportDataCtx ctx) {
        Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
        repoColFullSrcColMap.put("id", "id");
        repoColFullSrcColMap.put("entryid", "planentity.id");
        String standard = this.reportParam.getStandard();
        repoColFullSrcColMap.put("comparedate", "planduedate".equals(standard) ? "planentity." + standard : standard);
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new CalculateShowColumns("planduedate".equals(this.reportParam.getStandard())));
        transCollector.add(new AsstactTransfer());
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        GroupPlan groupPlan = ctx.getGroupPlan();
        Collection keyCols = groupPlan.getKeyCols();
        keyCols.add("id");
        if ("planduedate".equals(this.reportParam.getStandard())) {
            keyCols.add("entryid");
        }
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new SortResults());
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        ArrayList<AbstractReportColumn> showCols = new ArrayList<AbstractReportColumn>(8);
        String standard = this.reportParam.getStandard();
        for (AbstractReportColumn col : cols) {
            ReportColumn column = (ReportColumn)col;
            String fieldKey = column.getFieldKey();
            if ("comparedate".equals(fieldKey)) {
                if ("bizdate".equals(standard)) continue;
                LocaleString caption = new LocaleString(ResManager.loadKDString((String)"\u5355\u636e\u5934\u5230\u671f\u65e5", (String)"MaturityLiabHandle_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                if ("planduedate".equals(standard)) {
                    caption = new LocaleString(ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5230\u671f\u65e5", (String)"MaturityLiabHandle_2", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                column.setCaption(caption);
                column.setFieldType("date");
                showCols.add(col);
                continue;
            }
            if ("planseq".equals(fieldKey)) {
                if (!"planduedate".equals(standard)) continue;
                showCols.add(col);
                continue;
            }
            if ("remark".equals(fieldKey)) {
                ReportColumn dueDaysColumn = ReportColumnFactory.createTextColumn((LocaleString)new LocaleString(ResManager.loadKDString((String)"\u8fc7\u671f\u5929\u6570", (String)"MaturityLiabHandle_1", (String)"fi-arapcommon", (Object[])new Object[0])), (String)"duedays");
                showCols.add((AbstractReportColumn)dueDaysColumn);
                showCols.add(col);
                continue;
            }
            showCols.add(col);
        }
        return showCols;
    }
}

