/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.sumv2.transform;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FilterFunction;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.util.TransformUtil;
import kd.fi.arapcommon.report.sumv2.transform.func.JournalFilterFunc;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.vo.SumRptParam;

public class RemoveRefundantJournal
implements IDataXTransform {
    private SumRptParam param;

    public RemoveRefundantJournal(SumRptParam param) {
        this.param = param;
    }

    public DataSetX doTransform(DataSetX srcData) {
        Map<Long, Map<Long, Date>> closeInfoMap = this.param.getCloseInfoMap();
        HashMap<Long, Date> closeMap = new HashMap<Long, Date>(closeInfoMap.size());
        for (Map.Entry<Long, Map<Long, Date>> entry : closeInfoMap.entrySet()) {
            Long orgId = entry.getKey();
            Map<Long, Date> value = entry.getValue();
            for (Map.Entry<Long, Date> closeInfoValue : value.entrySet()) {
                Date closeDate = closeInfoValue.getValue();
                closeDate = DateUtils.getDataFormat(closeDate, false);
                closeMap.put(orgId, closeDate);
            }
        }
        ArrayList<String> columns = new ArrayList<String>(2);
        columns.add("org");
        columns.add("bizdate");
        columns.add("entitykey");
        Map indexs = TransformUtil.buildIndexs((RowMeta)srcData.getRowMeta(), columns);
        return srcData.filter((FilterFunction)new JournalFilterFunc(closeMap, indexs));
    }
}

