/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.ext.fi.aef.GetBizBillInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.business.piaozone.info.InvoiceVO;
import kd.fi.arapcommon.enums.APSettleStatusEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.invcloud.CallCloudHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.StringUtils;

public class ApGetBizBillInfoImpl
implements GetBizBillInfo {
    private static final Log logger = LogFactory.getLog(ApGetBizBillInfoImpl.class);

    public Map<Long, List<JSONObject>> getBizBillTicketList(String billType, Set<Long> billIds) {
        logger.info("ap_param-billType:" + billType + " billIds:" + billIds);
        if (StringUtils.isEmpty(billType) || ObjectUtils.isEmpty(billIds)) {
            return null;
        }
        HashMap<Long, List<JSONObject>> result = new HashMap<Long, List<JSONObject>>(billIds.size());
        String selectors = "org,billtypeid,settlestatus,i_invoicetype,i_invoicecode,i_invoiceno,i_serialno,i_invoicedate,i_pricetaxtotal,i_currency,i_asstactname,i_istaxdeduction,detailentry.id";
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        if (bills.length == 0) {
            return result;
        }
        List<DynamicObject> relateInvoiceBills = Arrays.stream(bills).filter(apBill -> apBill.getDynamicObjectCollection("inventry").size() > 0).collect(Collectors.toList());
        logger.info("ap_relateInvoiceBills:" + relateInvoiceBills.size());
        if (!relateInvoiceBills.isEmpty()) {
            HashSet<Long> billIdSet = new HashSet<Long>(8);
            HashSet<Long> billEntryIdSet = new HashSet<Long>(8);
            for (DynamicObject relateInvoiceBill : relateInvoiceBills) {
                long billId = relateInvoiceBill.getLong("id");
                billIdSet.add(billId);
                DynamicObjectCollection entryColl = relateInvoiceBill.getDynamicObjectCollection("detailentry");
                for (DynamicObject entry : entryColl) {
                    long billEntryId = entry.getLong("id");
                    billEntryIdSet.add(billEntryId);
                }
            }
            Map<Long, List<String>> contractInfoMap = this.getContractInfoMap(billIdSet, billEntryIdSet);
            Map<Long, String> faInfoMap = this.getFaInfoMap(relateInvoiceBills);
            Map<String, String> invoiceTypeMap = this.getInvoiceTypeMap();
            for (DynamicObject bill : relateInvoiceBills) {
                List<String> contractList = contractInfoMap.get(bill.getLong("id"));
                String faInfo = faInfoMap.get(bill.getLong("id"));
                String settleStatus = bill.getString("settlestatus");
                DynamicObjectCollection inventries = bill.getDynamicObjectCollection("inventry");
                ArrayList<JSONObject> billInvoiceList = new ArrayList<JSONObject>(inventries.size());
                for (DynamicObject inventry : inventries) {
                    String type;
                    String invoiceCode = inventry.getString("i_invoicecode");
                    String invoiceNo = inventry.getString("i_invoiceno");
                    String invoicetype = inventry.getString("i_invoicetype");
                    if (StringUtils.isEmpty(invoicetype) || (type = invoiceTypeMap.get(invoicetype)) == null) continue;
                    String invoiceDate = DateUtils.formatString(inventry.getDate("i_invoicedate"), "yyyy-MM-dd");
                    JSONObject invoiceJson = new JSONObject();
                    invoiceJson.put("costcompany", (Object)bill.getLong("org.id"));
                    String isPaid = APSettleStatusEnum.SETTLED.getValue().equals(settleStatus) ? "true" : "false";
                    invoiceJson.put("WhetherInvoiceHasBeenPaid", (Object)isPaid);
                    invoiceJson.put("WhetherEinvoiceHasBeenPaid", (Object)isPaid);
                    invoiceJson.put("tickettype", (Object)type);
                    invoiceJson.put("seqNo", (Object)inventry.getString("i_serialno"));
                    invoiceJson.put("UniqueCodeOfInvoice", (Object)(!StringUtils.isEmpty(invoiceCode) && !StringUtils.isEmpty(invoiceNo) ? invoiceCode + invoiceNo : ""));
                    invoiceJson.put("ContractNumber", (Object)(contractList == null || contractList.isEmpty() ? "" : String.join((CharSequence)",", contractList)));
                    invoiceJson.put("MatchingStateBetweenBusinessDocumentsAndVatEInvoice", (Object)(StringUtils.isEmpty(invoiceCode) || StringUtils.isEmpty(invoiceNo) ? "false" : "true"));
                    invoiceJson.put("DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets", (Object)faInfo);
                    invoiceJson.put("BILL_DATE", (Object)invoiceDate);
                    invoiceJson.put("PAID_AMT", (Object)inventry.getBigDecimal("i_pricetaxtotal"));
                    invoiceJson.put("ElectronicInvoiceAirTransportReceiptNumber", (Object)invoiceNo);
                    invoiceJson.put("InvoiceNumber", (Object)invoiceNo);
                    invoiceJson.put("ElectronicInvoiceRailwayETicketNumber", (Object)invoiceNo);
                    StringBuilder builder = new StringBuilder(invoiceCode);
                    builder.append('+');
                    builder.append(invoiceNo);
                    invoiceJson.put("EInvoiceID", (Object)builder.reverse().toString());
                    builder = new StringBuilder(invoiceCode);
                    builder.append('-');
                    builder.append(invoiceNo);
                    invoiceJson.put("EINVOICE_ID", (Object)builder.reverse().toString());
                    invoiceJson.put("WhetherInvoiceHasBeenChecked", (Object)"true");
                    invoiceJson.put("WhetherInvoiceIsRedInvoice", (Object)(inventry.getBigDecimal("i_pricetaxtotal").signum() < 0 ? "true" : "false"));
                    billInvoiceList.add(invoiceJson);
                }
                if (billInvoiceList.isEmpty()) continue;
                result.put(bill.getLong("id"), billInvoiceList);
            }
        }
        this.getXbrlUrl(result);
        logger.info("ap_getBizBillTicketList-result:" + result);
        return result;
    }

    private void getXbrlUrl(Map<Long, List<JSONObject>> result) {
        if (result == null || result.size() == 0) {
            return;
        }
        Set<Long> billIdSet = result.keySet();
        DataSet finApDataSet = QueryServiceHelper.queryDataSet((String)"addXbrlUrl", (String)"ap_finapbill", (String)"id,org,inventry.i_serialno", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)}, (String)"");
        HashMap<Long, Set> tempOrgForSerialMap = new HashMap<Long, Set>(8);
        for (Object row : finApDataSet) {
            String string = row.getString("inventry.i_serialno");
            Long orgId = row.getLong("org");
            Set serialNos = tempOrgForSerialMap.getOrDefault(orgId, new HashSet(8));
            serialNos.add(string);
            tempOrgForSerialMap.put(orgId, serialNos);
        }
        logger.info("getXbrlUrl tempOrgForSerialMap:" + tempOrgForSerialMap);
        if (tempOrgForSerialMap.isEmpty()) {
            return;
        }
        HashMap<Long, String> orgForSerialMap = new HashMap<Long, String>(tempOrgForSerialMap.size());
        for (Map.Entry entry : tempOrgForSerialMap.entrySet()) {
            orgForSerialMap.put((Long)entry.getKey(), String.join((CharSequence)",", (Iterable)entry.getValue()));
        }
        List<InvoiceVO> invoiceVOS = CallCloudHelper.queryCloudInvoice(orgForSerialMap);
        Map map = invoiceVOS.stream().collect(Collectors.toMap(InvoiceVO::getSerialNo, Function.identity()));
        for (Map.Entry<Long, List<JSONObject>> entry : result.entrySet()) {
            List<JSONObject> invoiceJsonList = entry.getValue();
            for (JSONObject invoiceJson : invoiceJsonList) {
                String seqNo = (String)invoiceJson.get((Object)"seqNo");
                InvoiceVO invoiceVO = (InvoiceVO)map.get(seqNo);
                if (invoiceVO == null) continue;
                String xbrlUrl = invoiceVO.getXbrlUrl();
                invoiceJson.put("xbrlUrl", (Object)xbrlUrl);
                String type = invoiceVO.getType();
                invoiceJson.put("WhetherInvoiceIsRedInvoice", (Object)("1".equals(type) ? "true" : "false"));
            }
        }
    }

    private Map<Long, List<String>> getContractInfoMap(Set<Long> billIdSet, Set<Long> billEntryIdSet) {
        HashMap<Long, List<String>> contractInfoMap = new HashMap<Long, List<String>>(billIdSet.size());
        Map<Long, List<Long>> sourceBillMap = BOTPHelper.loadNearUpBillIds("ap_finapbill", "detailentry", billIdSet.toArray(new Long[0]), billEntryIdSet.toArray(new Long[0]), "conm_purcontract");
        if (sourceBillMap != null && sourceBillMap.size() > 0) {
            ArrayList contractIdList = new ArrayList();
            for (Map.Entry<Long, List<Long>> entry : sourceBillMap.entrySet()) {
                contractIdList.addAll(entry.getValue());
            }
            DataSet contractDataSet = QueryServiceHelper.queryDataSet((String)"querycontract", (String)"conm_purcontract", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", contractIdList)}, (String)"");
            HashMap<Long, String> contractBillnoMap = new HashMap<Long, String>(contractIdList.size());
            for (Row row : contractDataSet) {
                contractBillnoMap.put(row.getLong("id"), row.getString("billno"));
            }
            for (Map.Entry<Long, List<Long>> entry : sourceBillMap.entrySet()) {
                Long billId = entry.getKey();
                List<Long> contractBillIds = entry.getValue();
                ArrayList contractBillNos = new ArrayList(contractBillIds.size());
                for (Long contractBillId : contractBillIds) {
                    contractBillNos.add(contractBillnoMap.get(contractBillId));
                }
                contractInfoMap.put(billId, contractBillNos);
            }
        }
        logger.info("ap_contractInfoMap:" + contractInfoMap);
        return contractInfoMap;
    }

    private Map<Long, String> getFaInfoMap(List<DynamicObject> relateInvoiceBills) {
        HashMap<Long, String> faInfoMap = new HashMap<Long, String>(8);
        List assetBills = relateInvoiceBills.stream().filter(bill -> "ap_finapbill_asset_BT_S".equals(bill.getString("billtypeid.number"))).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(assetBills)) {
            HashSet<Long> billIdSet = new HashSet<Long>(8);
            HashSet<Long> billEntryIdSet = new HashSet<Long>(8);
            for (DynamicObject asstBill : assetBills) {
                long billId = asstBill.getLong("id");
                billIdSet.add(billId);
                DynamicObjectCollection entryColl = asstBill.getDynamicObjectCollection("detailentry");
                Iterator iterator = entryColl.iterator();
                while (iterator.hasNext()) {
                    DynamicObject entry = (DynamicObject)iterator.next();
                    long billEntryId = entry.getLong("id");
                    billEntryIdSet.add(billEntryId);
                }
            }
            Map<Long, List<Long>> sourceBillMap = BOTPHelper.loadNearUpBillIds("ap_finapbill", "detailentry", billIdSet.toArray(new Long[0]), billEntryIdSet.toArray(new Long[0]), "im_purreceivebill");
            if (!sourceBillMap.isEmpty()) {
                ArrayList purreceiveIdList = new ArrayList();
                for (Map.Entry<Long, List<Long>> entry : sourceBillMap.entrySet()) {
                    purreceiveIdList.addAll(entry.getValue());
                }
                Map<Long, List<Long>> faCardMap = BOTPHelper.loadNearTarBillIds("im_purreceivebill", "fa_card_fin", purreceiveIdList.toArray(new Long[0]));
                if (!faCardMap.isEmpty()) {
                    ArrayList faCardIdList = new ArrayList();
                    for (Map.Entry entry : faCardMap.entrySet()) {
                        faCardIdList.addAll((Collection)entry.getValue());
                    }
                    DataSet faCardData = QueryServiceHelper.queryDataSet((String)"queryFaCard", (String)"fa_card_fin", (String)"id,depremethod.name", (QFilter[])new QFilter[]{new QFilter("id", "in", faCardIdList)}, (String)"");
                    HashMap<Long, String> hashMap = new HashMap<Long, String>(faCardIdList.size());
                    for (Row row : faCardData) {
                        hashMap.put(row.getLong("id"), row.getString("depremethod.name"));
                    }
                    block5: for (Map.Entry<Long, List<Long>> entry : sourceBillMap.entrySet()) {
                        Long apBillId = entry.getKey();
                        List<Long> purreceiveIdValue = entry.getValue();
                        for (Long purreceiveId : purreceiveIdValue) {
                            List<Long> faCardIdValue = faCardMap.get(purreceiveId);
                            for (Long faCardId : faCardIdValue) {
                                String depremethod = (String)hashMap.get(faCardId);
                                if (StringUtils.isEmpty(depremethod)) continue;
                                faInfoMap.put(apBillId, depremethod);
                                continue block5;
                            }
                        }
                    }
                }
            }
        }
        logger.info("ap_faInfoMap:" + faInfoMap);
        return faInfoMap;
    }

    private Map<String, String> getInvoiceTypeMap() {
        HashMap<String, String> invoiceTypeMap = new HashMap<String, String>(8);
        invoiceTypeMap.put("ELE", "inv_ord_receiver");
        invoiceTypeMap.put("SE", "inv_spcl_receiver");
        invoiceTypeMap.put("TRAIN", "rai_receiver");
        invoiceTypeMap.put("PLANE", "atr_receiver");
        invoiceTypeMap.put("TOLL", "inv_tlf_receiver");
        invoiceTypeMap.put("NOELETIC", "einv_ord_receiver");
        invoiceTypeMap.put("MAELETIC", "einv_spcl_receiver");
        invoiceTypeMap.put("FINE", "efi");
        return invoiceTypeMap;
    }
}

