/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.helper.ArApResetOrgIdEventHelper;

public class ArApResetOrgIdEventServicePlugin
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(ArApResetOrgIdEventServicePlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        String variableStr = evt.getVariables();
        logger.info("ArApResetOrgIdEventServicePlugin.variableStr:" + variableStr);
        JSONObject variables = (JSONObject)SerializationUtils.fromJsonString((String)variableStr, JSONObject.class);
        JSONObject operationParams = variables.getJSONObject("base_orgchange_resetroot");
        JSONArray viewArray = operationParams.getJSONArray("synviews");
        if (viewArray != null && !viewArray.isEmpty()) {
            this.handlePreData(viewArray);
        }
        return evt.getEventId();
    }

    private void handlePreData(JSONArray viewArray) {
        Map<String, Set<String>> baseDataNameAndDBRoot = ArApResetOrgIdEventHelper.getBaseDataNameAndDBRoot(true);
        Set<String> baseDataNameSet = baseDataNameAndDBRoot.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Map<Long, Set<String>> baseDataViewMap = ArApResetOrgIdEventHelper.getBaseDataView(baseDataNameSet);
        Map<Long, Long> rootOrgIdMap = this.getViewAndRootOrgIdMap(viewArray, baseDataViewMap.keySet());
        HashMap<String, Long> entityAndRootId = new HashMap<String, Long>(8);
        HashSet<String> noChangeEntitySet = new HashSet<String>(8);
        for (Map.Entry<Long, Set<String>> entry : baseDataViewMap.entrySet()) {
            Long viewId = entry.getKey();
            Long rootOrgId = rootOrgIdMap.get(viewId);
            Set<String> entitySet = entry.getValue();
            if (rootOrgId == null || rootOrgId == 0L) {
                noChangeEntitySet.addAll(entitySet);
                continue;
            }
            for (String entityName : entitySet) {
                entityAndRootId.put(entityName, rootOrgId);
            }
        }
        for (Set set : baseDataNameAndDBRoot.values()) {
            set.removeAll(noChangeEntitySet);
        }
        for (Map.Entry entry : baseDataNameAndDBRoot.entrySet()) {
            String dbKey = (String)entry.getKey();
            Set entities = (Set)entry.getValue();
            ArApResetOrgIdEventHelper.excuteResetOrgId(dbKey, entities, entityAndRootId, true);
        }
    }

    private Map<Long, Long> getViewAndRootOrgIdMap(JSONArray viewArray, Set<Long> baseDataViewSet) {
        HashMap<Long, Long> rootOrgIdMap = new HashMap<Long, Long>(8);
        for (Object viewMap : viewArray) {
            JSONObject viewObj = (JSONObject)viewMap;
            Long newRootId = Long.parseLong(viewObj.getString("newrootid"));
            Long viewId = Long.parseLong(viewObj.getString("viewid"));
            if (!baseDataViewSet.contains(viewId)) continue;
            rootOrgIdMap.put(viewId, newRootId);
        }
        return rootOrgIdMap;
    }
}

