/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.ext.fi.aef.GetBizBillInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.util.StringUtils;

public class ArGetBizBillInfoImpl
implements GetBizBillInfo {
    private static Log logger = LogFactory.getLog(ArGetBizBillInfoImpl.class);

    public Map<Long, List<JSONObject>> getBizBillTicketList(String billType, Set<Long> billIds) {
        logger.info("ar_param-billType:" + billType + " billIds:" + billIds);
        HashMap<Long, List<JSONObject>> result = new HashMap<Long, List<JSONObject>>(billIds.size());
        if (StringUtils.isEmpty(billType) || ObjectUtils.isEmpty(billIds)) {
            return result;
        }
        Map<Long, List<Long>> tarInvoiceMap = BOTPHelper.loadNearTarBillIds("ar_finarbill", "sim_vatinvoice", billIds.toArray(new Long[0]));
        if (tarInvoiceMap != null && tarInvoiceMap.size() > 0) {
            Map<Long, List<String>> contractInfoMap = this.getContractInfoMap(billIds);
            Map<String, String> invoiceTypeMap = this.getInvoiceTypeMap();
            ArrayList tarInvoiceIdList = new ArrayList(10);
            for (Map.Entry<Long, List<Long>> entry : tarInvoiceMap.entrySet()) {
                tarInvoiceIdList.addAll(entry.getValue());
            }
            DataSet vatinvoiceDataSet = QueryServiceHelper.queryDataSet((String)"querysim_vatinvoice", (String)"sim_vatinvoice", (String)"id,invoicecode,invoiceno,invoicetype,orderno", (QFilter[])new QFilter[]{new QFilter("id", "in", tarInvoiceIdList)}, (String)"");
            HashMap vatinvoiceMap = new HashMap(tarInvoiceIdList.size());
            for (Row row : vatinvoiceDataSet) {
                HashMap<String, String> propMap = new HashMap<String, String>(4);
                propMap.put("invoicecode", row.getString("invoicecode"));
                propMap.put("invoiceno", row.getString("invoiceno"));
                propMap.put("serialno", row.getString("orderno"));
                propMap.put("invoicetype", row.getString("invoicetype"));
                vatinvoiceMap.put(row.getLong("id"), propMap);
            }
            logger.info("vatinvoiceMap:" + vatinvoiceMap);
            if (vatinvoiceMap.isEmpty()) {
                return result;
            }
            for (Map.Entry<Long, List<Long>> entry : tarInvoiceMap.entrySet()) {
                Long billId = entry.getKey();
                List<Long> vatinvoiceIds = entry.getValue();
                List<String> contractList = contractInfoMap.get(billId);
                ArrayList<JSONObject> invoiceJsonList = new ArrayList<JSONObject>(vatinvoiceIds.size());
                for (Long vatinvoiceId : vatinvoiceIds) {
                    String type;
                    String invoicetype;
                    Map propMap = (Map)vatinvoiceMap.get(vatinvoiceId);
                    if (propMap == null || StringUtils.isEmpty(invoicetype = (String)propMap.get("invoicetype")) || (type = invoiceTypeMap.get(invoicetype)) == null) continue;
                    JSONObject invoiceJson = new JSONObject();
                    invoiceJson.put("tickettype", (Object)type);
                    invoiceJson.put("UniqueCodeOfInvoice", propMap.get("serialno"));
                    invoiceJson.put("ContractNumber", (Object)(contractList == null || contractList.isEmpty() ? "" : String.join((CharSequence)",", contractList)));
                    invoiceJson.put("MatchingStateBetweenBusinessDocumentsAndVatEInvoice", (Object)(StringUtils.isEmpty((String)propMap.get("invoicecode")) || StringUtils.isEmpty((String)propMap.get("invoiceno")) ? "false" : "true"));
                    invoiceJsonList.add(invoiceJson);
                }
                if (invoiceJsonList.isEmpty()) continue;
                result.put(billId, invoiceJsonList);
            }
        }
        logger.info("ar_getBizBillTicketList-result:" + result);
        return result;
    }

    private Map<Long, List<String>> getContractInfoMap(Set<Long> ids) {
        HashMap<Long, List<String>> contractInfoMap = new HashMap<Long, List<String>>(8);
        Map<Long, List<Long>> sourceBillMap = BOTPHelper.loadNearUpBillIds("ar_finarbill", "conm_salcontract", ids.toArray(new Long[0]));
        if (sourceBillMap != null && sourceBillMap.size() > 0) {
            ArrayList contractIdList = new ArrayList();
            for (Map.Entry<Long, List<Long>> entry : sourceBillMap.entrySet()) {
                contractIdList.addAll(entry.getValue());
            }
            DataSet contractDatsSet = QueryServiceHelper.queryDataSet((String)"querycontract", (String)"conm_salcontract", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", contractIdList)}, (String)"");
            HashMap<Long, String> contractBillnoMap = new HashMap<Long, String>(contractIdList.size());
            for (Row row : contractDatsSet) {
                contractBillnoMap.put(row.getLong("id"), row.getString("billno"));
            }
            for (Map.Entry<Long, List<Long>> entry : sourceBillMap.entrySet()) {
                Long billId = entry.getKey();
                List<Long> contractBillIds = entry.getValue();
                ArrayList contractBillNos = new ArrayList(contractBillIds.size());
                for (Long contractBillId : contractBillIds) {
                    contractBillNos.add(contractBillnoMap.get(contractBillId));
                }
                contractInfoMap.put(billId, contractBillNos);
            }
        }
        logger.info("ar_contractInfoMap:" + contractInfoMap);
        return contractInfoMap;
    }

    private Map<String, String> getInvoiceTypeMap() {
        HashMap<String, String> invoiceTypeMap = new HashMap<String, String>(8);
        invoiceTypeMap.put("026", "inv_ord_receiver");
        invoiceTypeMap.put("028", "inv_spcl_receiver");
        invoiceTypeMap.put("TRAIN", "rai_receiver");
        invoiceTypeMap.put("PLANE", "atr_receiver");
        invoiceTypeMap.put("TOLL", "inv_tlf_receiver");
        return invoiceTypeMap;
    }
}

