/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.arapcommon.util.QueryUtil;
import kd.fi.arapcommon.util.StdConfig;

public class BOTPRelationReaderService {
    private static final Log logger = LogFactory.getLog(BOTPRelationReaderService.class);
    private static int MAX_QUERY_TIMES = 50;
    private static final int MAX_RECURSION_TIMES = 100;
    private final QueryUtil queryUtil = new QueryUtil();

    public BOTPRelationReaderService() {
        String maxQueryTimes = StdConfig.get("botpGraduallyQueryTimes");
        if (!ObjectUtils.isEmpty((Object)maxQueryTimes)) {
            MAX_QUERY_TIMES = Integer.parseInt(maxQueryTimes);
        }
    }

    public Map<Long, List<Long>> loadNearSourceIds(String entityNumber, String entryKey, Long[] billIds, Long[] entryIds, String assignEntityName, boolean isRow) {
        long begin = System.currentTimeMillis();
        HashMap<Long, List<Long>> relationMap = new HashMap<Long, List<Long>>(64);
        HashMap<Long, BFRowId> needAgainQueryMap = new HashMap<Long, BFRowId>(64);
        OperateOption option = OperateOption.create();
        option.setVariableValue("botp_track_only_dirt_link", "true");
        List directBfRows = BFTrackerServiceHelper.loadSourceRowIds((String)entityNumber, (String)entryKey, (Long[])billIds, (Long[])entryIds, (OperateOption)option);
        ConvertDataService reader = new ConvertDataService();
        TableDefine sourceMainTableDefine = reader.loadTableDefine(assignEntityName, assignEntityName);
        long assignMainTableId = sourceMainTableDefine.getTableId();
        HashMap<Long, Long> entry4BillIdMap = new HashMap<Long, Long>(32);
        for (BFRow bfRow : directBfRows) {
            BFRowId rowId = bfRow.getId();
            BFRowId sId = bfRow.getSId();
            if (sId.getMainTableId().equals(assignMainTableId)) {
                Long key = isRow ? rowId.getEntryId() : rowId.getBillId();
                Long value = isRow ? sId.getEntryId() : sId.getBillId();
                List sourceIds = relationMap.getOrDefault(key, new ArrayList(8));
                sourceIds.add(value);
                relationMap.put(key, sourceIds);
                continue;
            }
            needAgainQueryMap.put(rowId.getEntryId(), sId);
            entry4BillIdMap.put(rowId.getEntryId(), rowId.getBillId());
        }
        if (needAgainQueryMap.isEmpty()) {
            return relationMap;
        }
        for (int i = 0; i < MAX_QUERY_TIMES; ++i) {
            List sameEntryBfRowIds;
            Object bfRowId2;
            HashMap<String, List> groupByEntryNameMap = new HashMap<String, List>(16);
            for (Object bfRowId2 : needAgainQueryMap.values()) {
                String mainName = this.queryUtil.getEntityNameByMainTableId(bfRowId2.getMainTableId());
                String entryName = this.queryUtil.getEntityNameByMainTableId(bfRowId2.getTableId());
                String key = mainName + "-" + entryName;
                sameEntryBfRowIds = groupByEntryNameMap.getOrDefault(key, new ArrayList(64));
                sameEntryBfRowIds.add(bfRowId2);
                groupByEntryNameMap.put(key, sameEntryBfRowIds);
            }
            HashMap<Long, BFRowId> tempRelationMap = new HashMap<Long, BFRowId>(64);
            bfRowId2 = groupByEntryNameMap.entrySet().iterator();
            while (bfRowId2.hasNext()) {
                Map.Entry entrySet = (Map.Entry)bfRowId2.next();
                String key = (String)entrySet.getKey();
                String[] split = key.split("-");
                sameEntryBfRowIds = (List)entrySet.getValue();
                HashSet<Long> tempBillIds = new HashSet<Long>(64);
                ArrayList<Long> tempRowIds = new ArrayList<Long>(64);
                for (BFRowId bfRowId3 : sameEntryBfRowIds) {
                    tempBillIds.add(bfRowId3.getBillId());
                    tempRowIds.add(bfRowId3.getEntryId());
                }
                List tempDirectBfRows = BFTrackerServiceHelper.loadSourceRowIds((String)split[0], (String)split[1], (Long[])tempBillIds.toArray(new Long[0]), (Long[])tempRowIds.toArray(new Long[0]), (OperateOption)option);
                for (BFRow directBfRow : tempDirectBfRows) {
                    tempRelationMap.put(directBfRow.getId().getEntryId(), directBfRow.getSId());
                }
            }
            Iterator iterator = needAgainQueryMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                Long entryId = (Long)next.getKey();
                BFRowId srcBfRowId = (BFRowId)next.getValue();
                BFRowId ssrcBfRowId = (BFRowId)tempRelationMap.get(srcBfRowId.getEntryId());
                if (ssrcBfRowId == null) {
                    iterator.remove();
                    continue;
                }
                if (ssrcBfRowId.getMainTableId().equals(assignMainTableId)) {
                    Long key = isRow ? entryId : (Long)entry4BillIdMap.get(entryId);
                    Long value = isRow ? ssrcBfRowId.getEntryId() : ssrcBfRowId.getBillId();
                    List sourceBillIds = relationMap.getOrDefault(key, new ArrayList(8));
                    sourceBillIds.add(value);
                    relationMap.put(key, sourceBillIds);
                    iterator.remove();
                    continue;
                }
                needAgainQueryMap.put(entryId, ssrcBfRowId);
            }
            if (needAgainQueryMap.isEmpty()) break;
        }
        logger.info("BOTPRelationReaderService loadNearSourceIds cost time is :" + (System.currentTimeMillis() - begin));
        return relationMap;
    }

    public Map<Long, List<Long>> loadNearTargetIds(String entityNumber, String entryKey, Long[] billIds, Long[] entryIds, String assignEntityName, boolean isRow) {
        long begin = System.currentTimeMillis();
        HashMap<Long, List<Long>> relationMap = new HashMap<Long, List<Long>>(64);
        HashMap<Long, BFRowId> needAgainQueryMap = new HashMap<Long, BFRowId>(64);
        OperateOption option = OperateOption.create();
        option.setVariableValue("botp_track_only_dirt_link", "true");
        List directBfRows = BFTrackerServiceHelper.loadTargetRowIds((String)entityNumber, (String)entryKey, (Long[])billIds, (Long[])entryIds, (OperateOption)option);
        ConvertDataService reader = new ConvertDataService();
        TableDefine sourceMainTableDefine = reader.loadTableDefine(assignEntityName, assignEntityName);
        long assignMainTableId = sourceMainTableDefine.getTableId();
        HashMap<Long, Long> entry4BillIdMap = new HashMap<Long, Long>(32);
        for (BFRow bfRow : directBfRows) {
            BFRowId rowId = bfRow.getId();
            BFRowId sId = bfRow.getSId();
            if (rowId.getMainTableId().equals(assignMainTableId)) {
                Long key = isRow ? sId.getEntryId() : sId.getBillId();
                Long value = isRow ? rowId.getEntryId() : rowId.getBillId();
                List targetIds = relationMap.getOrDefault(key, new ArrayList(8));
                targetIds.add(value);
                relationMap.put(key, targetIds);
                continue;
            }
            needAgainQueryMap.put(rowId.getEntryId(), sId);
            entry4BillIdMap.put(sId.getEntryId(), sId.getBillId());
        }
        if (needAgainQueryMap.isEmpty()) {
            return relationMap;
        }
        for (int i = 0; i < MAX_QUERY_TIMES; ++i) {
            List sameEntryBfRowIds;
            Object bfRowId2;
            HashMap<String, List> groupByEntryNameMap = new HashMap<String, List>(16);
            for (Object bfRowId2 : needAgainQueryMap.values()) {
                String mainName = this.queryUtil.getEntityNameByMainTableId(bfRowId2.getMainTableId());
                String entryName = this.queryUtil.getEntityNameByMainTableId(bfRowId2.getTableId());
                String key = mainName + "-" + entryName;
                sameEntryBfRowIds = groupByEntryNameMap.getOrDefault(key, new ArrayList(64));
                sameEntryBfRowIds.add(bfRowId2);
                groupByEntryNameMap.put(key, sameEntryBfRowIds);
            }
            HashMap<Long, BFRowId> tempRelationMap = new HashMap<Long, BFRowId>(64);
            bfRowId2 = groupByEntryNameMap.entrySet().iterator();
            while (bfRowId2.hasNext()) {
                Map.Entry entrySet = (Map.Entry)bfRowId2.next();
                String key = (String)entrySet.getKey();
                String[] split = key.split("-");
                sameEntryBfRowIds = (List)entrySet.getValue();
                HashSet<Long> tempBillIds = new HashSet<Long>(64);
                ArrayList<Long> tempRowIds = new ArrayList<Long>(64);
                for (BFRowId bfRowId3 : sameEntryBfRowIds) {
                    tempBillIds.add(bfRowId3.getBillId());
                    tempRowIds.add(bfRowId3.getEntryId());
                }
                List tempDirectBfRows = BFTrackerServiceHelper.loadTargetRowIds((String)split[0], (String)split[1], (Long[])tempBillIds.toArray(new Long[0]), (Long[])tempRowIds.toArray(new Long[0]), (OperateOption)option);
                for (BFRow directBfRow : tempDirectBfRows) {
                    tempRelationMap.put(directBfRow.getSId().getEntryId(), directBfRow.getId());
                }
            }
            Iterator iterator = needAgainQueryMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                Long entryId = (Long)next.getKey();
                BFRowId tarBfRowId = (BFRowId)next.getValue();
                BFRowId ttarBfRowId = (BFRowId)tempRelationMap.get(tarBfRowId.getEntryId());
                if (ttarBfRowId == null) {
                    iterator.remove();
                    continue;
                }
                if (ttarBfRowId.getMainTableId().equals(assignMainTableId)) {
                    Long key = isRow ? entryId : (Long)entry4BillIdMap.get(entryId);
                    Long value = isRow ? ttarBfRowId.getEntryId() : ttarBfRowId.getBillId();
                    List targetBillIds = relationMap.getOrDefault(key, new ArrayList(8));
                    targetBillIds.add(value);
                    relationMap.put(key, targetBillIds);
                    iterator.remove();
                    continue;
                }
                needAgainQueryMap.put(entryId, ttarBfRowId);
            }
            if (needAgainQueryMap.isEmpty()) break;
        }
        logger.info("BOTPRelationReaderService loadNearTargetIds cost time is :" + (System.currentTimeMillis() - begin));
        return relationMap;
    }

    public Map<Long, Map<String, List<Long>>> loadAllSourceIds(String entityNumber, String entryKey, Long[] billIds, Long[] entryIds, boolean isRow) {
        long begin = System.currentTimeMillis();
        HashMap<Long, Map<String, List<Long>>> relationMap = new HashMap<Long, Map<String, List<Long>>>(64);
        List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)entityNumber, (String)entryKey, (Long[])billIds, (Long[])entryIds, (OperateOption)OperateOption.create());
        for (BFRowLinkUpNode bfRowLinkUpNode : bfRowLinkUpNodes) {
            BFRowId rowId = bfRowLinkUpNode.getRowId();
            Long key = isRow ? rowId.getEntryId() : rowId.getBillId();
            Map entityRelationMap = relationMap.getOrDefault(key, new HashMap(8));
            this.findSourceRelationMap(entityRelationMap, bfRowLinkUpNode, isRow, 0);
            relationMap.put(key, entityRelationMap);
        }
        logger.info("BOTPRelationReaderService loadAllSourceIds cost time is :" + (System.currentTimeMillis() - begin));
        return relationMap;
    }

    public Map<Long, Map<String, List<Long>>> loadAllTargetIds(String entityNumber, String entryKey, Long[] billIds, Long[] entryIds, boolean isRow) {
        long begin = System.currentTimeMillis();
        HashMap<Long, Map<String, List<Long>>> relationMap = new HashMap<Long, Map<String, List<Long>>>(64);
        List bfRowLinkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)entityNumber, (String)entryKey, (Long[])billIds, (Long[])entryIds, (OperateOption)OperateOption.create());
        for (BFRowLinkDownNode bfRowLinkDownNode : bfRowLinkDownNodes) {
            BFRowId rowId = bfRowLinkDownNode.getRowId();
            Long key = isRow ? rowId.getEntryId() : rowId.getBillId();
            Map entityRelationMap = relationMap.getOrDefault(key, new HashMap(16));
            this.findTargetRelationMap(entityRelationMap, bfRowLinkDownNode, isRow, 0);
            relationMap.put(key, entityRelationMap);
        }
        logger.info("BOTPRelationReaderService loadAllTargetIds cost time is :" + (System.currentTimeMillis() - begin));
        return relationMap;
    }

    private void findTargetRelationMap(Map<String, List<Long>> entityRelationMap, BFRowLinkDownNode downNode, boolean isRow, int times) {
        if (++times > 100 || ObjectUtils.isEmpty((Object)downNode.getTNodes())) {
            return;
        }
        Map tNodes = downNode.getTNodes();
        for (Map.Entry entrySet : tNodes.entrySet()) {
            BFRowId sRowId = (BFRowId)entrySet.getKey();
            String entityName = this.queryUtil.getEntityNameByMainTableId(sRowId.getMainTableId());
            List upBillIds = entityRelationMap.getOrDefault(entityName, new ArrayList(8));
            upBillIds.add(isRow ? sRowId.getEntryId() : sRowId.getBillId());
            entityRelationMap.put(entityName, upBillIds);
            BFRowLinkDownNode sRowLinkDownNodes = (BFRowLinkDownNode)entrySet.getValue();
            this.findTargetRelationMap(entityRelationMap, sRowLinkDownNodes, isRow, times);
        }
    }

    private void findSourceRelationMap(Map<String, List<Long>> entityRelationMap, BFRowLinkUpNode upNode, boolean isRow, int times) {
        if (++times > 100 || ObjectUtils.isEmpty((Object)upNode.getSNodes())) {
            return;
        }
        Map sNodes = upNode.getSNodes();
        for (Map.Entry entrySet : sNodes.entrySet()) {
            BFRowId sRowId = (BFRowId)entrySet.getKey();
            String entityName = this.queryUtil.getEntityNameByMainTableId(sRowId.getMainTableId());
            List upBillIds = entityRelationMap.getOrDefault(entityName, new ArrayList(8));
            upBillIds.add(isRow ? sRowId.getEntryId() : sRowId.getBillId());
            entityRelationMap.put(entityName, upBillIds);
            BFRowLinkUpNode sRowLinkUpNodes = (BFRowLinkUpNode)entrySet.getValue();
            this.findSourceRelationMap(entityRelationMap, sRowLinkUpNodes, isRow, times);
        }
    }
}

