/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.WriteBackBillQueryHelper;
import kd.fi.arapcommon.helper.WriteOffBillWriteBackHelper;
import kd.fi.arapcommon.service.WriteOffBillWriteBackService;
import kd.fi.arapcommon.util.EmptyUtils;

public class BusBillWriteBackFromFinBillService
implements WriteOffBillWriteBackService {
    private boolean isAr;
    private String entityName;

    @Override
    public void writeBack(List<DynamicObject> writeOffBillList, boolean reverse) {
        this.init(writeOffBillList);
        Map<Long, List<DynamicObject>> srcFinBillIdToAdjustBusBillMap = this.getSrcFinBillIdToAdjustBusBillMap(writeOffBillList, this.isAr);
        ArrayList<DynamicObject> adjustBusBillList = new ArrayList<DynamicObject>(16);
        srcFinBillIdToAdjustBusBillMap.keySet().stream().forEach(key -> adjustBusBillList.addAll((Collection)srcFinBillIdToAdjustBusBillMap.get(key)));
        Map<Long, DynamicObject> billIdToSrcBusBillMap = WriteBackBillQueryHelper.getSourceBusBillIdMap(adjustBusBillList, this.isAr);
        HashMap<Long, DynamicObject> updateSrcBusBill = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject writeOffBill : writeOffBillList) {
            long sourceBillId;
            List<DynamicObject> firstAdjustBusBillList;
            boolean sameSourceBill = WriteBackBillQueryHelper.isSameSourceBill(writeOffBill, this.isAr);
            if (!sameSourceBill || EmptyUtils.isEmpty(firstAdjustBusBillList = srcFinBillIdToAdjustBusBillMap.get(sourceBillId = writeOffBill.getLong("sourcebillid")))) continue;
            for (DynamicObject firstAdjustBusBill : firstAdjustBusBillList) {
                DynamicObject srcBusBill;
                if (EmptyUtils.isEmpty(firstAdjustBusBill) || EmptyUtils.isEmpty(srcBusBill = billIdToSrcBusBillMap.get(firstAdjustBusBill.getLong("sourcebillid")))) continue;
                this.executeWriteBack(writeOffBill, srcBusBill, this.isAr, reverse);
                updateSrcBusBill.put(srcBusBill.getLong("id"), srcBusBill);
            }
        }
        SaveServiceHelper.update((DynamicObject[])updateSrcBusBill.values().toArray(new DynamicObject[0]));
    }

    private void init(List<DynamicObject> writeOffBillList) {
        this.entityName = writeOffBillList.get(0).getDataEntityType().getName();
        if (this.entityName.startsWith("ar_")) {
            this.isAr = true;
        }
    }

    private void executeWriteBack(DynamicObject writeOffBill, DynamicObject srcBusBill, boolean isAr, boolean reverse) {
        this.executeEntryWriteBack(writeOffBill, srcBusBill, isAr, reverse);
        this.headAmtSummarize(srcBusBill);
    }

    private void executeEntryWriteBack(DynamicObject writeOffBill, DynamicObject srcBusBill, boolean isAr, boolean reverse) {
        Map<Long, Long> writeOffDetailEntryIdMap = WriteBackBillQueryHelper.getWriteOffEntryIdToSrcBusEntryIdMap(writeOffBill, srcBusBill, isAr);
        Map entryIdToSrcBusEntryRowMap = srcBusBill.getDynamicObjectCollection("entry").stream().collect(Collectors.toMap(entry -> entry.getLong("id"), Function.identity()));
        Map<String, String> busBillPropertyMap = WriteOffBillWriteBackHelper.getBusBillPropertyMap(isAr);
        Map<String, String> finBillPropertyMap = WriteOffBillWriteBackHelper.getFinBillPropertyMap(isAr);
        DynamicObject payProperty = srcBusBill.getDynamicObject("payproperty");
        for (DynamicObject writeOffEntry : writeOffBill.getDynamicObjectCollection(finBillPropertyMap.get("detailEntry"))) {
            DynamicObject srcBusEntryRow = (DynamicObject)entryIdToSrcBusEntryRowMap.get(writeOffDetailEntryIdMap.get(writeOffEntry.getLong("id")));
            if (EmptyUtils.isEmpty(srcBusBill) || EmptyUtils.isEmpty(srcBusEntryRow)) continue;
            this.propertyAmtWriteBack(writeOffEntry, finBillPropertyMap.get("e_recAmt"), srcBusEntryRow, "e_invoicedamt", reverse);
            this.propertyAmtWriteBack(writeOffEntry, finBillPropertyMap.get("e_recLocalAmt"), srcBusEntryRow, "e_invoicedlocamt", reverse);
            this.propertyAmtWriteBack(writeOffEntry, finBillPropertyMap.get("e_amount"), srcBusEntryRow, "e_invoicednotaxamt", reverse);
            this.propertyAmtWriteBack(writeOffEntry, finBillPropertyMap.get("e_locamt"), srcBusEntryRow, "e_invnotaxlocalamt", reverse);
            BigDecimal recAmount = srcBusEntryRow.getBigDecimal(busBillPropertyMap.get("e_recAmt"));
            BigDecimal amount = srcBusEntryRow.getBigDecimal("e_amount");
            BigDecimal localamt = srcBusEntryRow.getBigDecimal("e_localamt");
            BigDecimal invoiceAmt = srcBusEntryRow.getBigDecimal("e_invoicedamt");
            BigDecimal recLocalAmt = srcBusEntryRow.getBigDecimal(busBillPropertyMap.get("e_recLocalAmt"));
            BigDecimal invoiceLocalAmt = srcBusEntryRow.getBigDecimal("e_invoicedlocamt");
            BigDecimal invnotaxAmt = srcBusEntryRow.getBigDecimal("e_invoicednotaxamt");
            BigDecimal invnotaxLocalAmt = srcBusEntryRow.getBigDecimal("e_invnotaxlocalamt");
            srcBusEntryRow.set("e_uninvoicedamt", (Object)recAmount.subtract(invoiceAmt));
            srcBusEntryRow.set("e_uninvoicedlocamt", (Object)recLocalAmt.subtract(invoiceLocalAmt));
            srcBusEntryRow.set("e_uninvnotaxamt", (Object)amount.subtract(invnotaxAmt));
            srcBusEntryRow.set("e_uninvnotaxlocalamt", (Object)localamt.subtract(invnotaxLocalAmt));
            boolean baseOnAmt = payProperty.getBoolean("isbasedonamt");
            boolean present = srcBusEntryRow.getBoolean("e_ispresent");
            BigDecimal quantity = srcBusEntryRow.getBigDecimal("e_quantity");
            BigDecimal unitprice = srcBusEntryRow.getBigDecimal("e_unitprice");
            if (baseOnAmt) {
                if (present || unitprice.compareTo(BigDecimal.ZERO) == 0) {
                    srcBusEntryRow.set("e_invoicedqty", (Object)(reverse ? quantity : BigDecimal.ZERO));
                } else {
                    srcBusEntryRow.set("e_invoicedqty", (Object)WriteOffBillWriteBackHelper.getInvoiceQty(srcBusEntryRow, isAr));
                }
            } else {
                this.propertyAmtWriteBack(writeOffEntry, finBillPropertyMap.get("e_quantity"), srcBusEntryRow, "e_invoicedqty", reverse);
            }
            BigDecimal invoiceQuantity = srcBusEntryRow.getBigDecimal("e_invoicedqty");
            srcBusEntryRow.set("e_uninvoicedqty", (Object)quantity.subtract(invoiceQuantity));
        }
    }

    private void headAmtSummarize(DynamicObject srcBusBill) {
        WriteOffBillWriteBackHelper.resetHeadAmt(srcBusBill);
    }

    private Map<Long, List<DynamicObject>> getSrcFinBillIdToAdjustBusBillMap(List<DynamicObject> writeOffBillList, boolean isAr) {
        List<DynamicObject> sameSourceAdjustBusBillList = WriteBackBillQueryHelper.listSameSourceAdjustBusBill(writeOffBillList, isAr);
        HashMap<Long, List<DynamicObject>> srcFinBillIdToAdjustBusBillMap = new HashMap<Long, List<DynamicObject>>(16);
        sameSourceAdjustBusBillList.forEach(entity -> {
            List adjustBillList = srcFinBillIdToAdjustBusBillMap.getOrDefault(entity.getLong("srcfinbillid"), new ArrayList(16));
            adjustBillList.add(entity);
            srcFinBillIdToAdjustBusBillMap.put(entity.getLong("srcfinbillid"), adjustBillList);
        });
        return srcFinBillIdToAdjustBusBillMap;
    }

    private void propertyAmtWriteBack(DynamicObject source, String sourceProperty, DynamicObject target, String targetProperty, boolean reverse) {
        BigDecimal sourceAmt = reverse ? source.getBigDecimal(sourceProperty).negate() : source.getBigDecimal(sourceProperty);
        BigDecimal targetAmt = target.getBigDecimal(targetProperty);
        BigDecimal result = targetAmt.add(sourceAmt);
        target.set(targetProperty, (Object)result);
    }
}

