/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ClaimSettleValidateService {
    private static final Log logger = LogFactory.getLog(ClaimSettleValidateService.class);

    public OperationResult claimValidate(List<Map<String, Object>> paramList) {
        logger.info("ClaimSettleValidateService: " + paramList);
        OperationResult result = new OperationResult();
        result.setSuccess(true);
        if (!ObjectUtils.isEmpty(paramList)) {
            List<Map<String, Object>> combineList = this.getComBineParamList(paramList);
            ArrayList<DynamicObject[]> billNos = new ArrayList<DynamicObject[]>(combineList.size());
            for (Map<String, Object> param : combineList) {
                DynamicObject[] coreBillNo = (DynamicObject[])param.get("corebillno");
                billNos.add(coreBillNo);
            }
            if (!ObjectUtils.isEmpty(billNos)) {
                DynamicObject[] arBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"billno,unsettleamount", (QFilter[])new QFilter[]{new QFilter("billno", "in", billNos)});
                ArrayList<String> errorBillNos = new ArrayList<String>(billNos.size());
                for (DynamicObject arBill : arBills) {
                    BigDecimal unSettleAmt = arBill.getBigDecimal("unsettleamount");
                    for (Map<String, Object> param : combineList) {
                        BigDecimal amount = (BigDecimal)param.get("amount");
                        String coreBillNo = (String)param.get("corebillno");
                        if (!arBill.getString("billno").equals(coreBillNo) || unSettleAmt.compareTo(amount) >= 0) continue;
                        errorBillNos.add(coreBillNo);
                    }
                }
                if (!ObjectUtils.isEmpty(errorBillNos)) {
                    result.setSuccess(false);
                    String message = String.format(ResManager.loadKDString((String)"\u5173\u8054\u6838\u5fc3\u5355\u636e\u7f16\u53f7%s\u7684\u8ba4\u9886\u660e\u7ec6\uff0c\u6240\u8ba4\u9886\u7684\u5e94\u6536\u91d1\u989d\u5927\u4e8e\u5176\u5173\u8054\u8d22\u52a1\u5e94\u6536\u5355\u7684\u5e94\u6536\u672a\u7ed3\u7b97\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"ClaimSettleValidateService_0", (String)"fi-arapcommon", (Object[])new Object[0]), String.join((CharSequence)",", errorBillNos));
                    ValidateResultCollection validateResults = result.getValidateResult();
                    ValidateResult validateResult = new ValidateResult();
                    validateResult.setMessage(message);
                    validateResults.addValidateError("", validateResult);
                    result.setValidateResult(validateResults);
                }
            }
        }
        return result;
    }

    private List<Map<String, Object>> getComBineParamList(List<Map<String, Object>> paramList) {
        ArrayList<Map<String, Object>> combineList = new ArrayList<Map<String, Object>>(paramList.size());
        for (Map<String, Object> param : paramList) {
            String coreBillType = (String)param.get("corebilltype");
            if (!"ar_finarbill".equals(coreBillType)) continue;
            String coreBillNo = (String)param.get("corebillno");
            BigDecimal amount = (BigDecimal)param.get("amount");
            boolean contain = false;
            for (Map map : combineList) {
                String combineCoreBillNo = (String)map.get("corebillno");
                BigDecimal combineAmount = (BigDecimal)map.get("amount");
                if (!coreBillNo.equals(combineCoreBillNo)) continue;
                combineAmount = combineAmount.add(amount);
                map.put("amount", combineAmount);
                contain = true;
                break;
            }
            if (contain) continue;
            combineList.add(param);
        }
        return combineList;
    }
}

