/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kd.bos.exception.KDBizException;
import kd.fi.arapcommon.service.rpascheme.entity.MatchStrategyEnum;

public class DimensionValueResolver {
    private static final DateTimeFormatter dateToStringFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static String[] loadValues(Params params, Object dimensionValue) {
        if (dimensionValue == null) {
            throw new KDBizException("dimensionValue can not null");
        }
        String valueString = "";
        if (dimensionValue instanceof BigDecimal) {
            valueString = ((BigDecimal)dimensionValue).stripTrailingZeros().toPlainString();
        } else if (dimensionValue instanceof Date) {
            LocalDateTime localDateTime = LocalDateTime.ofInstant(((Date)dimensionValue).toInstant(), ZoneId.systemDefault());
            valueString = localDateTime.format(dateToStringFormatter);
        } else {
            valueString = dimensionValue.toString();
        }
        String[] result = new String[]{};
        if (!"".equals(valueString)) {
            if (MatchStrategyEnum.EQUAL.getMatchMode().equals(params.getMatchRelation())) {
                result = new String[]{valueString};
            } else {
                String splitSign = params.getSplitSign();
                if (".$|()[{^?*+\\".contains(splitSign)) {
                    splitSign = "\\\\".concat(splitSign).replaceAll("\\\\\\\\", "\\\\");
                }
                result = valueString.split(splitSign);
            }
        }
        return result;
    }

    public static class Params {
        private String matchRelation;
        private String splitSign;

        public Params(String matchRelation, String splitSign) {
            this.matchRelation = matchRelation;
            this.splitSign = splitSign;
        }

        public String getMatchRelation() {
            return this.matchRelation;
        }

        public String getSplitSign() {
            return this.splitSign;
        }

        public void setMatchRelation(String matchRelation) {
            this.matchRelation = matchRelation;
        }

        public void setSplitSign(String splitSign) {
            this.splitSign = splitSign;
        }
    }
}

