/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryEntityDto;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.enums.SettleLogExecStatusEnum;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.MutexLockHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.ISchemeSettleService;
import kd.fi.arapcommon.service.SettleServiceProxy;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.LoadBillForSettleSchemeHelper;
import kd.fi.arapcommon.service.helper.SettleLogHelper;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public abstract class SchemeSettleService
implements ISchemeSettleService {
    protected static final Log logger = LogFactory.getLog(SchemeSettleService.class);
    private static final int SETTLE_BATCH_SIZE = 10000;
    private static final Integer entryName_ONE = 1;
    private static final Integer entryName_ZERO = 0;
    private Map<Long, Object> isSubmitSettleMaps = new HashMap<Long, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schemeSettle(DynamicObject scheme) throws KDBizException {
        HashSet<Long> idSet = new HashSet<Long>(1);
        idSet.add(scheme.getLong("id"));
        MutexLockHelper.requireMutex(scheme.getDataEntityType().getName(), idSet, "settle", ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u6b63\u5728\u6267\u884c\u667a\u80fd\u7ed3\u7b97\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"SchemeSettleService_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        DynamicObjectCollection ruleEntrys = scheme.getDynamicObjectCollection("ruleentry");
        DynamicObjectCollection orgEntrys = scheme.getDynamicObjectCollection("orgentry");
        String schemeEntity = scheme.getDataEntityType().getName();
        boolean isAr = "ar_settlescheme".equals(schemeEntity);
        String paramKey = isAr ? "ar_016" : "ap_016";
        List<Long> orgids = orgEntrys.stream().map(e -> e.getLong("org.id")).collect(Collectors.toList());
        this.isSubmitSettleMaps = SystemParameterHelper.batchGetAppParameter(isAr, orgids, paramKey);
        DynamicObject settleLog = SettleLogHelper.newSettleLog4Scheme(scheme, this.getSettleLogEntity());
        for (DynamicObject orgEntry : orgEntrys) {
            for (DynamicObject rule : ruleEntrys) {
                DynamicObject entryLog = null;
                TXHandle tx = TX.requiresNew((String)"schemesettle");
                Throwable throwable = null;
                try {
                    try {
                        DynamicObject org = orgEntry.getDynamicObject("org");
                        long orgId = org.getLong("id");
                        entryLog = SettleLogHelper.newLogEntry(settleLog, rule.getString("settlerelation"), orgId);
                        this.doProcess(rule, orgId, entryLog);
                    }
                    catch (Throwable exc) {
                        tx.markRollback();
                        settleLog.set("isexception", (Object)Boolean.TRUE);
                        String message = exc.getMessage();
                        String[] errorMsgArray = message.split("#");
                        if (entryLog == null) continue;
                        entryLog.set("settlerecordcount", (Object)errorMsgArray[1]);
                        entryLog.set("e_isexception", (Object)Boolean.TRUE);
                        String errorMsg = errorMsgArray[0];
                        entryLog.set("exceptioninfo", (Object)errorMsg.substring(0, Math.min(errorMsg.length() - 1, 250)));
                        entryLog.set("exceptioninfo_tag", (Object)message);
                    }
                    finally {
                        SettleLogHelper.saveSettleLog4Scheme(settleLog);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
        }
        DynamicObjectCollection entryEntity = settleLog.getDynamicObjectCollection("entryentity");
        if (entryEntity.stream().anyMatch(row -> row.getBoolean("e_isexception"))) {
            settleLog.set("executestatus", (Object)SettleLogExecStatusEnum.FAILED.getValue());
        } else {
            settleLog.set("executestatus", (Object)SettleLogExecStatusEnum.DONE.getValue());
        }
        settleLog.set("endtime", (Object)new Date());
        SettleLogHelper.saveSettleLog4Scheme(settleLog);
        MutexLockHelper.batchRelease(scheme.getDataEntityType().getName(), idSet, "settle");
    }

    /*
     * WARNING - void declaration
     */
    protected void doProcess(DynamicObject schemeRule, long orgId, DynamicObject entryLog) {
        String timeOrder = schemeRule.getString("timeorder");
        String settleRelation = schemeRule.getString("settlerelation");
        String matchFieldInfo = schemeRule.getString("matchfieldinfo");
        String asstbill = schemeRule.getString("asstbill");
        String mainFilter = schemeRule.getString("mainfilter_tag");
        String asstFilter = schemeRule.getString("asstfilter_tag");
        String mainDateSrc = StringUtils.isEmpty(schemeRule.getString("maindatesrc")) ? "bizdate" : schemeRule.getString("maindatesrc");
        String asstDateSrc = StringUtils.isEmpty(schemeRule.getString("asstdatesrc")) ? "bizdate" : schemeRule.getString("asstdatesrc");
        HashSet<String> mainMatchFields = new HashSet<String>(64);
        HashSet<String> asstMatchFields = new HashSet<String>(64);
        List<Map<String, Object>> fieldEntrys = new ArrayList(1);
        if (StringUtils.isNotEmpty(matchFieldInfo)) {
            fieldEntrys = (List)SerializationUtils.fromJsonString((String)matchFieldInfo, List.class);
            for (Map map : fieldEntrys) {
                String mainField = (String)map.get("mainfield");
                mainMatchFields.add(mainField);
                String asstField = (String)map.get("asstfield");
                asstMatchFields.add(asstField);
            }
        }
        mainMatchFields.add(mainDateSrc);
        asstMatchFields.add(asstDateSrc);
        String mainExtraSelector = String.join((CharSequence)",", mainMatchFields);
        String string = String.join((CharSequence)",", asstMatchFields);
        String mainNumber = LoadBillForSettleSchemeHelper.getMainNumber(settleRelation, SettleTypeEnum.MATCH.getValue());
        String asstNumber = LoadBillForSettleSchemeHelper.getAsstNumber(settleRelation, SettleTypeEnum.MATCH.getValue(), timeOrder, orgId, string, asstFilter, asstbill);
        boolean isSubmitSettle = this.getIsSubmitSettleParam(orgId, settleRelation);
        QFilter mainQFilter = LoadBillForSettleSchemeHelper.buildQFilter(mainNumber, timeOrder, orgId, mainExtraSelector, mainFilter, isSubmitSettle);
        QFilter asstQFilter = LoadBillForSettleSchemeHelper.buildQFilter(asstNumber, timeOrder, orgId, string, asstFilter, asstbill, isSubmitSettle);
        String mainSelector = LoadBillForSettleSchemeHelper.buildSelector(mainNumber, timeOrder, orgId, mainExtraSelector, mainFilter);
        String asstSelector = LoadBillForSettleSchemeHelper.buildSelector(asstNumber, timeOrder, orgId, string, asstFilter, asstbill);
        boolean isLoadPartner = this.isLoadPartner(settleRelation);
        Map<String, List<LoadBillForSettleSchemeHelper.EntryInfo>> billMainMap = LoadBillForSettleSchemeHelper.getBillMapByAsstactId(mainNumber, mainQFilter, isLoadPartner, timeOrder);
        Map<String, List<LoadBillForSettleSchemeHelper.EntryInfo>> billAsstMap = LoadBillForSettleSchemeHelper.getBillMapByAsstactId(asstNumber, asstQFilter, isLoadPartner, timeOrder);
        StringBuilder errorMsg = new StringBuilder();
        if (billMainMap.size() > 0 && billAsstMap.size() > 0) {
            AbstractSettleTemplate service = this.getSettleService(settleRelation);
            AbstractSettleTemplate serviceProxy = (AbstractSettleTemplate)new SettleServiceProxy().createObj(service, entryLog);
            SettleSchemeVO schemeVO = new SettleSchemeVO();
            schemeVO.setSettle(true);
            schemeVO.setSchemeSettle(true);
            schemeVO.setSettleRelation(settleRelation);
            schemeVO.setMatchFieldMap(fieldEntrys);
            int settleParam = 1;
            if ("ar_finarbill".equals(mainNumber) || "cas_recbill".equals(mainNumber)) {
                settleParam = ArApHelper.getArSettleParam(orgId);
            } else if ("ap_finapbill".equals(mainNumber) || "cas_paybill".equals(mainNumber)) {
                settleParam = ArApHelper.getApSettleParam(orgId);
            }
            schemeVO.setSettleEntryParam(settleParam);
            int asstSettleParam = settleParam;
            if (SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation)) {
                if ("ar_finarbill".equals(asstNumber)) {
                    asstSettleParam = ArApHelper.getArSettleParam(orgId);
                } else if ("ap_finapbill".equals(asstNumber)) {
                    asstSettleParam = ArApHelper.getApSettleParam(orgId);
                }
                schemeVO.setAsstSettleEntryParam(asstSettleParam);
            }
            int settleBatchSize = this.getSettleBatchSize();
            HashSet<Object> mainIds = new HashSet<Object>(settleBatchSize);
            ArrayList<Object> mainEntryIds = new ArrayList<Object>(settleBatchSize);
            HashSet<Object> asstIds = new HashSet<Object>(settleBatchSize);
            ArrayList<Object> asstEntryIds = new ArrayList<Object>(settleBatchSize);
            HashSet<Long> logCount = new HashSet<Long>();
            for (Map.Entry<String, List<LoadBillForSettleSchemeHelper.EntryInfo>> next : billMainMap.entrySet()) {
                void var45_45;
                String key = next.getKey();
                List<LoadBillForSettleSchemeHelper.EntryInfo> mainEntryInfos = next.getValue();
                if (billAsstMap.get(key) == null) continue;
                for (LoadBillForSettleSchemeHelper.EntryInfo entryInfo : mainEntryInfos) {
                    logCount.add(entryInfo.getId());
                }
                entryLog.set("maincount", (Object)(entryLog.getInt("maincount") + logCount.size()));
                entryLog.set("mainentrycount", (Object)(entryLog.getInt("mainentrycount") + mainEntryInfos.size()));
                logCount.clear();
                List<LoadBillForSettleSchemeHelper.EntryInfo> asstEntryInfos = billAsstMap.get(key);
                for (LoadBillForSettleSchemeHelper.EntryInfo entryInfo3 : asstEntryInfos) {
                    logCount.add(entryInfo3.getId());
                }
                entryLog.set("asstcount", (Object)(entryLog.getInt("asstcount") + logCount.size()));
                entryLog.set("asstentrycount", (Object)(entryLog.getInt("asstentrycount") + asstEntryInfos.size()));
                logCount.clear();
                boolean bl = false;
                int batchSize = mainEntryInfos.size();
                while (var45_45 < batchSize) {
                    List<LoadBillForSettleSchemeHelper.EntryInfo> entryInfos = mainEntryInfos.subList((int)var45_45, Math.min(batchSize, (int)(var45_45 + settleBatchSize)));
                    for (LoadBillForSettleSchemeHelper.EntryInfo entryInfo4 : entryInfos) {
                        mainIds.add(entryInfo4.getId());
                        mainEntryIds.add(entryInfo4.getEntryId());
                    }
                    int asstBatchSize = asstEntryInfos.size();
                    for (int j = 0; j < asstBatchSize; j += settleBatchSize) {
                        List<LoadBillForSettleSchemeHelper.EntryInfo> asstEntryInfoSub = asstEntryInfos.subList(j, Math.min(asstBatchSize, j + settleBatchSize));
                        for (LoadBillForSettleSchemeHelper.EntryInfo entryInfo0 : asstEntryInfoSub) {
                            asstIds.add(entryInfo0.getId());
                            asstEntryIds.add(entryInfo0.getEntryId());
                        }
                        try (TXHandle tx = TX.requiresNew((String)"schemebatchsettle");){
                            try {
                                Set<Long> mainIdSet = mainIds.stream().map(v -> (Long)v).collect(Collectors.toSet());
                                Set<Long> asstIdSet = asstIds.stream().map(v -> (Long)v).collect(Collectors.toSet());
                                CommonSettleServiceHelper.settleAddMutexCtrlInTX(mainIdSet, mainNumber, asstIdSet, asstNumber, false);
                                DynamicObject[] mainBills = LoadBillForSettleSchemeHelper.getBill(mainNumber, mainSelector, mainIds, mainEntryIds);
                                DynamicObject[] asstBills = LoadBillForSettleSchemeHelper.getBill(asstNumber, asstSelector, asstIds, asstEntryIds);
                                schemeVO.setMainFieldValueMap(this.getMatchFieldMap(mainBills, mainMatchFields, schemeVO, true));
                                schemeVO.setAsstFieldValueMap(this.getMatchFieldMap(asstBills, asstMatchFields, schemeVO, false));
                                this.processBillAmt(mainBills, asstBills, settleRelation);
                                serviceProxy.setScheme(schemeVO);
                                List<BillSettleVO> mainListVO = serviceProxy.getMainListVO(mainBills);
                                List<BillSettleVO> asstListVO = serviceProxy.getAsstListVO(asstBills);
                                this.sortMainOrAsstVO(mainListVO, mainBills, settleParam, mainDateSrc, timeOrder);
                                this.sortMainOrAsstVO(asstListVO, asstBills, asstSettleParam, asstDateSrc, timeOrder);
                                serviceProxy.settleByVO(mainListVO, asstListVO, schemeVO, SettleTypeEnum.MATCH.getValue());
                                mainBills = null;
                                asstBills = null;
                            }
                            catch (Throwable e) {
                                tx.markRollback();
                                String message = e.getMessage();
                                if (!errorMsg.toString().contains(message)) {
                                    errorMsg.append(message).append('\n');
                                }
                            }
                        }
                        asstIds.clear();
                        asstEntryIds.clear();
                    }
                    mainIds.clear();
                    mainEntryIds.clear();
                    var45_45 += settleBatchSize;
                }
            }
        }
        if (!ObjectUtils.isEmpty((Object)errorMsg)) {
            throw new KDBizException(errorMsg.append('#').append(entryLog.getInt("settlerecordcount")).toString());
        }
    }

    private boolean getIsSubmitSettleParam(long orgId, String settleRelation) {
        boolean isSubmitSettle = false;
        if (((Boolean)this.isSubmitSettleMaps.get(orgId)).booleanValue() && ("recsettle".equals(settleRelation) || "appaysettle".equals(settleRelation))) {
            isSubmitSettle = true;
        }
        return isSubmitSettle;
    }

    private int getSettleBatchSize() {
        String settleBatchSize = StdConfig.get("schemesettle.batchsize");
        return settleBatchSize == null ? 10000 : Integer.parseInt(settleBatchSize);
    }

    private void sortMainOrAsstVO(List<BillSettleVO> vos, DynamicObject[] dos, int settleParam, String dateSrc, String timeOrder) {
        Map<Long, Date> dateMap = this.getDateMapOfEntryId(dos, settleParam, dateSrc);
        vos.forEach(v -> {
            Long entryId = v.getEntryId();
            v.setSortDate(dateMap.get(entryId) != null ? (Date)dateMap.get(entryId) : new Date());
        });
        vos.sort((o1, o2) -> {
            if ("asc".equals(timeOrder)) {
                return o1.getSortDate().compareTo(o2.getSortDate());
            }
            return o2.getSortDate().compareTo(o1.getSortDate());
        });
    }

    private Map<Long, Date> getDateMapOfEntryId(DynamicObject[] mains, int settleParam, String dateSrc) {
        Map<Long, Date> dateMap;
        String entityName;
        switch (entityName = mains[0].getDataEntityType().getName()) {
            case "ar_finarbill": {
                dateMap = this.resolveArAndApDateMap(mains, settleParam, dateSrc, "entry", "planentity");
                break;
            }
            case "ap_finapbill": {
                dateMap = this.resolveArAndApDateMap(mains, settleParam, dateSrc, "detailentry", "planentity");
                break;
            }
            default: {
                dateMap = this.resolveRecAndPayDateMap(mains, dateSrc, "entry");
            }
        }
        return dateMap;
    }

    private Map<Long, Date> resolveArAndApDateMap(DynamicObject[] mains, int settleParam, String dateSrc, String ... entryName) {
        HashMap<Long, Date> dateMap = new HashMap<Long, Date>(8);
        boolean isEntry = dateSrc.contains(".");
        if (isEntry) {
            dateSrc = dateSrc.split("\\.")[1];
        }
        String detailentry = entryName[entryName_ZERO];
        String planentry = entryName[entryName_ONE];
        if (1 == settleParam) {
            for (DynamicObject main : mains) {
                DynamicObjectCollection mainEntrys = main.getDynamicObjectCollection(detailentry);
                for (DynamicObject mainEntry : mainEntrys) {
                    BigDecimal unSettleAmt;
                    String unsettleamt = "e_unsettleamt";
                    if ("detailentry".equals(detailentry)) {
                        unsettleamt = "unsettleamt";
                    }
                    if ((unSettleAmt = mainEntry.getBigDecimal(unsettleamt)).compareTo(BigDecimal.ZERO) == 0) continue;
                    dateMap.put(mainEntry.getLong("id"), isEntry ? mainEntry.getDate(dateSrc) : main.getDate(dateSrc));
                }
            }
        } else {
            for (DynamicObject main : mains) {
                DynamicObjectCollection mainEntrys = main.getDynamicObjectCollection(planentry);
                for (DynamicObject planEntry : mainEntrys) {
                    BigDecimal unSettleAmt = planEntry.getBigDecimal("unplansettleamt");
                    if (unSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    dateMap.put(planEntry.getLong("id"), isEntry ? planEntry.getDate(dateSrc) : main.getDate(dateSrc));
                }
            }
        }
        return dateMap;
    }

    private Map<Long, Date> resolveRecAndPayDateMap(DynamicObject[] mains, String dateSrc, String ... entryName) {
        HashMap<Long, Date> dateMap = new HashMap<Long, Date>(8);
        boolean isEntry = dateSrc.contains(".");
        if (isEntry) {
            dateSrc = dateSrc.split("\\.")[1];
        }
        String entry = entryName[entryName_ZERO];
        for (DynamicObject main : mains) {
            DynamicObjectCollection asstEntrys = main.getDynamicObjectCollection(entry);
            for (DynamicObject asstEntry : asstEntrys) {
                BigDecimal unSettleAmt = asstEntry.getBigDecimal("e_unsettledamt");
                if (unSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                dateMap.put(asstEntry.getLong("id"), isEntry ? asstEntry.getDate(dateSrc) : main.getDate(dateSrc));
            }
        }
        return dateMap;
    }

    protected void processBillAmt(DynamicObject[] mains, DynamicObject[] assts, String settleRelation) {
        String mainEntityName = mains[0].getDataEntityType().getName();
        String asstEntityName = assts[0].getDataEntityType().getName();
        if ("ap_finapbill".equals(mainEntityName)) {
            this.processApBillAmt(mains);
        } else if ("ar_finarbill".equals(mainEntityName)) {
            this.processArBillAmt(mains);
        }
        if ("ap_finapbill".equals(asstEntityName)) {
            this.processApBillAmt(assts);
        } else if ("ar_finarbill".equals(asstEntityName)) {
            this.processArBillAmt(assts);
        }
    }

    protected void processApBillAmt(DynamicObject[] objs) {
        for (DynamicObject obj : objs) {
            DynamicObjectCollection entrys = obj.getDynamicObjectCollection("detailentry");
            for (DynamicObject entry : entrys) {
                entry.set("settledamt", entry.get("lockedamt"));
                entry.set("unsettleamt", entry.get("unlockamt"));
            }
            DynamicObjectCollection planEntrys = obj.getDynamicObjectCollection("planentity");
            for (DynamicObject entry : planEntrys) {
                entry.set("plansettledamt", entry.get("planlockedamt"));
                entry.set("unplansettleamt", entry.get("unplanlockamt"));
            }
        }
    }

    protected void processArBillAmt(DynamicObject[] objs) {
        for (DynamicObject obj : objs) {
            DynamicObjectCollection entrys = obj.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                entry.set("e_settledamt", entry.get("e_lockedamt"));
                entry.set("e_unsettleamt", entry.get("e_unlockamt"));
            }
            DynamicObjectCollection planEntrys = obj.getDynamicObjectCollection("planentity");
            for (DynamicObject entry : planEntrys) {
                entry.set("plansettledamt", entry.get("planlockedamt"));
                entry.set("unplansettleamt", entry.get("unplanlockamt"));
            }
        }
    }

    private boolean isLoadPartner(String settleRelation) {
        boolean result = false;
        if (SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.PAYRECSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.RECPAYSETTLE.getValue().equals(settleRelation)) {
            result = true;
        }
        return result;
    }

    protected abstract AbstractSettleTemplate getSettleService(String var1);

    protected abstract String getSettleLogEntity();

    private Map<Long, Map<String, Object>> getMatchFieldMap(DynamicObject[] objs, Set<String> matchFields, SettleSchemeVO schemeVO, boolean isMain) {
        HashMap map = null;
        if (matchFields != null) {
            map = new HashMap();
            boolean isPlanSettle = schemeVO.getSettleEntryParam() == 2;
            String settleRelation = schemeVO.getSettleRelation();
            if (!isMain && (SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation))) {
                isPlanSettle = schemeVO.getAsstSettleEntryParam() == 2;
            }
            for (DynamicObject obj : objs) {
                EntityType dataEntityType = (EntityType)obj.getDataEntityType();
                List entryEntities = EntityTypeUtil.getEntryEntities((EntityType)dataEntityType);
                String entryKey = ((EntryEntityDto)entryEntities.get(1)).getKey();
                if (isPlanSettle) {
                    for (EntryEntityDto entryDto : entryEntities) {
                        if (!entryDto.getKey().contains("plan")) continue;
                        entryKey = entryDto.getKey();
                        break;
                    }
                }
                DynamicObjectCollection entrys = obj.getDynamicObjectCollection(entryKey);
                for (DynamicObject entry : entrys) {
                    HashMap<String, Object> plainDataMap = new HashMap<String, Object>();
                    for (String fieldName : matchFields) {
                        if (fieldName.startsWith(entryKey)) {
                            plainDataMap.put(fieldName, entry.get(fieldName.substring(entryKey.length() + 1)));
                            continue;
                        }
                        plainDataMap.put(fieldName, obj.get(fieldName));
                    }
                    map.put(entry.getLong("id"), plainDataMap);
                }
            }
        }
        return map;
    }

    private boolean isSettleSelf(String settleRelation) {
        return SettleRelationEnum.APSELF.getValue().equals(settleRelation) || SettleRelationEnum.PAYTRANS.getValue().equals(settleRelation) || SettleRelationEnum.ARSELF.getValue().equals(settleRelation) || SettleRelationEnum.ARTRANSFER.getValue().equals(settleRelation) || SettleRelationEnum.PAYSELF.getValue().equals(settleRelation) || SettleRelationEnum.RECSELF.getValue().equals(settleRelation);
    }

    private Set<Long> getBillIdSet(Map<String, List<LoadBillForSettleSchemeHelper.EntryInfo>> billMap) {
        HashSet<Long> billIdSet = new HashSet<Long>(8);
        for (Map.Entry<String, List<LoadBillForSettleSchemeHelper.EntryInfo>> next : billMap.entrySet()) {
            String key = next.getKey();
            List<LoadBillForSettleSchemeHelper.EntryInfo> value = next.getValue();
            for (LoadBillForSettleSchemeHelper.EntryInfo entryInfo : value) {
                billIdSet.add(entryInfo.getId());
            }
        }
        return billIdSet;
    }
}

