/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ToleranceMatchService {
    public List<Map<String, Object>> getResultByToleranceType(String controller, String contraster, String controlitem, String contrastitem, List<Map<String, Object>> params) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        if (params.size() == 0) {
            return result;
        }
        DynamicObject toleranceType = BusinessDataServiceHelper.loadSingle((String)"ap_tolerancetype", (String)"id", (QFilter[])new QFilter[]{new QFilter("controller", "=", (Object)controller), new QFilter("contraster", "=", (Object)contraster), new QFilter("controlitem", "=", (Object)controlitem), new QFilter("contrastitem", "=", (Object)contrastitem), new QFilter("enable", "=", (Object)Boolean.TRUE)});
        if (toleranceType == null) {
            return result;
        }
        Long toleranceTypeId = toleranceType.getLong("id");
        DynamicObject toleranceScheme = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_tolerancescheme", (QFilter[])new QFilter[]{new QFilter("controller", "=", (Object)controller), new QFilter("contraster", "=", (Object)contraster), new QFilter("enable", "=", (Object)Boolean.TRUE)});
        if (toleranceScheme == null) {
            return result;
        }
        DynamicObjectCollection entry = toleranceScheme.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            Long rowToleranceTypeId = row.getDynamicObject("e_tolerancetypeid").getLong("id");
            if (!toleranceTypeId.equals(rowToleranceTypeId)) continue;
            this.matchAndCompare(controlitem, contrastitem, row, params, result);
            break;
        }
        return result;
    }

    public Map<String, Object> getAllResult(String controller, String contraster, String controlitem, String contrastitem, List<Map<String, Object>> params) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (params.size() == 0) {
            return result;
        }
        List pks = params.stream().map(v -> v.get("pk")).collect(Collectors.toList());
        HashMap<String, Object> noToleranceMap = new HashMap<String, Object>(16);
        noToleranceMap.put("failtomatch", pks);
        DynamicObject toleranceType = BusinessDataServiceHelper.loadSingle((String)"ap_tolerancetype", (String)"id", (QFilter[])new QFilter[]{new QFilter("controller", "=", (Object)controller), new QFilter("contraster", "=", (Object)contraster), new QFilter("controlitem", "=", (Object)controlitem), new QFilter("contrastitem", "=", (Object)contrastitem), new QFilter("enable", "=", (Object)Boolean.TRUE)});
        if (toleranceType == null) {
            return noToleranceMap;
        }
        Long toleranceTypeId = toleranceType.getLong("id");
        DynamicObject toleranceScheme = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_tolerancescheme", (QFilter[])new QFilter[]{new QFilter("controller", "=", (Object)controller), new QFilter("contraster", "=", (Object)contraster), new QFilter("enable", "=", (Object)Boolean.TRUE), new QFilter("entry.e_tolerancetypeid", "=", (Object)toleranceTypeId)});
        if (toleranceScheme == null) {
            return noToleranceMap;
        }
        DynamicObjectCollection entry = toleranceScheme.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            Long rowToleranceTypeId = row.getDynamicObject("e_tolerancetypeid").getLong("id");
            if (!toleranceTypeId.equals(rowToleranceTypeId)) continue;
            return this.matchAndCompare(controlitem, contrastitem, row, params);
        }
        return result;
    }

    /*
     * Could not resolve type clashes
     */
    private Map<String, Object> matchAndCompare(String controlitem, String contrastitem, DynamicObject row, List<Map<String, Object>> params) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        String toleranceDim = row.getString("e_tolerancedim");
        String limittolerancetype = row.getString("e_limittolerancetype");
        String uptolerancetype = row.getString("e_uptolerancetype");
        ArrayList<Object> tolerancePks = new ArrayList<Object>(16);
        String[] toleranceDims = new String[]{};
        DynamicObjectCollection subEntry = row.getDynamicObjectCollection("subentry");
        if (toleranceDim != null && !"".equals(toleranceDim)) {
            toleranceDims = toleranceDim.substring(1).split(",");
            Map<String, List<Map<String, Object>>> paramGroupByDim = this.getParamGroupByDim(params, toleranceDims);
            if (paramGroupByDim.size() == 0) {
                ArrayList<Object> failToMatchPks = new ArrayList<Object>(16);
                for (Map<String, Object> paramMap : params) {
                    failToMatchPks.add(paramMap.get("pk"));
                }
                result.put("failtomatch", failToMatchPks);
                return result;
            }
            ArrayList<Map<String, Object>> toleranceLimits = new ArrayList<Map<String, Object>>(16);
            ArrayList<Map<String, Object>> toleranceUps = new ArrayList<Map<String, Object>>(16);
            this.sortToleranceRanges(toleranceLimits, toleranceUps, row);
            for (Map.Entry<String, List<Map<String, Object>>> entrySet : paramGroupByDim.entrySet()) {
                ArrayList overTolerancePks;
                boolean isContainsOne;
                List values;
                Map dimPks;
                Object dimValues;
                boolean isMatch;
                boolean canMatch = false;
                ArrayList<Map<String, Object>> overResult = new ArrayList<Map<String, Object>>(16);
                List<Map<String, Object>> value = entrySet.getValue();
                Map<String, Object> param = value.get(0);
                for (Object map : toleranceUps) {
                    isMatch = true;
                    for (String dim : toleranceDims) {
                        dimValues = param.get(dim);
                        dimPks = (Map)map.get(dim);
                        if (dimValues == null || "".equals(dimValues)) {
                            if (dimPks == null || dimPks.size() == 0) continue;
                            isMatch = false;
                            break;
                        }
                        if (dimValues instanceof List) {
                            values = (List)dimValues;
                            isContainsOne = false;
                            if (dimPks.size() == 0) continue;
                            for (Long dataId : values) {
                                if (dimPks.get(dataId) == null) continue;
                                isContainsOne = true;
                                break;
                            }
                            if (isContainsOne) continue;
                            isMatch = false;
                            continue;
                        }
                        if (dimPks == null || dimPks.size() == 0 || dimPks.get((Long)param.get(dim)) != null) continue;
                        isMatch = false;
                        break;
                    }
                    if (!isMatch) continue;
                    Object toleranceUp = (BigDecimal)map.get("uptolerance");
                    canMatch = true;
                    if ("notctrl".equals(uptolerancetype)) continue;
                    this.compareUpTolerance(controlitem, contrastitem, (BigDecimal)toleranceUp, value, uptolerancetype, overResult, tolerancePks);
                    break;
                }
                if (!canMatch) {
                    Object map;
                    List<Object> failToMatchPks = (List)result.get("failtomatch");
                    if (failToMatchPks == null) {
                        failToMatchPks = new ArrayList(16);
                    }
                    map = value.iterator();
                    while (map.hasNext()) {
                        Map paramMap = (Map)map.next();
                        failToMatchPks.add(paramMap.get("pk"));
                    }
                    result.put("failtomatch", failToMatchPks);
                    continue;
                }
                for (Object map : toleranceLimits) {
                    isMatch = true;
                    for (String dim : toleranceDims) {
                        dimValues = param.get(dim);
                        dimPks = (Map)map.get(dim);
                        if (dimValues == null || "".equals(dimValues)) {
                            if (dimPks == null || dimPks.size() == 0) continue;
                            isMatch = false;
                            break;
                        }
                        if (dimValues instanceof List) {
                            values = (List)dimValues;
                            isContainsOne = false;
                            if (dimPks.size() == 0) continue;
                            for (Long dataId : values) {
                                if (dimPks.get(dataId) == null) continue;
                                isContainsOne = true;
                                break;
                            }
                            if (isContainsOne) continue;
                            isMatch = false;
                            continue;
                        }
                        if (dimPks == null || dimPks.size() == 0 || dimPks.get((Long)param.get(dim)) != null) continue;
                        isMatch = false;
                        break;
                    }
                    if (!isMatch) continue;
                    BigDecimal toleranceLimit = (BigDecimal)map.get("tolerancelimit");
                    if ("notctrl".equals(limittolerancetype)) continue;
                    this.compareLimitTolerance(controlitem, contrastitem, toleranceLimit, value, limittolerancetype, overResult, tolerancePks);
                    break;
                }
                if ((overTolerancePks = (ArrayList)result.get("overpks")) == null) {
                    overTolerancePks = new ArrayList(16);
                }
                for (Map paramMap : overResult) {
                    overTolerancePks.add(paramMap.get("pk"));
                }
                if (overTolerancePks.size() <= 0) continue;
                result.put("overpks", overTolerancePks);
            }
        } else {
            ArrayList<Map<String, Object>> overResult = new ArrayList<Map<String, Object>>(16);
            if (!"notctrl".equals(uptolerancetype)) {
                BigDecimal upTolerance = null;
                for (DynamicObject entry : subEntry) {
                    BigDecimal entryUpTolerance = entry.getBigDecimal("s_uptolerance");
                    if (upTolerance == null) {
                        upTolerance = entryUpTolerance;
                        continue;
                    }
                    upTolerance = upTolerance.compareTo(entryUpTolerance) > 0 ? entryUpTolerance : upTolerance;
                }
                this.compareUpTolerance(controlitem, contrastitem, upTolerance, params, uptolerancetype, overResult, tolerancePks);
            }
            if (!"notctrl".equals(limittolerancetype)) {
                BigDecimal limitolerance = null;
                for (DynamicObject entry : subEntry) {
                    BigDecimal entryLimitTolerance = entry.getBigDecimal("s_limittolerance");
                    if (limitolerance == null) {
                        limitolerance = entryLimitTolerance;
                        continue;
                    }
                    limitolerance = limitolerance.compareTo(entryLimitTolerance) > 0 ? entryLimitTolerance : limitolerance;
                }
                this.compareLimitTolerance(controlitem, contrastitem, limitolerance, params, limittolerancetype, overResult, tolerancePks);
            }
            ArrayList overTolerancePks = new ArrayList(16);
            for (Map paramMap : overResult) {
                overTolerancePks.add(paramMap.get("pk"));
            }
            if (overTolerancePks.size() > 0) {
                result.put("overpks", overTolerancePks);
            }
        }
        return result;
    }

    public List<Map<String, Object>> getResultByToleranceScheme(String controller, String contraster, List<Map<String, Object>> params) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        HashMap<String, ArrayList<Map<String, Object>>> paramSplitByToleranceType = new HashMap<String, ArrayList<Map<String, Object>>>(8);
        for (Map<String, Object> map : params) {
            String controlitem = (String)map.get("controlitem");
            String contrastitem = (String)map.get("contrastitem");
            String itemKey = controlitem + "_" + contrastitem;
            ArrayList<Map<String, Object>> itemList = (ArrayList<Map<String, Object>>)paramSplitByToleranceType.get(itemKey);
            if (itemList == null) {
                itemList = new ArrayList<Map<String, Object>>(16);
                itemList.add(map);
                paramSplitByToleranceType.put(itemKey, itemList);
                continue;
            }
            itemList.add(map);
        }
        for (Map.Entry entry : paramSplitByToleranceType.entrySet()) {
            List paramGroupByToleranceType = (List)entry.getValue();
            String controlitem = (String)((Map)paramGroupByToleranceType.get(0)).get("controlitem");
            String contrastitem = (String)((Map)paramGroupByToleranceType.get(0)).get("contrastitem");
            result.addAll(this.getResultByToleranceType(controller, contraster, controlitem, contrastitem, paramGroupByToleranceType));
        }
        return result;
    }

    public List<Map<String, Object>> matchAndCompareComm(DynamicObject toleranceScheme, String controlitem, String contrastitem, List<Map<String, Object>> params) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        DynamicObjectCollection entryColl = toleranceScheme.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entryColl) {
            DynamicObject toleranceType = entry.getDynamicObject("e_tolerancetypeid");
            String queryControlitem = toleranceType.getString("controlitem");
            String queryContrastitem = toleranceType.getString("contrastitem");
            boolean enable = toleranceType.getBoolean("enable");
            if (!enable || !controlitem.equals(queryControlitem) || !contrastitem.equals(queryContrastitem)) continue;
            this.matchAndCompare(controlitem, contrastitem, entry, params, result);
        }
        return result;
    }

    private Map<String, List<Map<String, Object>>> getParamGroupByDim(List<Map<String, Object>> params, String[] toleranceDims) {
        HashMap<String, List<Map<String, Object>>> paramGroupByDim = new HashMap<String, List<Map<String, Object>>>(16);
        for (Map<String, Object> param : params) {
            StringBuilder matchKey = null;
            for (String dim : toleranceDims) {
                if (!param.containsKey(dim)) {
                    matchKey = null;
                    break;
                }
                Object dimValues = param.get(dim);
                if (dimValues == null || "".equals(dimValues)) {
                    if (matchKey == null) {
                        matchKey = new StringBuilder("null");
                        continue;
                    }
                    matchKey.append('_').append("null");
                    continue;
                }
                if (dimValues instanceof List) {
                    List dimList = (List)dimValues;
                    List dimStrList = dimList.stream().map(v -> String.valueOf(v)).collect(Collectors.toList());
                    if (matchKey == null) {
                        matchKey = new StringBuilder(String.join((CharSequence)"_", dimStrList));
                        continue;
                    }
                    matchKey.append('_').append(String.valueOf(dimValues));
                    continue;
                }
                if (matchKey == null) {
                    matchKey = new StringBuilder(String.valueOf(param.get(dim)));
                    continue;
                }
                matchKey.append('_').append(String.valueOf(param.get(dim)));
            }
            if (matchKey == null) continue;
            ArrayList<Map<String, Object>> paramList = (ArrayList<Map<String, Object>>)paramGroupByDim.get(matchKey.toString());
            if (paramList == null) {
                paramList = new ArrayList<Map<String, Object>>(16);
                paramList.add(param);
                paramGroupByDim.put(matchKey.toString(), paramList);
                continue;
            }
            paramList.add(param);
        }
        return paramGroupByDim;
    }

    private void sortToleranceRanges(List<Map<String, Object>> toleranceLimits, List<Map<String, Object>> toleranceUps, DynamicObject row) {
        DynamicObjectCollection subEntry = row.getDynamicObjectCollection("subentry");
        String dimensionMap = row.getString("e_dimensionmap");
        Map toleranceDimMap = (Map)SerializationUtils.fromJsonString((String)dimensionMap, Map.class);
        for (DynamicObject entry : subEntry) {
            HashMap<String, Serializable> rowToleranceLimit = new HashMap<String, Serializable>(16);
            HashMap<String, Serializable> rowToleranceUp = new HashMap<String, Serializable>(16);
            for (Map.Entry entrySet : toleranceDimMap.entrySet()) {
                if (!((String)entrySet.getValue()).endsWith("_pk")) continue;
                String dimensionKey = ((String)entrySet.getValue()).substring(0, ((String)entrySet.getValue()).length() - 3);
                String dimensionValues = entry.getString((String)entrySet.getKey());
                List dimensionPkList = Stream.of(dimensionValues.split(",")).collect(Collectors.toList());
                HashMap<Long, String> dimensionPkLongList = new HashMap<Long, String>(8);
                for (String pk : dimensionPkList) {
                    if ("".equals(pk)) continue;
                    dimensionPkLongList.put(Long.valueOf(pk), pk);
                }
                rowToleranceLimit.put(dimensionKey, dimensionPkLongList);
                rowToleranceUp.put(dimensionKey, dimensionPkLongList);
            }
            rowToleranceLimit.put("tolerancelimit", entry.getBigDecimal("s_limittolerance"));
            toleranceLimits.add(rowToleranceLimit);
            rowToleranceUp.put("uptolerance", entry.getBigDecimal("s_uptolerance"));
            toleranceUps.add(rowToleranceUp);
        }
        this.sortToleranceList(toleranceLimits, "tolerancelimit");
        this.sortToleranceList(toleranceUps, "uptolerance");
    }

    private void matchAndCompare(String controlitem, String contrastitem, DynamicObject row, List<Map<String, Object>> params, List<Map<String, Object>> result) {
        String toleranceDim = row.getString("e_tolerancedim");
        String limittolerancetype = row.getString("e_limittolerancetype");
        String uptolerancetype = row.getString("e_uptolerancetype");
        ArrayList<Object> tolerancePks = new ArrayList<Object>(16);
        String[] toleranceDims = new String[]{};
        DynamicObjectCollection subEntry = row.getDynamicObjectCollection("subentry");
        if (toleranceDim != null && !"".equals(toleranceDim)) {
            toleranceDims = toleranceDim.substring(1).split(",");
            Map<String, List<Map<String, Object>>> paramGroupByDim = this.getParamGroupByDim(params, toleranceDims);
            ArrayList<Map<String, Object>> toleranceLimits = new ArrayList<Map<String, Object>>(16);
            ArrayList<Map<String, Object>> toleranceUps = new ArrayList<Map<String, Object>>(16);
            this.sortToleranceRanges(toleranceLimits, toleranceUps, row);
            block0: for (Map.Entry<String, List<Map<String, Object>>> entrySet : paramGroupByDim.entrySet()) {
                boolean isContainsOne;
                List values;
                Map dimPks;
                Object dimValues;
                boolean isMatch;
                List<Map<String, Object>> value = entrySet.getValue();
                Map<String, Object> param = value.get(0);
                for (Map map : toleranceUps) {
                    isMatch = true;
                    for (String dim : toleranceDims) {
                        dimValues = param.get(dim);
                        dimPks = (Map)map.get(dim);
                        if (dimValues == null || "".equals(dimValues)) {
                            if (dimPks == null || dimPks.size() == 0) continue;
                            isMatch = false;
                            break;
                        }
                        if (dimValues instanceof List) {
                            values = (List)dimValues;
                            isContainsOne = false;
                            if (dimPks.size() == 0) continue;
                            for (Long dataId : values) {
                                if (dimPks.get(dataId) == null) continue;
                                isContainsOne = true;
                                break;
                            }
                            if (isContainsOne) continue;
                            isMatch = false;
                            continue;
                        }
                        if (dimPks == null || dimPks.size() == 0 || dimPks.get((Long)param.get(dim)) != null) continue;
                        isMatch = false;
                        break;
                    }
                    if (!isMatch || "notctrl".equals(uptolerancetype)) continue;
                    BigDecimal bigDecimal = (BigDecimal)map.get("uptolerance");
                    this.compareUpTolerance(controlitem, contrastitem, bigDecimal, value, uptolerancetype, result, tolerancePks);
                    break;
                }
                for (Map map : toleranceLimits) {
                    isMatch = true;
                    for (String dim : toleranceDims) {
                        dimValues = param.get(dim);
                        dimPks = (Map)map.get(dim);
                        if (dimValues == null || "".equals(dimValues)) {
                            if (dimPks == null || dimPks.size() == 0) continue;
                            isMatch = false;
                            break;
                        }
                        if (dimValues instanceof List) {
                            values = (List)dimValues;
                            isContainsOne = false;
                            if (dimPks.size() == 0) continue;
                            for (Long dataId : values) {
                                if (dimPks.get(dataId) == null) continue;
                                isContainsOne = true;
                                break;
                            }
                            if (isContainsOne) continue;
                            isMatch = false;
                            continue;
                        }
                        if (dimPks == null || dimPks.size() == 0 || dimPks.get((Long)param.get(dim)) != null) continue;
                        isMatch = false;
                        break;
                    }
                    if (!isMatch || "notctrl".equals(limittolerancetype)) continue;
                    BigDecimal bigDecimal = (BigDecimal)map.get("tolerancelimit");
                    this.compareLimitTolerance(controlitem, contrastitem, bigDecimal, value, limittolerancetype, result, tolerancePks);
                    continue block0;
                }
            }
        } else {
            if (!"notctrl".equals(uptolerancetype)) {
                BigDecimal upTolerance = null;
                for (DynamicObject entry : subEntry) {
                    BigDecimal entryUpTolerance = entry.getBigDecimal("s_uptolerance");
                    if (upTolerance == null) {
                        upTolerance = entryUpTolerance;
                        continue;
                    }
                    upTolerance = upTolerance.compareTo(entryUpTolerance) > 0 ? entryUpTolerance : upTolerance;
                }
                this.compareUpTolerance(controlitem, contrastitem, upTolerance, params, uptolerancetype, result, tolerancePks);
            }
            if (!"notctrl".equals(limittolerancetype)) {
                BigDecimal limitolerance = null;
                for (DynamicObject entry : subEntry) {
                    BigDecimal entryLimitTolerance = entry.getBigDecimal("s_limittolerance");
                    if (limitolerance == null) {
                        limitolerance = entryLimitTolerance;
                        continue;
                    }
                    limitolerance = limitolerance.compareTo(entryLimitTolerance) > 0 ? entryLimitTolerance : limitolerance;
                }
                this.compareLimitTolerance(controlitem, contrastitem, limitolerance, params, limittolerancetype, result, tolerancePks);
            }
        }
    }

    public void compareLimitTolerance(String controlitem, String contrastitem, BigDecimal toleranceLimit, List<Map<String, Object>> params, String limitTolerancetype, List<Map<String, Object>> result, List<Object> tolerancePks) {
        for (Map<String, Object> paramMap : params) {
            HashMap<String, Object> excessMap;
            Object tolerancePk = paramMap.get("pk");
            if (tolerancePks.contains(tolerancePk)) continue;
            BigDecimal controlValue = (BigDecimal)paramMap.get("controlvalue");
            BigDecimal contrastValue = (BigDecimal)paramMap.get("contrastvalue");
            int contrastDirection = contrastValue.signum();
            int precision = (Integer)paramMap.get("precision");
            BigDecimal subsidenceValue = "percent".equals(limitTolerancetype) ? contrastValue.abs().multiply(BigDecimal.ONE.subtract(toleranceLimit.divide(new BigDecimal("100")).setScale(10, RoundingMode.HALF_UP))).setScale(precision, RoundingMode.HALF_UP) : contrastValue.abs().subtract(toleranceLimit).setScale(precision, RoundingMode.HALF_UP);
            if (contrastDirection == -1 && controlValue.compareTo(subsidenceValue.negate()) > 0) {
                excessMap = new HashMap<String, Object>(8);
                excessMap.put("pk", paramMap.get("pk"));
                excessMap.put("isoverup", Boolean.TRUE);
                excessMap.put("controlitem", controlitem);
                excessMap.put("contrastitem", contrastitem);
                excessMap.put("overupvalue", controlValue.subtract(subsidenceValue).abs());
                result.add(excessMap);
                tolerancePks.add(paramMap.get("pk"));
                continue;
            }
            if (contrastDirection == -1 || controlValue.compareTo(subsidenceValue) >= 0) continue;
            excessMap = new HashMap(8);
            excessMap.put("pk", paramMap.get("pk"));
            excessMap.put("isoverlower", Boolean.TRUE);
            excessMap.put("controlitem", controlitem);
            excessMap.put("contrastitem", contrastitem);
            excessMap.put("overlowervalue", subsidenceValue.subtract(controlValue));
            result.add(excessMap);
            tolerancePks.add(paramMap.get("pk"));
        }
    }

    public void compareUpTolerance(String controlitem, String contrastitem, BigDecimal toleranceUp, List<Map<String, Object>> params, String upTolerancetype, List<Map<String, Object>> result, List<Object> tolerancePks) {
        for (Map<String, Object> paramMap : params) {
            HashMap<String, Object> excessMap;
            Object tolerancePk = paramMap.get("pk");
            if (tolerancePks.contains(tolerancePk)) continue;
            BigDecimal controlValue = (BigDecimal)paramMap.get("controlvalue");
            BigDecimal contrastValue = (BigDecimal)paramMap.get("contrastvalue");
            int contrastDirection = contrastValue.signum();
            int precision = (Integer)paramMap.get("precision");
            BigDecimal subsidenceValue = "percent".equals(upTolerancetype) ? contrastValue.abs().multiply(toleranceUp.divide(new BigDecimal("100")).setScale(10, RoundingMode.HALF_UP).add(BigDecimal.ONE)).setScale(precision, RoundingMode.HALF_UP) : contrastValue.abs().add(toleranceUp).setScale(precision, RoundingMode.HALF_UP);
            if (contrastDirection == -1 && controlValue.compareTo(subsidenceValue.negate()) < 0) {
                excessMap = new HashMap<String, Object>(8);
                excessMap.put("pk", paramMap.get("pk"));
                excessMap.put("isoverlower", Boolean.TRUE);
                excessMap.put("controlitem", controlitem);
                excessMap.put("contrastitem", contrastitem);
                excessMap.put("overlowervalue", subsidenceValue.subtract(controlValue));
                result.add(excessMap);
                tolerancePks.add(paramMap.get("pk"));
                continue;
            }
            if (contrastDirection == -1 || controlValue.compareTo(subsidenceValue) <= 0) continue;
            excessMap = new HashMap(8);
            excessMap.put("pk", paramMap.get("pk"));
            excessMap.put("isoverup", Boolean.TRUE);
            excessMap.put("controlitem", controlitem);
            excessMap.put("contrastitem", contrastitem);
            excessMap.put("overupvalue", controlValue.subtract(subsidenceValue));
            result.add(excessMap);
            tolerancePks.add(paramMap.get("pk"));
        }
    }

    public void sortToleranceList(List<Map<String, Object>> toleranceList, final String tolranceType) {
        Collections.sort(toleranceList, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                return ((BigDecimal)o1.get(tolranceType)).compareTo((BigDecimal)o2.get(tolranceType));
            }
        });
    }
}

